/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activecluster.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.codehaus.activecluster.Cluster;
import org.codehaus.activecluster.ClusterListener;
import org.codehaus.activecluster.LocalNode;
import org.codehaus.activecluster.impl.StateConsumer;
import org.codehaus.activecluster.impl.StateServiceImpl;

public class DefaultCluster
implements Cluster {
    private StateServiceImpl stateService;
    private LocalNode localNode;
    private Topic destination;
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private List nodes = new ArrayList();
    private MessageConsumer consumer;

    public DefaultCluster(LocalNode localNode, Topic dataTopic, Topic destination, Connection connection, Session session, MessageProducer producer) throws JMSException {
        this.stateService = new StateServiceImpl(this);
        this.localNode = localNode;
        this.destination = destination;
        this.connection = connection;
        this.session = session;
        this.producer = producer;
        this.consumer = session.createConsumer((Destination)dataTopic);
        this.consumer.setMessageListener((MessageListener)new StateConsumer(this.stateService));
    }

    public synchronized void addClusterListener(ClusterListener listener) {
        this.stateService.addClusterListener(listener);
    }

    public synchronized void removeClusterListener(ClusterListener listener) {
        this.stateService.removeClusterListener(listener);
    }

    public Topic getDestination() {
        return this.destination;
    }

    public LocalNode getLocalNode() {
        return this.localNode;
    }

    public Map getNodes() {
        return this.stateService.getNodes();
    }

    public synchronized void send(Destination destination, Message message) throws JMSException {
        this.producer.send(destination, message);
    }

    public synchronized MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.getSession().createConsumer(destination);
    }

    public synchronized Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public synchronized BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public synchronized MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public synchronized ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public synchronized ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.getSession().createObjectMessage(object);
    }

    public synchronized StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public synchronized TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public synchronized TextMessage createTextMessage(String text) throws JMSException {
        return this.getSession().createTextMessage(text);
    }

    public synchronized void start() throws JMSException {
        this.connection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        try {
            this.connection.stop();
            this.connection.close();
        }
        finally {
            this.connection = null;
            this.session = null;
        }
    }

    protected Session getSession() throws JMSException {
        if (this.session == null) {
            throw new JMSException("Cannot perform operation, this cluster connection is now closed");
        }
        return this.session;
    }
}

