/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activecluster.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Destination;
import org.codehaus.activecluster.Cluster;
import org.codehaus.activecluster.ClusterEvent;
import org.codehaus.activecluster.ClusterListener;
import org.codehaus.activecluster.Node;
import org.codehaus.activecluster.impl.StateService;

public class StateServiceImpl
implements StateService {
    private Cluster cluster;
    private Map nodes = new HashMap();
    private long inactiveTime = 5000L;
    private List listeners = Collections.synchronizedList(new ArrayList());

    public StateServiceImpl(Cluster cluster) {
        this.cluster = cluster;
    }

    public StateServiceImpl(Cluster cluster, Timer timer) {
        this(cluster);
        long delay = this.inactiveTime / 2L;
        timer.scheduleAtFixedRate(this.createTimerTask(), delay, delay);
    }

    public long getInactiveTime() {
        return this.inactiveTime;
    }

    public void setInactiveTime(long inactiveTime) {
        this.inactiveTime = inactiveTime;
    }

    public synchronized Map getNodes() {
        return new HashMap(this.nodes);
    }

    public synchronized void keepAlive(Node node) {
        Destination key = node.getDestination();
        NodeEntry currentNode = (NodeEntry)this.nodes.get(key);
        if (currentNode == null) {
            currentNode = new NodeEntry();
            currentNode.node = node;
            this.nodes.put(key, currentNode);
            this.nodeAdded(node);
        } else {
            this.nodeUpdated(node);
        }
        currentNode.lastKeepAlive = this.getTimeMillis();
    }

    public synchronized void checkForTimeouts() {
        long time = this.getTimeMillis();
        Iterator iter = this.nodes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            NodeEntry nodeEntry = (NodeEntry)entry.getValue();
            if (nodeEntry.lastKeepAlive + this.inactiveTime >= time) continue;
            iter.remove();
            this.nodeRemoved(nodeEntry.node);
        }
    }

    public TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                StateServiceImpl.this.checkForTimeouts();
            }
        };
    }

    public void addClusterListener(ClusterListener listener) {
        this.listeners.add(listener);
    }

    public void removeClusterListener(ClusterListener listener) {
        this.listeners.remove(listener);
    }

    protected void nodeAdded(Node node) {
        ClusterEvent event = new ClusterEvent(this.cluster, node, 1);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onNodeAdd(event);
        }
    }

    protected void nodeUpdated(Node node) {
        ClusterEvent event = new ClusterEvent(this.cluster, node, 2);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onNodeUpdate(event);
        }
    }

    protected void nodeRemoved(Node node) {
        ClusterEvent event = new ClusterEvent(this.cluster, node, 3);
        Object[] array = this.listeners.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            ClusterListener listener = (ClusterListener)array[i];
            listener.onNodeRemove(event);
        }
    }

    protected long getTimeMillis() {
        return System.currentTimeMillis();
    }

    protected static class NodeEntry {
        public Node node;
        public long lastKeepAlive;

        protected NodeEntry() {
        }
    }
}

