/*
 * Decompiled with CFR 0.152.
 */
package kontent.ai.delivery.generators;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.lang.model.element.Modifier;
import kontent.ai.delivery.ContentItemMapping;
import kontent.ai.delivery.ContentType;
import kontent.ai.delivery.ContentTypesListingResponse;
import kontent.ai.delivery.DeliveryClient;
import kontent.ai.delivery.Element;
import kontent.ai.delivery.ElementMapping;
import kontent.ai.delivery.System;

public class CodeGenerator {
    private static final String DELIVERY_PACKAGE = "kontent.ai.delivery";
    private static final String JAVA_UTIL_PACKAGE = "java.util";
    private static final String SYSTEM = "system";
    String projectId;
    String packageName;
    File outputDir;

    public CodeGenerator(String projectId, String packageName, File outputDir) {
        this.projectId = projectId;
        this.packageName = packageName;
        this.outputDir = outputDir;
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new UnsupportedOperationException(String.format("Unable to create directory %s", outputDir.getAbsolutePath()));
        }
        if (!outputDir.isDirectory()) {
            throw new UnsupportedOperationException(String.format("%s exists and is not a directory", outputDir.getAbsolutePath()));
        }
    }

    public List<JavaFile> generateSources() throws ExecutionException, InterruptedException {
        return this.generateSources(new DeliveryClient(this.projectId));
    }

    public List<JavaFile> generateSources(DeliveryClient client) throws ExecutionException, InterruptedException {
        return this.generateSources(((ContentTypesListingResponse)client.getTypes().toCompletableFuture().get()).getTypes());
    }

    public List<JavaFile> generateSources(List<ContentType> types) {
        ArrayList<JavaFile> sources = new ArrayList<JavaFile>();
        for (ContentType type : types) {
            sources.add(this.generateSource(type));
        }
        return sources;
    }

    public JavaFile generateSource(ContentType type) {
        ArrayList<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        for (Map.Entry entry : type.getElements().entrySet()) {
            ClassName typeName = null;
            switch (((Element)entry.getValue()).getType()) {
                case "text": 
                case "rich_text": 
                case "url_slug": 
                case "custom": {
                    typeName = ClassName.get(String.class);
                    break;
                }
                case "number": {
                    typeName = ClassName.get(Double.class);
                    break;
                }
                case "multiple_choice": {
                    typeName = ParameterizedTypeName.get((ClassName)ClassName.get((String)JAVA_UTIL_PACKAGE, (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)DELIVERY_PACKAGE, (String)"Option", (String[])new String[0])});
                    break;
                }
                case "date_time": {
                    typeName = ClassName.get(ZonedDateTime.class);
                    break;
                }
                case "asset": {
                    typeName = ParameterizedTypeName.get((ClassName)ClassName.get((String)JAVA_UTIL_PACKAGE, (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)DELIVERY_PACKAGE, (String)"Asset", (String[])new String[0])});
                    break;
                }
                case "modular_content": {
                    typeName = ParameterizedTypeName.get((ClassName)ClassName.get((String)JAVA_UTIL_PACKAGE, (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)DELIVERY_PACKAGE, (String)"ContentItem", (String[])new String[0])});
                    break;
                }
                case "taxonomy": {
                    typeName = ParameterizedTypeName.get((ClassName)ClassName.get((String)JAVA_UTIL_PACKAGE, (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)DELIVERY_PACKAGE, (String)"Taxonomy", (String[])new String[0])});
                    break;
                }
            }
            if (typeName == null) continue;
            String fieldName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, (String)entry.getKey());
            Class annoClass = ((Element)entry.getValue()).getType() == "modular_content" ? ContentItemMapping.class : ElementMapping.class;
            fieldSpecs.add(FieldSpec.builder((TypeName)typeName, (String)fieldName, (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(annoClass).addMember("value", "$S", new Object[]{entry.getKey()}).build()).build());
            String getterName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "get_" + (String)entry.getKey());
            methodSpecs.add(MethodSpec.methodBuilder((String)getterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)typeName).addStatement("return $N", new Object[]{fieldName}).build());
            String setterName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "set_" + (String)entry.getKey());
            methodSpecs.add(MethodSpec.methodBuilder((String)setterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)typeName, fieldName, new Modifier[0]).addStatement("this.$N = $N", new Object[]{fieldName, fieldName}).build());
        }
        fieldSpecs.add(FieldSpec.builder((TypeName)ClassName.get(System.class), (String)SYSTEM, (Modifier[])new Modifier[0]).build());
        methodSpecs.add(MethodSpec.methodBuilder((String)"getSystem").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(System.class)).addStatement("return $N", new Object[]{SYSTEM}).build());
        methodSpecs.add(MethodSpec.methodBuilder((String)"setSystem").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(System.class), SYSTEM, new Modifier[0]).addStatement("this.$N = $N", new Object[]{SYSTEM, SYSTEM}).build());
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.getSystem().getCodename())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("This code was generated by a <a href=\"https://github.com/kontent-ai/java-packages/tree/master/delivery-sdk-generators\">delivery-sdk-generators tool</a>\n", new Object[0]).addJavadoc("\n", new Object[0]).addJavadoc("Changes to this file may cause incorrect behavior and will be lost if the code is regenerated.\n", new Object[0]).addJavadoc("For further modifications of the class, create a separate file and extend this class.\n", new Object[0]).addAnnotation(AnnotationSpec.builder(ContentItemMapping.class).addMember("value", "$S", new Object[]{type.getSystem().getCodename()}).build());
        for (FieldSpec fieldSpec : fieldSpecs) {
            typeSpecBuilder.addField(fieldSpec);
        }
        for (MethodSpec methodSpec : methodSpecs) {
            typeSpecBuilder.addMethod(methodSpec);
        }
        TypeSpec typeSpec = typeSpecBuilder.build();
        return JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).build();
    }

    public void writeSources(List<JavaFile> sources) throws IOException {
        for (JavaFile source : sources) {
            this.writeSource(source);
        }
    }

    public void writeSource(JavaFile source) throws IOException {
        source.writeTo(this.outputDir);
    }
}

