/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTaskProgressMonitor;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.CompilerDef;
import net.sf.antcontrib.cpptasks.CompilerEnum;
import net.sf.antcontrib.cpptasks.DependencyTable;
import net.sf.antcontrib.cpptasks.FileVisitor;
import net.sf.antcontrib.cpptasks.LinkerDef;
import net.sf.antcontrib.cpptasks.ObjectFileCollector;
import net.sf.antcontrib.cpptasks.OutputTypeEnum;
import net.sf.antcontrib.cpptasks.PrecompileDef;
import net.sf.antcontrib.cpptasks.ProcessorDef;
import net.sf.antcontrib.cpptasks.RuntimeType;
import net.sf.antcontrib.cpptasks.SubsystemEnum;
import net.sf.antcontrib.cpptasks.TargetHistoryTable;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.TargetMatcher;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.LinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import net.sf.antcontrib.cpptasks.types.CompilerArgument;
import net.sf.antcontrib.cpptasks.types.ConditionalFileSet;
import net.sf.antcontrib.cpptasks.types.DefineSet;
import net.sf.antcontrib.cpptasks.types.IncludePath;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import net.sf.antcontrib.cpptasks.types.LinkerArgument;
import net.sf.antcontrib.cpptasks.types.SystemIncludePath;
import net.sf.antcontrib.cpptasks.types.SystemLibrarySet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;

public class CCTask
extends Task {
    private final CompilerDef compilerDef = new CompilerDef();
    private final LinkerDef linkerDef = new LinkerDef();
    private static final ProcessorConfiguration[] EMPTY_CONFIG_ARRAY = new ProcessorConfiguration[0];
    private final LinkType linkType = new LinkType();
    private int dependencyDepth = -1;
    private File _outfile;
    private File _objDir;
    private String dataset;
    private Vector _libsets = new Vector();
    private Vector _compilers = new Vector();
    private Vector _linkers = new Vector();
    private boolean relentless;

    public void setObjdir(File dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        this._objDir = dir;
    }

    public File getObjdir() {
        return this._objDir;
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.compilerDef.setProject(project);
        this.linkerDef.setProject(project);
    }

    public void addFileset(ConditionalFileSet srcSet) {
        this.compilerDef.addFileset(srcSet);
    }

    public IncludePath createIncludePath() {
        return this.compilerDef.createIncludePath();
    }

    public SystemIncludePath createSysIncludePath() {
        return this.compilerDef.createSysIncludePath();
    }

    public void addConfiguredCompiler(CompilerDef compiler) {
        if (compiler == null) {
            throw new NullPointerException("compiler");
        }
        compiler.setProject(this.project);
        this._compilers.addElement(compiler);
    }

    public void addConfiguredLinker(LinkerDef linker) {
        if (linker == null) {
            throw new NullPointerException("linker");
        }
        linker.setProject(this.project);
        this._linkers.addElement(linker);
    }

    public void setDebug(boolean debug) {
        this.compilerDef.setDebug(debug);
        this.linkerDef.setDebug(debug);
    }

    public void setLibtool(boolean libtool) {
        this.compilerDef.setLibtool(libtool);
        this.linkerDef.setLibtool(libtool);
    }

    public void setMultithreaded(boolean multi) {
        this.compilerDef.setMultithreaded(multi);
    }

    public void setExceptions(boolean exceptions) {
        this.compilerDef.setExceptions(exceptions);
    }

    public void setRebuild(boolean rebuildAll) {
        this.compilerDef.setRebuild(rebuildAll);
        this.linkerDef.setRebuild(rebuildAll);
    }

    public void setDependencyDepth(int depth) {
        this.dependencyDepth = depth;
    }

    public PrecompileDef createPrecompile() throws BuildException {
        return this.compilerDef.createPrecompile();
    }

    public void setLink(OutputTypeEnum outputType) {
        this.linkType.setOutputType(outputType);
    }

    public void setOuttype(OutputTypeEnum outputType) {
        this.linkType.setOutputType(outputType);
    }

    public void addConfiguredCompilerArg(CompilerArgument arg) {
        this.compilerDef.addConfiguredCompilerArg(arg);
    }

    public void addConfiguredLinkerArg(LinkerArgument arg) {
        this.linkerDef.addConfiguredLinkerArg(arg);
    }

    public void addConfiguredDefineset(DefineSet defs) {
        this.compilerDef.addConfiguredDefineset(defs);
    }

    public void setOutfile(File outfile) {
        if (outfile == null || outfile.toString().length() > 0) {
            this._outfile = outfile;
        }
    }

    public File getOutfile() {
        return this._outfile;
    }

    public void setSubsystem(SubsystemEnum subsystem) {
        if (subsystem == null) {
            throw new NullPointerException("subsystem");
        }
        this.linkType.setSubsystem(subsystem);
    }

    public void addSyslibset(SystemLibrarySet libset) {
        if (libset == null) {
            throw new NullPointerException("libset");
        }
        this.linkerDef.addSyslibset(libset);
    }

    public void addLibset(LibrarySet libset) {
        if (libset == null) {
            throw new NullPointerException("libset");
        }
        this.linkerDef.addLibset(libset);
    }

    public void setRelentless(boolean relentless) {
        this.relentless = relentless;
    }

    public void setName(CompilerEnum name) {
        this.compilerDef.setName(name);
        Processor compiler = this.compilerDef.getProcessor();
        Linker linker = compiler.getLinker(this.linkType);
        this.linkerDef.setProcessor(linker);
    }

    public void setClassname(String classname) {
        this.compilerDef.setClassname(classname);
        this.linkerDef.setClassname(classname);
    }

    private Hashtable getTargets(LinkerConfiguration linkerConfig, Vector objectFiles) {
        Hashtable targets = new Hashtable(1000);
        Vector<ProcessorConfiguration> biddingProcessors = new Vector<ProcessorConfiguration>(this._compilers.size());
        int i = 0;
        while (i < this._compilers.size()) {
            CompilerDef currentCompilerDef = (CompilerDef)((Object)this._compilers.elementAt(i));
            if (currentCompilerDef.isActive()) {
                ProcessorConfiguration config = currentCompilerDef.createConfiguration(this, this.linkType, this.compilerDef);
                PrecompileDef precompileDef = currentCompilerDef.getActivePrecompile(this.compilerDef);
                ProcessorConfiguration[] localConfigs = new ProcessorConfiguration[]{config};
                if (precompileDef != null) {
                    File prototype = precompileDef.getPrototype();
                    if (!prototype.exists()) {
                        throw new BuildException("prototype (" + prototype.toString() + ") does not exist.");
                    }
                    if (prototype.isDirectory()) {
                        throw new BuildException("prototype (" + prototype.toString() + ") is a directory.");
                    }
                    String[] exceptFiles = precompileDef.getExceptFiles();
                    CompilerConfiguration[] configs = ((CompilerConfiguration)config).createPrecompileConfigurations(prototype, exceptFiles);
                    if (configs != null && configs.length == 2) {
                        TargetMatcher matcher = new TargetMatcher(this, this._objDir, new ProcessorConfiguration[]{configs[0]}, linkerConfig, objectFiles, targets);
                        matcher.visit(new File(prototype.getParent()), prototype.getName());
                        biddingProcessors.addElement(configs[1]);
                        localConfigs = new ProcessorConfiguration[]{configs[1], config};
                    }
                }
                if (currentCompilerDef.hasFileSets()) {
                    TargetMatcher matcher = new TargetMatcher(this, this._objDir, localConfigs, linkerConfig, objectFiles, targets);
                    currentCompilerDef.visitFiles(matcher);
                }
                biddingProcessors.addElement(config);
            }
            ++i;
        }
        ProcessorConfiguration config = this.compilerDef.createConfiguration(this, this.linkType, null);
        biddingProcessors.addElement(config);
        Object[] bidders = new ProcessorConfiguration[biddingProcessors.size()];
        biddingProcessors.copyInto(bidders);
        TargetMatcher matcher = new TargetMatcher(this, this._objDir, (ProcessorConfiguration[])bidders, linkerConfig, objectFiles, targets);
        this.compilerDef.visitFiles(matcher);
        return targets;
    }

    public static Hashtable getTargetsToBuildByConfiguration(Hashtable targets) {
        Hashtable<ProcessorConfiguration, Vector<TargetInfo>> targetsByConfig = new Hashtable<ProcessorConfiguration, Vector<TargetInfo>>();
        Enumeration targetEnum = targets.elements();
        while (targetEnum.hasMoreElements()) {
            TargetInfo target = (TargetInfo)targetEnum.nextElement();
            if (!target.getRebuild()) continue;
            Vector<TargetInfo> targetsForSameConfig = (Vector<TargetInfo>)targetsByConfig.get(target.getConfiguration());
            if (targetsForSameConfig != null) {
                targetsForSameConfig.addElement(target);
                continue;
            }
            targetsForSameConfig = new Vector<TargetInfo>();
            targetsForSameConfig.addElement(target);
            targetsByConfig.put(target.getConfiguration(), targetsForSameConfig);
        }
        return targetsByConfig;
    }

    public void execute() throws BuildException {
        block20: {
            if (this._objDir == null && this._outfile != null) {
                this._objDir = new File(this._outfile.getParent());
            }
            if (!this._objDir.exists()) {
                throw new BuildException("Object directory does not exist");
            }
            TargetHistoryTable objHistory = new TargetHistoryTable(this, this._objDir);
            Vector objectFiles = new Vector();
            Vector sysObjectFiles = new Vector();
            LinkerConfiguration linkerConfig = this.collectExplicitObjectFiles(objectFiles, sysObjectFiles);
            Hashtable targets = this.getTargets(linkerConfig, objectFiles);
            TargetInfo linkTarget = null;
            if (this._outfile != null) {
                linkTarget = this.getLinkTarget(linkerConfig, objectFiles, sysObjectFiles, targets);
            }
            objHistory.markForRebuild(targets);
            CCTaskProgressMonitor monitor = new CCTaskProgressMonitor(objHistory);
            int rebuildCount = this.checkForChangedIncludeFiles(targets);
            if (rebuildCount > 0) {
                Vector targetsForConfig;
                BuildException compileException = null;
                Hashtable targetsByConfig = CCTask.getTargetsToBuildByConfiguration(targets);
                Vector[] targetVectors = new Vector[targetsByConfig.size()];
                int index = 0;
                Enumeration targetVectorEnum = targetsByConfig.elements();
                while (targetVectorEnum.hasMoreElements()) {
                    targetsForConfig = (Vector)targetVectorEnum.nextElement();
                    CompilerConfiguration config = (CompilerConfiguration)((TargetInfo)targetsForConfig.elementAt(0)).getConfiguration();
                    if (!config.isPrecompileGeneration()) continue;
                    targetVectors[index++] = targetsForConfig;
                }
                targetVectorEnum = targetsByConfig.elements();
                block7: while (targetVectorEnum.hasMoreElements()) {
                    targetsForConfig = (Vector)targetVectorEnum.nextElement();
                    int i = 0;
                    while (i < targetVectors.length) {
                        if (targetVectors[i] == targetsForConfig) continue block7;
                        if (targetVectors[i] == null) {
                            targetVectors[i] = targetsForConfig;
                            continue block7;
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < targetVectors.length) {
                    Vector targetsForConfig2 = targetVectors[i];
                    CompilerConfiguration config = (CompilerConfiguration)((TargetInfo)targetsForConfig2.elementAt(0)).getConfiguration();
                    String[] sourceFiles = new String[targetsForConfig2.size()];
                    Enumeration targetsEnum = targetsForConfig2.elements();
                    index = 0;
                    while (targetsEnum.hasMoreElements()) {
                        TargetInfo targetInfo = (TargetInfo)targetsEnum.nextElement();
                        sourceFiles[index++] = targetInfo.getSources()[0].toString();
                    }
                    try {
                        config.compile(this, this._objDir, sourceFiles, this.relentless, monitor);
                    }
                    catch (BuildException ex) {
                        if (compileException == null) {
                            compileException = ex;
                        }
                        if (!this.relentless) break;
                    }
                    ++i;
                }
                try {
                    objHistory.commit();
                }
                catch (IOException ex) {
                    this.log("Error writing history.xml: " + ex.toString());
                }
                if (compileException != null) {
                    throw compileException;
                }
            }
            if (this.dependencyDepth >= 0) {
                throw new BuildException("All files at depth " + Integer.toString(this.dependencyDepth) + " from changes successfully compiled.\n" + "Remove or change dependencyDepth to -1 to perform full compilation.");
            }
            if (linkTarget == null) break block20;
            TargetHistoryTable linkHistory = this.getLinkHistory(objHistory);
            linkHistory.markForRebuild(linkTarget);
            if (linkTarget.getRebuild()) {
                this.log("Starting link");
                LinkerConfiguration linkConfig = (LinkerConfiguration)linkTarget.getConfiguration();
                linkConfig.link(this, linkTarget);
                linkHistory.update(linkTarget);
                try {
                    linkHistory.commit();
                }
                catch (IOException ex) {
                    this.log("Error writing link history.xml: " + ex.toString());
                }
            }
        }
    }

    protected LinkerConfiguration collectExplicitObjectFiles(Vector objectFiles, Vector sysObjectFiles) {
        ProcessorConfiguration linkerConfig = null;
        ProcessorDef selectedLinkerDef = null;
        Linker selectedLinker = null;
        Hashtable sysLibraries = new Hashtable();
        ObjectFileCollector objCollector = null;
        SystemLibraryCollector sysLibraryCollector = null;
        int i = 0;
        while (i < this._linkers.size()) {
            LinkerDef currentLinkerDef = (LinkerDef)((Object)this._linkers.elementAt(i));
            if (currentLinkerDef.isActive()) {
                selectedLinkerDef = currentLinkerDef;
                selectedLinker = currentLinkerDef.getProcessor().getLinker(this.linkType);
                if (selectedLinker != null) {
                    linkerConfig = currentLinkerDef.createConfiguration(this, this.linkType, this.linkerDef);
                    if (linkerConfig == null) break;
                    objCollector = new ObjectFileCollector(selectedLinker, objectFiles);
                    sysLibraryCollector = new SystemLibraryCollector(selectedLinker, sysLibraries);
                    if (currentLinkerDef.hasFileSets()) {
                        currentLinkerDef.visitFiles(objCollector);
                    }
                    ((LinkerDef)selectedLinkerDef).visitUserLibraries(selectedLinker, objCollector);
                    break;
                }
            }
            ++i;
        }
        if (linkerConfig == null) {
            linkerConfig = this.linkerDef.createConfiguration(this, this.linkType, null);
            selectedLinker = this.linkerDef.getProcessor().getLinker(this.linkType);
            objCollector = new ObjectFileCollector(selectedLinker, objectFiles);
            sysLibraryCollector = new SystemLibraryCollector(selectedLinker, sysLibraries);
        }
        if (selectedLinkerDef == null || selectedLinkerDef.getInherit()) {
            this.linkerDef.visitUserLibraries(selectedLinker, objCollector);
            this.linkerDef.visitSystemLibraries(selectedLinker, sysLibraryCollector);
        }
        if (selectedLinkerDef != null) {
            ((LinkerDef)selectedLinkerDef).visitSystemLibraries(selectedLinker, sysLibraryCollector);
        }
        Enumeration sysLibEnum = sysLibraries.elements();
        while (sysLibEnum.hasMoreElements()) {
            sysObjectFiles.addElement(sysLibEnum.nextElement());
        }
        return (LinkerConfiguration)linkerConfig;
    }

    protected TargetInfo getLinkTarget(LinkerConfiguration linkerConfig, Vector objectFiles, Vector sysObjectFiles, Hashtable compileTargets) {
        Enumeration compileTargetsEnum = compileTargets.elements();
        while (compileTargetsEnum.hasMoreElements()) {
            TargetInfo compileTarget = (TargetInfo)compileTargetsEnum.nextElement();
            int bid = linkerConfig.bid(compileTarget.getOutput().toString());
            if (bid <= 0) continue;
            objectFiles.addElement(compileTarget.getOutput());
        }
        Object[] objectFileArray = new File[objectFiles.size()];
        objectFiles.copyInto(objectFileArray);
        Object[] sysObjectFileArray = new File[sysObjectFiles.size()];
        sysObjectFiles.copyInto(sysObjectFileArray);
        String baseName = CUtil.getBasename(this._outfile);
        String fullName = linkerConfig.getOutputFileName(baseName);
        File outputFile = new File(this._outfile.getParent(), fullName);
        return new TargetInfo(linkerConfig, (File[])objectFileArray, (File[])sysObjectFileArray, outputFile, linkerConfig.getRebuild());
    }

    protected TargetHistoryTable getLinkHistory(TargetHistoryTable objHistory) {
        File outputFileDir = new File(this._outfile.getParent());
        if (this._objDir.equals(outputFileDir)) {
            return objHistory;
        }
        return new TargetHistoryTable(this, outputFileDir);
    }

    protected int checkForChangedIncludeFiles(Hashtable targets) {
        TargetInfo target;
        int potentialTargets = 0;
        int definiteTargets = 0;
        Enumeration targetEnum = targets.elements();
        while (targetEnum.hasMoreElements()) {
            TargetInfo target2 = (TargetInfo)targetEnum.nextElement();
            if (!target2.getRebuild()) {
                ++potentialTargets;
                continue;
            }
            ++definiteTargets;
        }
        if (potentialTargets > 0) {
            this.log("Starting dependency analysis for " + Integer.toString(potentialTargets) + " files.");
            DependencyTable dependencyTable = new DependencyTable(this._objDir);
            try {
                dependencyTable.load();
            }
            catch (Exception ex) {
                this.log("Problem reading dependencies.xml: " + ex.toString());
            }
            targetEnum = targets.elements();
            while (targetEnum.hasMoreElements()) {
                target = (TargetInfo)targetEnum.nextElement();
                if (target.getRebuild() || !dependencyTable.needsRebuild(this, target, this.dependencyDepth)) continue;
                target.mustRebuild();
            }
            dependencyTable.commit(this);
        }
        int currentTargets = 0;
        targetEnum = targets.elements();
        while (targetEnum.hasMoreElements()) {
            target = (TargetInfo)targetEnum.nextElement();
            if (!target.getRebuild()) continue;
            ++currentTargets;
        }
        if (potentialTargets > 0) {
            this.log(Integer.toString(potentialTargets - currentTargets + definiteTargets) + " files are up to date.");
            this.log(Integer.toString(currentTargets - definiteTargets) + " files to be recompiled from dependency analysis.");
        }
        this.log(Integer.toString(currentTargets) + " total files to be compiled.");
        return currentTargets;
    }

    public void setWarnings(CompilerDef.WarningLevel level) {
        this.compilerDef.setWarnings(level);
    }

    public void setRuntime(RuntimeType rtlType) {
        this.linkType.setStaticRuntime(rtlType.getIndex() == 1);
    }

    public void setIncremental(boolean incremental) {
        this.linkerDef.setIncremental(incremental);
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setNewenvironment(boolean newenv) {
        this.compilerDef.setNewenvironment(newenv);
        this.linkerDef.setNewenvironment(newenv);
    }

    public void addEnv(Environment.Variable var) {
        this.compilerDef.addEnv(var);
        this.linkerDef.addEnv(var);
    }

    private class SystemLibraryCollector
    implements FileVisitor {
        private Hashtable libraries;
        private Linker linker;

        public SystemLibraryCollector(Linker linker, Hashtable libraries) {
            this.linker = linker;
            this.libraries = libraries;
        }

        public void visit(File basedir, String filename) {
            if (this.linker.bid(filename) > 0) {
                File libfile = new File(basedir, filename);
                String key = this.linker.getLibraryKey(libfile);
                this.libraries.put(key, libfile);
            }
        }
    }
}

