/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.File;
import java.io.IOException;

public final class SourceHistory {
    private String relativePath;
    private long lastModified;

    public SourceHistory(String relativePath, long lastModified) {
        if (relativePath == null) {
            throw new NullPointerException("relativePath");
        }
        this.relativePath = relativePath;
        this.lastModified = lastModified;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getAbsolutePath(File baseDir) {
        try {
            return new File(baseDir, this.relativePath).getCanonicalPath();
        }
        catch (IOException ex) {
            return this.relativePath;
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

