/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.borland;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.borland.BorlandLinker;
import net.sf.antcontrib.cpptasks.borland.BorlandProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.PrecompilingCommandLineCCompiler;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import org.apache.tools.ant.types.Environment;

public class BorlandCCompiler
extends PrecompilingCommandLineCCompiler {
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++"};
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final BorlandCCompiler instance = new BorlandCCompiler(false, null);

    private BorlandCCompiler(boolean newEnvironment, Environment env) {
        super("bcc32", "-?", sourceExtensions, headerExtensions, ".obj", false, null, newEnvironment, env);
    }

    public static BorlandCCompiler getInstance() {
        return instance;
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    protected File[] getEnvironmentIncludePath() {
        return BorlandProcessor.getEnvironmentPath("bcc32", 'I', new String[]{"..\\include"});
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return BorlandProcessor.getIncludeDirSwitch("-I", includeDir);
    }

    protected void addWarningSwitch(Vector args, int level) {
        BorlandProcessor.addWarningSwitch(args, level);
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        BorlandProcessor.getDefineSwitch(buffer, define, value);
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        BorlandProcessor.getUndefineSwitch(buffer, define);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType) {
        args.addElement("-c");
        args.addElement("-X");
        if (exceptions) {
            args.addElement("-x");
        } else {
            args.addElement("-x-");
        }
        if (multithreaded) {
            args.addElement("-tWM");
        }
        if (debug) {
            args.addElement("-Od");
            args.addElement("-v");
        }
    }

    public Linker getLinker(LinkType type) {
        return BorlandLinker.getInstance().getLinker(type);
    }

    protected CompilerConfiguration createPrecompileGeneratingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude) {
        String[] additionalArgs = new String[]{"-H=" + lastInclude, "-Hc"};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, null, true);
    }

    protected CompilerConfiguration createPrecompileUsingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude, String[] exceptFiles) {
        String[] additionalArgs = new String[]{"-Hu"};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, exceptFiles, false);
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new BorlandCCompiler(newEnvironment, env);
        }
        return this;
    }
}

