/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.LinkerDef;
import net.sf.antcontrib.cpptasks.ProcessorDef;
import net.sf.antcontrib.cpptasks.compiler.AbstractLinker;
import net.sf.antcontrib.cpptasks.compiler.AbstractProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.LinkerConfiguration;
import net.sf.antcontrib.cpptasks.types.CommandLineArgument;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public abstract class CommandLineLinker
extends AbstractLinker {
    private String identifier;
    private String[] librarySets;
    private String outputSuffix;
    private boolean isLibtool;
    private CommandLineLinker libtoolLinker;
    private String command;
    private String identifierArg;
    private boolean newEnvironment = false;
    private Environment env = null;

    public CommandLineLinker(String command, String identifierArg, String[] extensions, String[] ignoredExtensions, String outputSuffix, boolean isLibtool, CommandLineLinker libtoolLinker) {
        super(extensions, ignoredExtensions);
        this.command = command;
        this.identifierArg = identifierArg;
        this.outputSuffix = outputSuffix;
        this.isLibtool = isLibtool;
        this.libtoolLinker = libtoolLinker;
    }

    protected final String getCommand() {
        return this.command;
    }

    protected abstract void addImpliedArgs(boolean var1, LinkType var2, Vector var3);

    protected abstract void addFixed(Boolean var1, Vector var2);

    protected abstract void addMap(boolean var1, Vector var2);

    protected abstract void addIncremental(boolean var1, Vector var2);

    protected abstract void addBase(long var1, Vector var3);

    protected abstract void addStack(int var1, Vector var2);

    protected String[] getOutputFileSwitch(CCTask task, String outputFile) {
        return this.getOutputFileSwitch(outputFile);
    }

    protected abstract String[] getOutputFileSwitch(String var1);

    protected abstract int getMaximumCommandLength();

    protected abstract String getCommandFileSwitch(String var1);

    public final CommandLineLinker getLibtoolLinker() {
        if (this.libtoolLinker != null) {
            return this.libtoolLinker;
        }
        return this;
    }

    protected String getStartupObject(LinkType linkType) {
        return null;
    }

    protected String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        return null;
    }

    public String getOutputFileName(String baseName) {
        return baseName + this.outputSuffix;
    }

    protected LinkerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, LinkerDef specificDef) {
        Vector preargs = new Vector();
        Vector midargs = new Vector();
        Vector endargs = new Vector();
        Vector[] args = new Vector[]{preargs, midargs, endargs};
        LinkerDef[] defaultProviders = new LinkerDef[baseDefs.length + 1];
        defaultProviders[0] = specificDef;
        int i = 0;
        while (i < baseDefs.length) {
            defaultProviders[i + 1] = (LinkerDef)baseDefs[i];
            ++i;
        }
        int i2 = defaultProviders.length - 1;
        while (i2 >= 0) {
            CommandLineArgument[] commandArgs = defaultProviders[i2].getActiveProcessorArgs();
            int j = 0;
            while (j < commandArgs.length) {
                args[commandArgs[j].getLocation()].addElement(commandArgs[j].getValue());
                ++j;
            }
            --i2;
        }
        boolean debug = specificDef.getDebug(baseDefs, 0);
        String startupObject = this.getStartupObject(linkType);
        this.addImpliedArgs(debug, linkType, preargs);
        this.addIncremental(specificDef.getIncremental(defaultProviders, 1), preargs);
        this.addFixed(specificDef.getFixed(defaultProviders, 1), preargs);
        this.addMap(specificDef.getMap(defaultProviders, 1), preargs);
        this.addBase(specificDef.getBase(defaultProviders, 1), preargs);
        this.addStack(specificDef.getStack(defaultProviders, 1), preargs);
        String[] libnames = null;
        LibrarySet[] libsets = specificDef.getActiveLibrarySets(defaultProviders, 1);
        if (libsets.length > 0) {
            libnames = this.addLibrarySets(task, libsets, preargs, midargs, endargs);
        }
        StringBuffer buf = new StringBuffer(this.getIdentifier());
        int i3 = 0;
        while (i3 < 3) {
            Enumeration argenum = args[i3].elements();
            while (argenum.hasMoreElements()) {
                buf.append(' ');
                buf.append(argenum.nextElement().toString());
            }
            ++i3;
        }
        String configId = buf.toString();
        String[][] options = new String[][]{new String[args[0].size() + args[1].size()], new String[args[2].size()]};
        args[0].copyInto(options[0]);
        int offset = args[0].size();
        int i4 = 0;
        while (i4 < args[1].size()) {
            options[0][i4 + offset] = (String)args[1].elementAt(i4);
            ++i4;
        }
        args[2].copyInto(options[1]);
        boolean rebuild = specificDef.getRebuild(baseDefs, 0);
        boolean map = specificDef.getMap(defaultProviders, 1);
        return new CommandLineLinkerConfiguration(this, configId, options, rebuild, map, libnames, startupObject);
    }

    protected String quoteFilename(StringBuffer buf, String filename) {
        if (filename.indexOf(32) >= 0) {
            buf.setLength(0);
            buf.append('\"');
            buf.append(filename);
            buf.append('\"');
            return buf.toString();
        }
        return filename;
    }

    protected String[] prepareArguments(CCTask task, String outputDir, String outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        String[] outputSwitch = this.getOutputFileSwitch(task, outputFile);
        int allArgsCount = preargs.length + 1 + outputSwitch.length + sourceFiles.length + endargs.length;
        if (this.isLibtool) {
            ++allArgsCount;
        }
        String[] allArgs = new String[allArgsCount];
        int index = 0;
        if (this.isLibtool) {
            allArgs[index++] = "libtool";
        }
        allArgs[index++] = this.getCommand();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < preargs.length) {
            allArgs[index++] = this.decorateLinkerOption(buf, preargs[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < outputSwitch.length) {
            allArgs[index++] = outputSwitch[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < sourceFiles.length) {
            allArgs[index++] = this.prepareFilename(buf, outputDir, sourceFiles[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < endargs.length) {
            allArgs[index++] = this.decorateLinkerOption(buf, endargs[i4]);
            ++i4;
        }
        return allArgs;
    }

    protected String prepareFilename(StringBuffer buf, String outputDir, String sourceFile) {
        String relativePath = CUtil.getRelativePath(outputDir, new File(sourceFile));
        return this.quoteFilename(buf, relativePath);
    }

    protected String[] prepareResponseFile(File outputFile, String[] args) throws IOException {
        String baseName = CUtil.getBasename(outputFile);
        File commandFile = new File(outputFile.getParent(), baseName + ".rsp");
        FileWriter writer = new FileWriter(commandFile);
        int execArgCount = 1;
        if (this.isLibtool) {
            ++execArgCount;
        }
        String[] execArgs = new String[execArgCount + 1];
        int i = 0;
        while (i < execArgCount) {
            execArgs[i] = args[i];
            ++i;
        }
        execArgs[execArgCount] = this.getCommandFileSwitch(commandFile.toString());
        int i2 = execArgCount;
        while (i2 < args.length) {
            writer.write(args[i2]);
            writer.write(10);
            ++i2;
        }
        writer.close();
        return execArgs;
    }

    protected String decorateLinkerOption(StringBuffer buf, String arg) {
        return arg;
    }

    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        int retval;
        String parentPath;
        File parentDir = new File(outputFile.getParent());
        try {
            parentPath = parentDir.getCanonicalPath();
        }
        catch (IOException ex) {
            parentPath = parentDir.getAbsolutePath();
        }
        String[] execArgs = this.prepareArguments(task, parentPath, outputFile.getName(), sourceFiles, config);
        int commandLength = 0;
        int i = 0;
        while (i < execArgs.length) {
            commandLength += execArgs[i].length() + 1;
            ++i;
        }
        if (commandLength >= this.getMaximumCommandLength()) {
            try {
                execArgs = this.prepareResponseFile(outputFile, execArgs);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if ((retval = this.runCommand(task, parentDir, execArgs)) != 0) {
            throw new BuildException(this.getCommand() + " failed with return code " + retval, task.getLocation());
        }
    }

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        return CUtil.runCommand(task, workingDir, cmdline, this.newEnvironment, this.env);
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierArg == null ? AbstractProcessor.getIdentifier(new String[]{this.command}, this.command) : AbstractProcessor.getIdentifier(new String[]{this.command, this.identifierArg}, this.command);
        }
        return this.identifier;
    }
}

