/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.devstudio;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkType;

public abstract class DevStudioCompatibleLinker
extends CommandLineLinker {
    public DevStudioCompatibleLinker(String command, String identifierArg, String outputSuffix) {
        super(command, identifierArg, new String[]{".obj", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk", ".dll"}, outputSuffix, false, null);
    }

    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    protected void addFixed(Boolean fixed, Vector args) {
        if (fixed != null) {
            if (fixed.booleanValue()) {
                args.addElement("/FIXED");
            } else {
                args.addElement("/FIXED:NO");
            }
        }
    }

    protected void addIncremental(boolean incremental, Vector args) {
        if (incremental) {
            args.addElement("/INCREMENTAL:YES");
        } else {
            args.addElement("/INCREMENTAL:NO");
        }
    }

    protected void addMap(boolean map, Vector args) {
        if (map) {
            args.addElement("/MAP");
        }
    }

    protected void addBase(long base, Vector args) {
        if (base >= 0L) {
            String baseAddr = Long.toHexString(base);
            args.addElement("/BASE:0x" + baseAddr);
        }
    }

    protected void addStack(int stack, Vector args) {
        if (stack >= 0) {
            String stackStr = Integer.toHexString(stack);
            args.addElement("/STACK:0x" + stackStr);
        }
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        args.addElement("/NOLOGO");
        if (debug) {
            args.addElement("/DEBUG");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/DLL");
        }
    }

    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"/OUT:" + outputFile};
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    public String[] getLibraryPatterns(String[] libnames) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length];
        int i = 0;
        while (i < libnames.length) {
            buf.setLength(0);
            buf.append(libnames[i]);
            buf.append(".lib");
            patterns[i] = buf.toString();
            ++i;
        }
        return patterns;
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

