/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.gcc.GccProcessor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;

public abstract class AbstractLdLinker
extends CommandLineLinker {
    private String outputPrefix;

    protected AbstractLdLinker(String command, String identifierArg, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, AbstractLdLinker libtoolLinker) {
        super(command, identifierArg, extensions, ignoredExtensions, outputSuffix, isLibtool, libtoolLinker);
        this.outputPrefix = outputPrefix;
    }

    public File[] getLibraryPath() {
        return new File[0];
    }

    public String getOutputFileName(String baseName) {
        return this.outputPrefix + super.getOutputFileName(baseName);
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (debug) {
            args.addElement("-g");
        }
        if (this.isDarwin()) {
            if (linkType.isPluginModule()) {
                args.addElement("-bundle");
            } else if (linkType.isSharedLibrary()) {
                args.addElement("-prebind");
                args.addElement("-dynamiclib");
            }
        } else {
            if (linkType.isStaticRuntime()) {
                args.addElement("-static");
            }
            if (linkType.isPluginModule()) {
                args.addElement("-shared");
            } else if (linkType.isSharedLibrary()) {
                args.addElement("-shared");
            }
        }
    }

    public String getCommandFileSwitch(String commandFile) {
        throw new IllegalStateException("ld does not support command files");
    }

    public String[] getOutputFileSwitch(String outputFile) {
        return GccProcessor.getOutputFileSwitch("-o", outputFile);
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    public void addStack(int stack, Vector args) {
    }

    public void addIncremental(boolean incremental, Vector args) {
    }

    public void addBase(long base, Vector args) {
    }

    public void addMap(boolean map, Vector args) {
    }

    public void addFixed(Boolean fixed, Vector args) {
    }

    protected int addLibraryPatterns(String[] libnames, StringBuffer buf, String prefix, String extension, String[] patterns, int offset) {
        int i = 0;
        while (i < libnames.length) {
            buf.setLength(0);
            buf.append(prefix);
            buf.append(libnames[i]);
            buf.append(extension);
            patterns[offset + i] = buf.toString();
            ++i;
        }
        return offset + libnames.length;
    }

    protected boolean isHPUX() {
        String osname = System.getProperty("os.name").toLowerCase();
        return osname.indexOf("hp") >= 0 && osname.indexOf("ux") >= 0;
    }

    public String[] getLibraryPatterns(String[] libnames) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length * 2];
        int offset = this.addLibraryPatterns(libnames, buf, "lib", ".a", patterns, 0);
        offset = this.isHPUX() ? this.addLibraryPatterns(libnames, buf, "lib", ".sl", patterns, offset) : this.addLibraryPatterns(libnames, buf, "lib", ".so", patterns, offset);
        return patterns;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        Vector<String> libnames = new Vector<String>();
        super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        int i = 0;
        while (i < libsets.length) {
            LibrarySet set = libsets[i];
            File libdir = set.getDir(null);
            String[] libs = set.getLibs();
            if (libdir != null) {
                endargs.addElement("-L" + libdir.getAbsolutePath());
            }
            StringBuffer buf = new StringBuffer("-l");
            int j = 0;
            while (j < libs.length) {
                buf.setLength(2);
                buf.append(libs[j]);
                libnames.addElement(libs[j]);
                endargs.addElement(buf.toString());
                ++j;
            }
            ++i;
        }
        String[] rc = new String[libnames.size()];
        int i2 = 0;
        while (i2 < libnames.size()) {
            rc[i2] = (String)libnames.elementAt(i2);
            ++i2;
        }
        return rc;
    }

    public String[] prepareArguments(CCTask task, String outputDir, String outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] libnames = config.getLibraryNames();
        if (libnames == null || libnames.length == 0) {
            return super.prepareArguments(task, outputDir, outputFile, sourceFiles, config);
        }
        String[] localSources = (String[])sourceFiles.clone();
        int extra = 0;
        int i = 0;
        while (i < libnames.length) {
            String libname = libnames[i];
            int j = 0;
            while (j < localSources.length) {
                String extension;
                String filename;
                if (localSources[j] != null && localSources[j].indexOf(libname) > 0 && localSources[j].indexOf("lib") > 0 && (filename = new File(localSources[j]).getName()).startsWith("lib") && filename.substring(3).startsWith(libname) && ((extension = filename.substring(libname.length() + 3)).equals(".a") || extension.equals(".so") || extension.equals(".sl"))) {
                    localSources[j] = null;
                    ++extra;
                }
                ++j;
            }
            ++i;
        }
        if (extra == 0) {
            return super.prepareArguments(task, outputDir, outputFile, sourceFiles, config);
        }
        String[] finalSources = new String[localSources.length - extra];
        int index = 0;
        int i2 = 0;
        while (i2 < localSources.length) {
            if (localSources[i2] != null) {
                finalSources[index++] = localSources[i2];
            }
            ++i2;
        }
        return super.prepareArguments(task, outputDir, outputFile, finalSources, config);
    }

    public String getLibraryKey(File libfile) {
        String libname = libfile.getName();
        int lastDot = libname.lastIndexOf(46);
        if (lastDot >= 0) {
            return libname.substring(0, lastDot);
        }
        return libname;
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("LIB", ":");
    }
}

