/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import org.apache.tools.ant.types.Environment;

public abstract class GccCompatibleCCompiler
extends CommandLineCCompiler {
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".i", ".f", ".for"};
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};

    protected GccCompatibleCCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, boolean libtool, GccCompatibleCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, identifierArg, sourceExtensions, headerExtensions, libtool ? ".fo" : ".o", libtool, libtoolCompiler, newEnvironment, env);
    }

    protected GccCompatibleCCompiler(String command, String identifierArg, boolean libtool, GccCompatibleCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, identifierArg, sourceExtensions, headerExtensions, libtool ? ".fo" : ".o", libtool, libtoolCompiler, newEnvironment, env);
    }

    public String getIncludeDirSwitch(String includeDir) {
        return "-I" + includeDir;
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    public void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 5: {
                args.addElement("-Werror");
            }
            case 4: {
                args.addElement("-W");
            }
            case 3: {
                args.addElement("-Wall");
            }
        }
    }

    public void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
        if (this.getIdentifier().indexOf("mingw") >= 0) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
    }

    public void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    public void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }

    public void addIncludePath(String path, Vector cmd) {
        cmd.addElement("-I" + path);
    }
}

