/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.AbstractLdLinker;
import net.sf.antcontrib.cpptasks.gcc.GccLibrarian;
import net.sf.antcontrib.cpptasks.gcc.GccProcessor;

public class GccLinker
extends AbstractLdLinker {
    private static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] libtoolObjFiles = new String[]{".fo", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] discardFiles = new String[0];
    private static final GccLinker instance = new GccLinker("gcc", objFiles, discardFiles, "", "", false, null);
    private static final GccLinker dllLinker = new GccLinker("gcc", objFiles, discardFiles, "lib", ".so", false, new GccLinker("gcc", objFiles, discardFiles, "lib", ".so", true, null));
    private static final GccLinker machDllLinker = new GccLinker("gcc", objFiles, discardFiles, "lib", ".dylib", false, null);
    private static final GccLinker machBundleLinker = new GccLinker("gcc", objFiles, discardFiles, "lib", ".bundle", false, null);
    private File[] libDirs;
    private static String[] linkerOptions = new String[]{"-bundle", "-dynamiclib", "-nostartfiles", "-nostdlib", "-prebind", "-s", "-static", "-shared", "-symbolic", "-Xlinker"};

    protected GccLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, GccLinker libtoolLinker) {
        super(command, "-dumpversion", extensions, ignoredExtensions, outputPrefix, outputSuffix, isLibtool, libtoolLinker);
    }

    public static GccLinker getInstance() {
        return instance;
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        super.addImpliedArgs(debug, linkType, args);
        if (this.getIdentifier().indexOf("mingw") >= 0) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
    }

    public File[] getLibraryPath() {
        if (this.libDirs == null) {
            int i;
            String[] libpath;
            StringBuffer buf = new StringBuffer("/lib/gcc-lib/");
            buf.append(GccProcessor.getMachine());
            buf.append('/');
            buf.append(GccProcessor.getVersion());
            String[] impliedLibPath = new String[]{buf.toString(), "/lib/w32api", "/lib"};
            String[] specs = GccProcessor.getSpecs();
            String[][] libpaths = GccProcessor.parseSpecs(specs, "*link:", new String[]{"%q"});
            if (libpaths[0].length > 0) {
                libpath = new String[libpaths[0].length + 3];
                i = 0;
                while (i < libpaths[0].length) {
                    libpath[i] = libpaths[0][i];
                    ++i;
                }
                libpath[i++] = buf.toString();
                libpath[i++] = "/lib/w32api";
                libpath[i++] = "/lib";
            } else {
                libpath = new String[]{"/usr/local/lib/mingw", "/usr/local/lib", "/usr/lib/w32api", "/usr/lib/mingw", "/usr/lib", buf.toString(), "/lib/w32api", "/lib"};
            }
            i = 0;
            while (i < libpath.length) {
                if (libpath[i].indexOf("mingw") >= 0) {
                    libpath[i] = null;
                }
                ++i;
            }
            if (GccProcessor.isCygwin()) {
                GccProcessor.convertCygwinFilenames(libpath);
            }
            int count = CUtil.checkDirectoryArray(libpath);
            this.libDirs = new File[count];
            int index = 0;
            int i2 = 0;
            while (i2 < libpath.length) {
                if (libpath[i2] != null) {
                    this.libDirs[index++] = new File(libpath[i2]);
                }
                ++i2;
            }
        }
        return this.libDirs;
    }

    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return GccLibrarian.getInstance();
        }
        if (type.isPluginModule()) {
            if (this.isDarwin()) {
                return machBundleLinker;
            }
            return dllLinker;
        }
        if (type.isSharedLibrary()) {
            if (this.isDarwin()) {
                return machDllLinker;
            }
            return dllLinker;
        }
        return instance;
    }

    public String decorateLinkerOption(StringBuffer buf, String arg) {
        String decoratedArg = arg;
        if (arg.length() > 1 && arg.charAt(0) == '-') {
            switch (arg.charAt(1)) {
                case 'F': 
                case 'L': 
                case 'O': 
                case 'W': 
                case 'f': 
                case 'g': 
                case 'l': 
                case 'm': 
                case 'u': {
                    break;
                }
                default: {
                    boolean known = false;
                    int i = 0;
                    while (i < linkerOptions.length) {
                        if (linkerOptions[i].equals(arg)) {
                            known = true;
                            break;
                        }
                        ++i;
                    }
                    if (known) break;
                    buf.setLength(0);
                    buf.append("-Wl,");
                    buf.append(arg);
                    decoratedArg = buf.toString();
                }
            }
        }
        return decoratedArg;
    }
}

