/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.os400;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.AbstractCompiler;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.os400.IccLinker;
import net.sf.antcontrib.cpptasks.os400.IccProcessor;
import org.apache.tools.ant.types.Environment;

public class IccCompiler
extends CommandLineCCompiler {
    private static final AbstractCompiler instance = new IccCompiler(false, null);

    private IccCompiler(boolean newEnvironment, Environment env) {
        super("icc", null, new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".s"}, new String[]{".h", ".hpp"}, ".o", false, null, newEnvironment, env);
    }

    public static AbstractCompiler getInstance() {
        return instance;
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return IccProcessor.getIncludeDirSwitch(includeDir);
    }

    protected void addWarningSwitch(Vector args, int level) {
        IccProcessor.addWarningSwitch(args, level);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
    }

    public Linker getLinker(LinkType type) {
        return IccLinker.getInstance().getLinker(type);
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-q");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new IccCompiler(newEnvironment, env);
        }
        return this;
    }
}

