/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.pointcut.CallPointcut;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;
import org.codehaus.aspectwerkz.pointcut.GetPointcut;
import org.codehaus.aspectwerkz.pointcut.SetPointcut;
import org.codehaus.aspectwerkz.pointcut.ThrowsPointcut;
import org.codehaus.aspectwerkz.util.SequencedHashMap;

public class AspectMetaData {
    protected final List m_executionPointcuts = new ArrayList();
    protected final List m_callPointcuts = new ArrayList();
    protected final List m_getPointcuts = new ArrayList();
    protected final List m_setPointcuts = new ArrayList();
    protected final List m_throwsPointcuts = new ArrayList();
    private final Map m_methodToCFlowMethodsMap = new SequencedHashMap();
    protected String[] m_introductions = new String[0];
    protected final String m_name;
    protected final int m_deploymentModel;
    protected final String m_uuid;

    public AspectMetaData(String uuid, String name) {
        this(uuid, name, 0);
    }

    public AspectMetaData(String uuid, String name, int deploymentModel) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (deploymentModel < 0) {
            throw new IllegalArgumentException(deploymentModel + " is not a valid deployement model type");
        }
        this.m_uuid = uuid;
        this.m_name = name;
        this.m_deploymentModel = deploymentModel;
    }

    public String getName() {
        return this.m_name;
    }

    public int getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public String getDeploymentModelAsString() {
        return DeploymentModel.getDeploymentModelAsString(this.m_deploymentModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addIntroduction(String introduction) {
        String[] stringArray = this.m_introductions;
        synchronized (this.m_introductions) {
            String[] tmp = new String[this.m_introductions.length + 1];
            System.arraycopy(this.m_introductions, 0, tmp, 0, this.m_introductions.length);
            tmp[this.m_introductions.length] = introduction;
            this.m_introductions = new String[this.m_introductions.length + 1];
            System.arraycopy(tmp, 0, this.m_introductions, 0, tmp.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addIntroductions(String[] introductions) {
        String[] stringArray = this.m_introductions;
        synchronized (this.m_introductions) {
            int i;
            String[] clone = new String[introductions.length];
            System.arraycopy(introductions, 0, clone, 0, introductions.length);
            String[] tmp = new String[this.m_introductions.length + introductions.length];
            for (i = 0; i < this.m_introductions.length; ++i) {
                tmp[i] = this.m_introductions[i];
            }
            for (int j = 0; j < clone.length; ++j) {
                tmp[i] = clone[j];
                ++i;
            }
            this.m_introductions = new String[tmp.length];
            System.arraycopy(tmp, 0, this.m_introductions, 0, tmp.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionPointcut(ExecutionPointcut pointcut) {
        List list = this.m_executionPointcuts;
        synchronized (list) {
            this.m_executionPointcuts.add(pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThrowsPointcut(ThrowsPointcut pointcut) {
        List list = this.m_throwsPointcuts;
        synchronized (list) {
            this.m_throwsPointcuts.add(pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGetPointcut(GetPointcut pointcut) {
        List list = this.m_getPointcuts;
        synchronized (list) {
            this.m_getPointcuts.add(pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetPointcut(SetPointcut pointcut) {
        List list = this.m_setPointcuts;
        synchronized (list) {
            this.m_setPointcuts.add(pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCallPointcut(CallPointcut pointcut) {
        List list = this.m_callPointcuts;
        synchronized (list) {
            this.m_callPointcuts.add(pointcut);
        }
    }

    public void addMethodToCflowExpressionMap(Expression expression, Expression cflowExpression) {
        ArrayList<Expression> cflowPatterns = (ArrayList<Expression>)this.m_methodToCFlowMethodsMap.get(expression);
        if (cflowPatterns != null) {
            cflowPatterns.add(cflowExpression);
        } else {
            cflowPatterns = new ArrayList<Expression>();
            cflowPatterns.add(cflowExpression);
            this.m_methodToCFlowMethodsMap.put(expression, cflowPatterns);
        }
    }

    public String[] getIntroductions() {
        return this.m_introductions;
    }

    public ExecutionPointcut getExecutionPointcut(String expression) {
        Iterator it = this.m_executionPointcuts.iterator();
        while (it.hasNext()) {
            ExecutionPointcut pointcut = (ExecutionPointcut)it.next();
            if (!pointcut.getExpression().getExpression().equals(expression)) continue;
            return pointcut;
        }
        return null;
    }

    public List getExecutionPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        ArrayList<ExecutionPointcut> pointcutList = new ArrayList<ExecutionPointcut>();
        Iterator it = this.m_executionPointcuts.iterator();
        while (it.hasNext()) {
            ExecutionPointcut pointcut = (ExecutionPointcut)it.next();
            if (!pointcut.getExpression().match(classMetaData, methodMetaData)) continue;
            pointcutList.add(pointcut);
        }
        return pointcutList;
    }

    public GetPointcut getGetPointcut(String expression) {
        Iterator it = this.m_getPointcuts.iterator();
        while (it.hasNext()) {
            GetPointcut pointcut = (GetPointcut)it.next();
            if (!pointcut.getExpression().getExpression().equals(expression)) continue;
            return pointcut;
        }
        return null;
    }

    public List getGetPointcuts(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        ArrayList<GetPointcut> pointcutList = new ArrayList<GetPointcut>();
        Iterator it = this.m_getPointcuts.iterator();
        while (it.hasNext()) {
            GetPointcut pointcut = (GetPointcut)it.next();
            if (!pointcut.getExpression().match(classMetaData, fieldMetaData)) continue;
            pointcutList.add(pointcut);
        }
        return pointcutList;
    }

    public SetPointcut getSetPointcut(String expression) {
        Iterator it = this.m_setPointcuts.iterator();
        while (it.hasNext()) {
            SetPointcut pointcut = (SetPointcut)it.next();
            if (!pointcut.getExpression().getExpression().equals(expression)) continue;
            return pointcut;
        }
        return null;
    }

    public List getSetPointcuts(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        ArrayList<SetPointcut> pointcutList = new ArrayList<SetPointcut>();
        Iterator it = this.m_setPointcuts.iterator();
        while (it.hasNext()) {
            SetPointcut pointcut = (SetPointcut)it.next();
            if (!pointcut.getExpression().match(classMetaData, fieldMetaData)) continue;
            pointcutList.add(pointcut);
        }
        return pointcutList;
    }

    public ThrowsPointcut getThrowsPointcut(String expression) {
        Iterator it = this.m_throwsPointcuts.iterator();
        while (it.hasNext()) {
            ThrowsPointcut pointcut = (ThrowsPointcut)it.next();
            if (!pointcut.getExpression().getExpression().equals(expression)) continue;
            return pointcut;
        }
        return null;
    }

    public List getThrowsPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        ArrayList<ThrowsPointcut> pointcutList = new ArrayList<ThrowsPointcut>();
        Iterator it = this.m_throwsPointcuts.iterator();
        while (it.hasNext()) {
            ThrowsPointcut pointcut = (ThrowsPointcut)it.next();
            if (!pointcut.getExpression().match(classMetaData, methodMetaData)) continue;
            pointcutList.add(pointcut);
        }
        return pointcutList;
    }

    public CallPointcut getCallPointcut(String expression) {
        Iterator it = this.m_callPointcuts.iterator();
        while (it.hasNext()) {
            CallPointcut pointcut = (CallPointcut)it.next();
            if (!pointcut.getExpression().getExpression().equals(expression)) continue;
            return pointcut;
        }
        return null;
    }

    public List getCallPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        ArrayList<CallPointcut> pointcutList = new ArrayList<CallPointcut>();
        Iterator it = this.m_callPointcuts.iterator();
        while (it.hasNext()) {
            CallPointcut pointcut = (CallPointcut)it.next();
            if (!pointcut.getExpression().match(classMetaData, methodMetaData)) continue;
            pointcutList.add(pointcut);
        }
        return pointcutList;
    }

    public List getCFlowExpressions(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        ArrayList pointcutList = new ArrayList();
        Iterator it = this.m_methodToCFlowMethodsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Expression expression = (Expression)entry.getKey();
            if (!expression.match(classMetaData, methodMetaData)) continue;
            pointcutList.addAll((List)entry.getValue());
        }
        return pointcutList;
    }

    public boolean hasThrowsPointcut(ClassMetaData classMetaData, MethodMetaData methodMetaData, String exception) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("exception class name can not be null");
        }
        Iterator it = this.m_throwsPointcuts.iterator();
        while (it.hasNext()) {
            ThrowsPointcut pointcut = (ThrowsPointcut)it.next();
            if (!pointcut.getExpression().match(classMetaData, methodMetaData, exception)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + super.toString() + ": " + "," + this.m_name + "," + this.m_introductions + "," + this.m_executionPointcuts + "," + this.m_getPointcuts + "," + this.m_setPointcuts + "," + this.m_callPointcuts + "]";
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + AspectMetaData.hashCodeOrZeroIfNull(this.m_name);
        result = 37 * result + AspectMetaData.hashCodeOrZeroIfNull(this.m_introductions);
        result = 37 * result + AspectMetaData.hashCodeOrZeroIfNull(this.m_executionPointcuts);
        result = 37 * result + AspectMetaData.hashCodeOrZeroIfNull(this.m_getPointcuts);
        result = 37 * result + AspectMetaData.hashCodeOrZeroIfNull(this.m_setPointcuts);
        result = 37 * result + AspectMetaData.hashCodeOrZeroIfNull(this.m_callPointcuts);
        return result;
    }

    protected static int hashCodeOrZeroIfNull(Object o) {
        if (null == o) {
            return 19;
        }
        return o.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AspectMetaData)) {
            return false;
        }
        AspectMetaData obj = (AspectMetaData)o;
        return AspectMetaData.areEqualsOrBothNull(obj.m_name, this.m_name) && AspectMetaData.areEqualsOrBothNull(obj.m_introductions, this.m_introductions) && AspectMetaData.areEqualsOrBothNull(obj.m_executionPointcuts, this.m_executionPointcuts) && AspectMetaData.areEqualsOrBothNull(obj.m_getPointcuts, this.m_getPointcuts) && AspectMetaData.areEqualsOrBothNull(obj.m_setPointcuts, this.m_setPointcuts) && AspectMetaData.areEqualsOrBothNull(obj.m_callPointcuts, this.m_callPointcuts);
    }

    protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }
}

