/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz;

public final class DeploymentModel {
    public static final int PER_JVM = 0;
    public static final int PER_CLASS = 1;
    public static final int PER_INSTANCE = 2;
    public static final int PER_THREAD = 3;

    public static int getDeploymentModelAsInt(String type) {
        if (type == null || type.equals("perJVM")) {
            return 0;
        }
        if (type.equals("perClass")) {
            return 1;
        }
        if (type.equals("perInstance")) {
            return 2;
        }
        if (type.equals("perThread")) {
            return 3;
        }
        throw new RuntimeException("invalid deployment model: " + type);
    }

    /*
     * WARNING - void declaration
     */
    public static String getDeploymentModelAsString(int type) {
        void var1_1;
        switch (type) {
            case 0: {
                String deploymentModel = "perJVM";
                break;
            }
            case 1: {
                String deploymentModel = "perClass";
                break;
            }
            case 2: {
                String deploymentModel = "perInstance";
                break;
            }
            case 3: {
                String deploymentModel = "perThread";
                break;
            }
            default: {
                throw new IllegalArgumentException("no such deployment model type");
            }
        }
        return var1_1;
    }

    public static boolean isMixinDeploymentModelCompatible(int mixinModel, int aspectModel) {
        if (mixinModel == 3) {
            return aspectModel == 3;
        }
        return mixinModel >= aspectModel;
    }
}

