/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef;

import gnu.trove.TObjectIntHashMap;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.AspectMetaData;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.MethodComparator;
import org.codehaus.aspectwerkz.Mixin;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.attribdef.aspect.Aspect;
import org.codehaus.aspectwerkz.attribdef.aspect.DefaultIntroductionContainerStrategy;
import org.codehaus.aspectwerkz.attribdef.aspect.Introduction;
import org.codehaus.aspectwerkz.attribdef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.attribdef.definition.IntroductionDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.StartupManager;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AspectAttributeParser;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.DefaultAspectAttributeParser;
import org.codehaus.aspectwerkz.connectivity.Invoker;
import org.codehaus.aspectwerkz.connectivity.RemoteProxy;
import org.codehaus.aspectwerkz.connectivity.RemoteProxyServer;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.ClassNameMethodMetaDataTuple;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.regexp.CallerSidePattern;
import org.codehaus.aspectwerkz.regexp.CompiledPatternTuple;
import org.codehaus.aspectwerkz.util.SequencedHashMap;
import org.codehaus.aspectwerkz.util.Util;

public final class AttribDefSystem
implements System {
    private final Map m_aspectMetaDataMap = new SequencedHashMap();
    private final Map m_executionPointcutCache = new WeakHashMap();
    private final Map m_getPointcutCache = new WeakHashMap();
    private final Map m_setPointcutCache = new WeakHashMap();
    private final Map m_throwsPointcutCache = new WeakHashMap();
    private final Map m_callPointcutCache = new WeakHashMap();
    private final Map m_cflowPointcutCache = new WeakHashMap();
    private final Map m_methods = new HashMap();
    private Aspect[] m_aspects = new Aspect[0];
    private final TObjectIntHashMap m_aspectIndexes = new TObjectIntHashMap();
    private final Map m_adviceIndexes = new HashMap();
    private Mixin[] m_mixins = new Mixin[0];
    private boolean m_initialized = false;
    private final String m_uuid;
    private AspectWerkzDefinitionImpl m_definition;
    private final ThreadLocal m_controlFlowLog = new ThreadLocal();
    private RemoteProxyServer m_remoteProxyServer = null;
    private AspectAttributeParser m_attributeParser;

    public AttribDefSystem(String uuid, AspectWerkzDefinition definition) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("definition can not be null");
        }
        this.m_uuid = uuid;
        this.m_definition = (AspectWerkzDefinitionImpl)definition;
        this.m_attributeParser = new DefaultAspectAttributeParser();
        if (System.START_REMOTE_PROXY_SERVER) {
            this.startRemoteProxyServer();
        }
    }

    public synchronized void initialize() {
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        StartupManager.initializeSystem(this.m_uuid, this.m_definition);
    }

    public boolean isAttribDef() {
        return true;
    }

    public boolean isXmlDef() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Aspect aspect, AspectMetaData aspectMetaData) {
        if (aspect == null) {
            throw new IllegalArgumentException("aspect can not be null");
        }
        if (aspectMetaData == null) {
            throw new IllegalArgumentException("aspect meta-data can not be null");
        }
        Aspect[] aspectArray = this.m_aspects;
        synchronized (this.m_aspects) {
            TObjectIntHashMap tObjectIntHashMap = this.m_aspectIndexes;
            synchronized (tObjectIntHashMap) {
                Map map = this.m_adviceIndexes;
                synchronized (map) {
                    Mixin[] mixinArray = this.m_mixins;
                    synchronized (this.m_mixins) {
                        Map map2 = this.m_aspectMetaDataMap;
                        synchronized (map2) {
                            try {
                                this.m_aspectMetaDataMap.put(aspect.___AW_getName(), aspectMetaData);
                                int indexAspect = this.m_aspects.length + 1;
                                this.m_aspectIndexes.put((Object)aspect.___AW_getName(), indexAspect);
                                Aspect[] tmpAspects = new Aspect[this.m_aspects.length + 1];
                                java.lang.System.arraycopy(this.m_aspects, 0, tmpAspects, 0, this.m_aspects.length);
                                tmpAspects[this.m_aspects.length] = aspect;
                                this.m_aspects = new Aspect[this.m_aspects.length + 1];
                                java.lang.System.arraycopy(tmpAspects, 0, this.m_aspects, 0, tmpAspects.length);
                                List advices = aspect.___AW_getAspectDef().getAllAdvices();
                                Iterator it = advices.iterator();
                                while (it.hasNext()) {
                                    AdviceDefinition adviceDef = (AdviceDefinition)it.next();
                                    this.m_adviceIndexes.put(adviceDef.getName(), new IndexTuple(indexAspect, adviceDef.getMethodIndex()));
                                }
                                List introductions = aspect.___AW_getAspectDef().getIntroductions();
                                Iterator it2 = introductions.iterator();
                                while (it2.hasNext()) {
                                    IntroductionDefinition introDef = (IntroductionDefinition)it2.next();
                                    Class<?> defaultImplClass = aspect.getClass().getClassLoader().loadClass(introDef.getName());
                                    Introduction mixin = new Introduction(introDef.getName(), defaultImplClass, aspect, introDef);
                                    DefaultIntroductionContainerStrategy introContainer = new DefaultIntroductionContainerStrategy(mixin, aspect.___AW_getContainer());
                                    mixin.setContainer(introContainer);
                                    Mixin[] tmpMixins = new Mixin[this.m_mixins.length + 1];
                                    java.lang.System.arraycopy(this.m_mixins, 0, tmpMixins, 0, this.m_mixins.length);
                                    tmpMixins[this.m_mixins.length] = mixin;
                                    this.m_mixins = new Mixin[this.m_mixins.length + 1];
                                    java.lang.System.arraycopy(tmpMixins, 0, this.m_mixins, 0, tmpMixins.length);
                                }
                            }
                            catch (Exception e) {
                                throw new DefinitionException("could not register aspect [" + aspect.___AW_getName() + "] due to: " + e.toString());
                            }
                        }
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                    }
                }
                {
                }
            }
            {
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public void createAspect(String name, String className, int deploymentModel, ClassLoader loader) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (deploymentModel < 0 || deploymentModel > 3) {
            throw new IllegalArgumentException(deploymentModel + " is not a valid deployment model type");
        }
        Aspect prototype = null;
        Class<?> aspectClass = null;
        try {
            aspectClass = loader == null ? ContextClassLoader.loadClass(className) : loader.loadClass(className);
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer();
            msg.append("could not load aspect class [");
            msg.append(className);
            msg.append("] with name ");
            msg.append(name);
            msg.append(": ");
            msg.append(e.toString());
            throw new RuntimeException(msg.toString());
        }
        try {
            prototype = (Aspect)aspectClass.newInstance();
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer();
            msg.append("could not create a new instance of aspect [");
            msg.append(className);
            msg.append("], does the class inherit the [org.codehaus.aspectwerkz.attribdef.aspect.Aspect] class?: ");
            msg.append(e.toString());
            throw new RuntimeException(msg.toString());
        }
        AspectDefinition aspectDef = this.m_attributeParser.parse(aspectClass);
        this.m_definition.addAspect(aspectDef);
        prototype.___AW_setDeploymentModel(deploymentModel);
        prototype.___AW_setName(name);
        prototype.___AW_setAspectClass(prototype.getClass());
        prototype.___AW_setContainer(StartupManager.createAspectContainer(prototype));
        prototype.___AW_setAspectDef(aspectDef);
        this.register(prototype, new AspectMetaData(this.m_uuid, name, deploymentModel));
    }

    public void enteringControlFlow(ClassNameMethodMetaDataTuple metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("classname:methodMetaData tuple can not be null");
        }
        HashSet<ClassNameMethodMetaDataTuple> cflowSet = (HashSet<ClassNameMethodMetaDataTuple>)this.m_controlFlowLog.get();
        if (cflowSet == null) {
            cflowSet = new HashSet<ClassNameMethodMetaDataTuple>();
        }
        cflowSet.add(metaData);
        this.m_controlFlowLog.set(cflowSet);
    }

    public void exitingControlFlow(ClassNameMethodMetaDataTuple metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("classname:methodMetaData tuple can not be null");
        }
        Set cflowSet = (Set)this.m_controlFlowLog.get();
        if (cflowSet == null) {
            return;
        }
        cflowSet.remove(metaData);
        this.m_controlFlowLog.set(cflowSet);
    }

    public boolean isInControlFlowOf(Expression cflowExpression) {
        if (cflowExpression == null) {
            throw new IllegalArgumentException("cflowExpression can not be null");
        }
        Set cflowSet = (Set)this.m_controlFlowLog.get();
        if (cflowSet == null || cflowSet.isEmpty()) {
            return false;
        }
        Iterator it = cflowSet.iterator();
        while (it.hasNext()) {
            ClassNameMethodMetaDataTuple tuple = (ClassNameMethodMetaDataTuple)it.next();
            if (!cflowExpression.match(tuple.getClassMetaData(), tuple.getMethodMetaData())) continue;
            return true;
        }
        return false;
    }

    public boolean isInControlFlowOf(CompiledPatternTuple patternTuple) {
        if (patternTuple == null) {
            throw new IllegalArgumentException("class:method pattern tuple can not be null");
        }
        Set cflowSet = (Set)this.m_controlFlowLog.get();
        if (cflowSet == null || cflowSet.isEmpty()) {
            return false;
        }
        Iterator it = cflowSet.iterator();
        while (it.hasNext()) {
            ClassNameMethodMetaDataTuple tuple = (ClassNameMethodMetaDataTuple)it.next();
            CallerSidePattern callerSidePattern = (CallerSidePattern)patternTuple.getPattern();
            if (!callerSidePattern.matches(tuple.getClassName(), tuple.getMethodMetaData())) continue;
            return true;
        }
        return false;
    }

    public Aspect getAspect(int index) {
        Aspect aspect;
        try {
            aspect = this.m_aspects[index - 1];
        }
        catch (Throwable e) {
            this.initialize();
            try {
                aspect = this.m_aspects[index - 1];
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                throw new DefinitionException("no aspect with index " + index);
            }
        }
        return aspect;
    }

    public Aspect getAspect(String name) {
        Aspect aspect;
        try {
            aspect = this.m_aspects[this.m_aspectIndexes.get((Object)name) - 1];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                aspect = this.m_aspects[this.m_aspectIndexes.get((Object)name) - 1];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DefinitionException("aspect [" + name + "] is not properly defined");
            }
        }
        return aspect;
    }

    public Mixin getMixin(int index) {
        Mixin mixin;
        try {
            mixin = this.m_mixins[index - 1];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                mixin = this.m_mixins[index - 1];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DefinitionException("no mixin with index " + index);
            }
        }
        return mixin;
    }

    public Mixin getMixin(String name) {
        Mixin introduction;
        if (name == null) {
            throw new IllegalArgumentException("introduction name can not be null");
        }
        try {
            introduction = this.m_mixins[this.m_definition.getMixinIndexByName(name) - 1];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                introduction = this.m_mixins[this.m_definition.getMixinIndexByName(name) - 1];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new DefinitionException("no introduction with name " + name);
            }
        }
        return introduction;
    }

    public int getAspectIndexFor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        int index = this.m_aspectIndexes.get((Object)name);
        if (index == 0) {
            throw new DefinitionException("aspect " + name + " is not properly defined");
        }
        return index;
    }

    public IndexTuple getAdviceIndexFor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("advice name can not be null");
        }
        IndexTuple index = (IndexTuple)this.m_adviceIndexes.get(name);
        if (index == null) {
            throw new DefinitionException("advice " + name + " is not properly defined");
        }
        return index;
    }

    public AspectMetaData getAspectMetaData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (this.m_aspectMetaDataMap.containsKey(name)) {
            return (AspectMetaData)this.m_aspectMetaDataMap.get(name);
        }
        this.initialize();
        if (this.m_aspectMetaDataMap.containsKey(name)) {
            return (AspectMetaData)this.m_aspectMetaDataMap.get(name);
        }
        throw new DefinitionException("aspect " + name + " is not properly defined");
    }

    public Collection getAspectsMetaData() {
        this.initialize();
        return this.m_aspectMetaDataMap.values();
    }

    public Aspect[] getAspects() {
        this.initialize();
        return this.m_aspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getExecutionPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_executionPointcutCache.containsKey(hashKey)) {
            return (List)this.m_executionPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspectMetaDataMap.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            List methodPointcuts = aspect.getExecutionPointcuts(classMetaData, methodMetaData);
            pointcuts.addAll(methodPointcuts);
        }
        Map map = this.m_executionPointcutCache;
        synchronized (map) {
            this.m_executionPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGetPointcuts(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), fieldMetaData);
        if (this.m_getPointcutCache.containsKey(hashKey)) {
            return (List)this.m_getPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspectMetaDataMap.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getGetPointcuts(classMetaData, fieldMetaData));
        }
        Map map = this.m_getPointcutCache;
        synchronized (map) {
            this.m_getPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSetPointcuts(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), fieldMetaData);
        if (this.m_setPointcutCache.containsKey(hashKey)) {
            return (List)this.m_setPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspectMetaDataMap.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getSetPointcuts(classMetaData, fieldMetaData));
        }
        Map map = this.m_setPointcutCache;
        synchronized (map) {
            this.m_setPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getThrowsPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_throwsPointcutCache.containsKey(hashKey)) {
            return (List)this.m_throwsPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspectMetaDataMap.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getThrowsPointcuts(classMetaData, methodMetaData));
        }
        Map map = this.m_throwsPointcutCache;
        synchronized (map) {
            this.m_throwsPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCallPointcuts(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_callPointcutCache.containsKey(hashKey)) {
            return (List)this.m_callPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspectMetaDataMap.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getCallPointcuts(classMetaData, methodMetaData));
        }
        Map map = this.m_callPointcutCache;
        synchronized (map) {
            this.m_callPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCFlowExpressions(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        Integer hashKey = Util.calculateHash(classMetaData.getName(), methodMetaData);
        if (this.m_cflowPointcutCache.containsKey(hashKey)) {
            return (List)this.m_cflowPointcutCache.get(hashKey);
        }
        ArrayList pointcuts = new ArrayList();
        Iterator it = this.m_aspectMetaDataMap.values().iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            pointcuts.addAll(aspect.getCFlowExpressions(classMetaData, methodMetaData));
        }
        Map map = this.m_cflowPointcutCache;
        synchronized (map) {
            this.m_cflowPointcutCache.put(hashKey, pointcuts);
        }
        return pointcuts;
    }

    public List getCFlowPointcuts(String className, MethodMetaData methodMetaData) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        this.initialize();
        return null;
    }

    public boolean hasAspect(String name) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        this.initialize();
        return this.m_aspectMetaDataMap.containsKey(name);
    }

    public Method getMethod(Class klass, int index) {
        Method method;
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("method index can not be less than 0");
        }
        try {
            if (!this.m_methods.containsKey(klass)) {
                this.createMethodRepository(klass);
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        try {
            method = ((Method[])this.m_methods.get(klass))[index];
        }
        catch (Throwable e1) {
            this.initialize();
            try {
                method = ((Method[])this.m_methods.get(klass))[index];
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMethodRepository(Class klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        ArrayList methods = new ArrayList();
        this.collectMethods(klass, methods);
        Collections.sort(methods, MethodComparator.getInstance(1));
        Method[] sortedMethods = new Method[methods.size()];
        for (int i = 0; i < sortedMethods.length; ++i) {
            sortedMethods[i] = (Method)methods.get(i);
        }
        Map map = this.m_methods;
        synchronized (map) {
            this.m_methods.put(klass, sortedMethods);
        }
    }

    protected void collectMethods(Class klass, List methods) {
        Method[] declaredMethods = klass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            if (!declaredMethods[i].getName().startsWith("___AW_original_method$_AW_$")) continue;
            methods.add(declaredMethods[i]);
        }
    }

    private void startRemoteProxyServer() {
        Invoker invoker = this.getInvoker();
        this.m_remoteProxyServer = new RemoteProxyServer(ContextClassLoader.getLoader(), invoker);
        this.m_remoteProxyServer.start();
    }

    private Invoker getInvoker() {
        Invoker invoker = null;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(java.lang.System.getProperty("aspectwerkz.resource.bundle")));
            String className = properties.getProperty("remote.server.invoker.classname");
            invoker = (Invoker)ContextClassLoader.getLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            invoker = this.getDefaultInvoker();
        }
        return invoker;
    }

    private Invoker getDefaultInvoker() {
        return new Invoker(){

            public Object invoke(String handle, String methodName, Class[] paramTypes, Object[] args, Object context) {
                Object result = null;
                try {
                    Object instance = RemoteProxy.getWrappedInstance(handle);
                    Method method = instance.getClass().getMethod(methodName, paramTypes);
                    result = method.invoke(instance, args);
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
                return result;
            }
        };
    }
}

