/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.aspect;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.ContainerType;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.attribdef.aspect.AspectContainer;
import org.codehaus.aspectwerkz.attribdef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.StartupManager;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;

public abstract class Aspect
implements Serializable {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected String m_name;
    protected Class m_aspectClass;
    protected int m_deploymentModel;
    protected transient AspectContainer m_container;
    protected ContainerType m_containerType;
    protected Map m_parameters = new HashMap();
    private String m_uuid;
    private System m_system;
    private AspectDefinition m_aspectDef;
    private Object m_targetInstance = null;
    private Object m_targetClass = null;

    public static Aspect newInstance(Aspect prototype) {
        try {
            Aspect clone = (Aspect)prototype.m_aspectClass.newInstance();
            clone.m_uuid = prototype.m_uuid;
            clone.m_name = prototype.m_name;
            clone.m_aspectClass = prototype.m_aspectClass;
            clone.m_container = prototype.m_container;
            clone.m_deploymentModel = prototype.m_deploymentModel;
            clone.m_parameters = prototype.m_parameters;
            return clone;
        }
        catch (Exception e) {
            throw new RuntimeException("could not clone aspect [" + prototype.___AW_getName() + "]");
        }
    }

    public System ___AW_getSystem() {
        if (this.m_system == null) {
            this.m_system = SystemLoader.getSystem(this.m_uuid);
            this.m_system.initialize();
        }
        return this.m_system;
    }

    public Object ___AW_invokeAdvice(int methodIndex, JoinPoint joinPoint) {
        try {
            Object result = null;
            switch (this.m_deploymentModel) {
                case 0: {
                    result = this.___AW_invokeAdvicePerJvm(methodIndex, joinPoint);
                    break;
                }
                case 1: {
                    result = this.___AW_invokeAdvicePerClass(methodIndex, joinPoint);
                    break;
                }
                case 2: {
                    result = this.___AW_invokeAdvicePerInstance(methodIndex, joinPoint);
                    break;
                }
                case 3: {
                    result = this.___AW_invokeAdvicePerThread(methodIndex, joinPoint);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid deployment model: " + this.m_deploymentModel);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private Object ___AW_invokeAdvicePerJvm(int methodIndex, JoinPoint joinPoint) {
        return this.m_container.invokeAdvicePerJvm(methodIndex, joinPoint);
    }

    private Object ___AW_invokeAdvicePerClass(int methodIndex, JoinPoint joinPoint) {
        return this.m_container.invokeAdvicePerClass(methodIndex, joinPoint);
    }

    private Object ___AW_invokeAdvicePerInstance(int methodIndex, JoinPoint joinPoint) {
        return this.m_container.invokeAdvicePerInstance(methodIndex, joinPoint);
    }

    private Object ___AW_invokeAdvicePerThread(int methodIndex, JoinPoint joinPoint) {
        return this.m_container.invokeAdvicePerThread(methodIndex, joinPoint);
    }

    public void ___AW_setName(String name) {
        this.m_name = name;
    }

    public String ___AW_getName() {
        return this.m_name;
    }

    public void ___AW_setDeploymentModel(int deploymentModel) {
        this.m_deploymentModel = deploymentModel;
    }

    public int ___AW_getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public Class ___AW_getAspectClass() {
        return this.m_aspectClass;
    }

    public void ___AW_setAspectClass(Class aspectClass) {
        this.m_aspectClass = aspectClass;
    }

    public void ___AW_setContainer(AspectContainer container) {
        this.m_container = container;
    }

    public AspectContainer ___AW_getContainer() {
        return this.m_container;
    }

    public ContainerType ___AW_getContainerType() {
        return this.m_container.getContainerType();
    }

    public AspectDefinition ___AW_getAspectDef() {
        return this.m_aspectDef;
    }

    public void ___AW_setAspectDef(AspectDefinition aspectDef) {
        this.m_aspectDef = aspectDef;
    }

    public Object ___AW_getTargetInstance() {
        return this.m_targetInstance;
    }

    public void ___AW_setTargetInstance(Object targetInstance) {
        this.m_targetInstance = targetInstance;
        this.m_targetClass = targetInstance.getClass();
    }

    public Object ___AW_getTargetClass() {
        return this.m_targetClass;
    }

    public void ___AW_setTargetClass(Object targetClass) {
        this.m_targetClass = targetClass;
    }

    public void ___AW_setParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public String ___AW_getParameter(String name) {
        if (!this.m_parameters.containsKey(name)) {
            throw new DefinitionException("parameter to advice not specified: " + name);
        }
        return (String)this.m_parameters.get(name);
    }

    public Object ___AW_getMixinTargetInstance(String mixinName, Object mixinImpl) {
        return this.m_container.getIntroductionContainer(mixinName).getTargetInstance(mixinImpl);
    }

    public Class ___AW_getMixinTargetClass(String mixinName, Object mixinImpl) {
        return this.m_container.getIntroductionContainer(mixinName).getTargetClass(mixinImpl);
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_name = (String)fields.get("m_name", null);
        this.m_aspectClass = (Class)fields.get("m_aspectClass", null);
        this.m_targetInstance = fields.get("m_targetInstance", null);
        this.m_targetClass = fields.get("m_targetClass", null);
        this.m_containerType = (ContainerType)fields.get("m_containerType", ContainerType.TRANSIENT);
        this.m_deploymentModel = fields.get("m_deploymentModel", 0);
        this.m_aspectDef = (AspectDefinition)fields.get("m_aspectDef", null);
        this.m_parameters = (Map)fields.get("m_parameters", null);
        this.m_container = StartupManager.createAspectContainer(this);
        this.m_system = SystemLoader.getSystem(this.m_uuid);
        this.m_system.initialize();
    }
}

