/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.aspect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.ContainerType;
import org.codehaus.aspectwerkz.attribdef.aspect.Aspect;
import org.codehaus.aspectwerkz.attribdef.aspect.AspectContainer;
import org.codehaus.aspectwerkz.attribdef.aspect.IntroductionContainer;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class DefaultAspectContainerStrategy
implements AspectContainer {
    private Map m_introductionContainers = new HashMap();
    protected Object m_perJvm;
    protected Map m_perClass = new HashMap();
    protected Map m_perInstance = new WeakHashMap();
    protected Map m_perThread = new WeakHashMap();
    protected Aspect m_prototype;
    protected Method[] m_methodRepository = new Method[0];

    public DefaultAspectContainerStrategy(Aspect prototype) {
        if (prototype == null) {
            throw new IllegalArgumentException("aspect prototype can not be null");
        }
        this.m_prototype = prototype;
        this.createMethodRepository();
    }

    public Object invokeAdvicePerJvm(int methodIndex, JoinPoint joinPoint) {
        Object result = null;
        try {
            if (this.m_perJvm == null) {
                this.m_perJvm = Aspect.newInstance(this.m_prototype);
            }
            Method method = this.m_methodRepository[methodIndex];
            result = method.invoke(this.m_perJvm, joinPoint);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeAdvicePerClass(int methodIndex, JoinPoint joinPoint) {
        Class targetClass = joinPoint.getTargetClass();
        Object result = null;
        try {
            if (!this.m_perClass.containsKey(targetClass)) {
                Map map = this.m_perClass;
                synchronized (map) {
                    Aspect aspect = Aspect.newInstance(this.m_prototype);
                    aspect.___AW_setTargetClass(targetClass);
                    this.m_perClass.put(targetClass, aspect);
                }
            }
            result = this.m_methodRepository[methodIndex].invoke(this.m_perClass.get(targetClass), joinPoint);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeAdvicePerInstance(int methodIndex, JoinPoint joinPoint) {
        Object result = null;
        Object targetInstance = joinPoint.getTargetInstance();
        if (targetInstance == null) {
            return this.invokeAdvicePerClass(methodIndex, joinPoint);
        }
        try {
            if (!this.m_perInstance.containsKey(targetInstance)) {
                Map map = this.m_perInstance;
                synchronized (map) {
                    Aspect aspect = Aspect.newInstance(this.m_prototype);
                    aspect.___AW_setTargetInstance(targetInstance);
                    this.m_perInstance.put(targetInstance, aspect);
                }
            }
            result = this.m_methodRepository[methodIndex].invoke(this.m_perInstance.get(targetInstance), joinPoint);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeAdvicePerThread(int methodIndex, JoinPoint joinPoint) {
        Object result;
        try {
            Thread currentThread = Thread.currentThread();
            if (!this.m_perThread.containsKey(currentThread)) {
                Map map = this.m_perThread;
                synchronized (map) {
                    this.m_perThread.put(currentThread, Aspect.newInstance(this.m_prototype));
                }
            }
            Method method = this.m_methodRepository[methodIndex];
            result = method.invoke(this.m_perThread.get(currentThread), joinPoint);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    public ContainerType getContainerType() {
        return ContainerType.TRANSIENT;
    }

    public Method getMethod(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("method index can not be less than 0");
        }
        return this.m_methodRepository[index];
    }

    public Aspect getPerJvmAspect() {
        if (this.m_perJvm == null) {
            try {
                this.m_perJvm = Aspect.newInstance(this.m_prototype);
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return (Aspect)this.m_perJvm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aspect getPerClassAspect(Class callingClass) {
        if (!this.m_perClass.containsKey(callingClass)) {
            Map map = this.m_perClass;
            synchronized (map) {
                try {
                    Aspect aspect = Aspect.newInstance(this.m_prototype);
                    aspect.___AW_setTargetClass(callingClass);
                    this.m_perClass.put(callingClass, aspect);
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return (Aspect)this.m_perClass.get(callingClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aspect getPerInstanceAspect(Object callingInstance) {
        if (callingInstance == null) {
            return this.getPerClassAspect(callingInstance.getClass());
        }
        if (!this.m_perInstance.containsKey(callingInstance)) {
            Map map = this.m_perInstance;
            synchronized (map) {
                try {
                    Aspect aspect = Aspect.newInstance(this.m_prototype);
                    aspect.___AW_setTargetInstance(callingInstance);
                    this.m_perInstance.put(callingInstance, aspect);
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return (Aspect)this.m_perInstance.get(callingInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aspect getPerThreadAspect() {
        Thread currentThread = Thread.currentThread();
        if (!this.m_perThread.containsKey(currentThread)) {
            Map map = this.m_perThread;
            synchronized (map) {
                try {
                    this.m_perThread.put(currentThread, Aspect.newInstance(this.m_prototype));
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return (Aspect)this.m_perThread.get(currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMethodRepository() {
        Method[] methodArray = this.m_methodRepository;
        synchronized (this.m_methodRepository) {
            List methodList = TransformationUtil.createSortedMethodList(this.m_prototype.___AW_getAspectClass());
            this.m_methodRepository = new Method[methodList.size()];
            for (int i = 0; i < this.m_methodRepository.length; ++i) {
                Method method = (Method)methodList.get(i);
                method.setAccessible(true);
                this.m_methodRepository[i] = method;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void addIntroductionContainer(String name, IntroductionContainer introContainer) {
        this.m_introductionContainers.put(name, introContainer);
    }

    public IntroductionContainer getIntroductionContainer(String name) {
        return (IntroductionContainer)this.m_introductionContainers.get(name);
    }
}

