/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.aspect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.attribdef.aspect.Aspect;
import org.codehaus.aspectwerkz.attribdef.aspect.AspectContainer;
import org.codehaus.aspectwerkz.attribdef.aspect.Introduction;
import org.codehaus.aspectwerkz.attribdef.aspect.IntroductionContainer;
import org.codehaus.aspectwerkz.attribdef.definition.IntroductionDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class DefaultIntroductionContainerStrategy
implements IntroductionContainer {
    protected Introduction m_perJvm;
    protected Map m_perClass = new HashMap();
    protected Map m_perInstance = new WeakHashMap();
    protected Map m_perThread = new WeakHashMap();
    protected Introduction m_prototype;
    protected Method[] m_methodRepository = new Method[0];

    public DefaultIntroductionContainerStrategy(Introduction prototype, AspectContainer definingAspectContainer) {
        if (prototype == null) {
            throw new IllegalArgumentException("introduction prototype can not be null");
        }
        this.m_prototype = prototype;
        this.createMethodRepository();
        definingAspectContainer.addIntroductionContainer(prototype.___AW_getName(), this);
    }

    public Object invokeIntroductionPerJvm(int methodIndex, Object[] parameters) {
        Object result = null;
        try {
            if (this.m_perJvm == null) {
                Aspect perJVMAspect = this.getRelatedAspect(null);
                this.m_perJvm = Introduction.newInstance(this.m_prototype, perJVMAspect);
            }
            result = this.m_methodRepository[methodIndex].invoke(this.m_perJvm.___AW_getImplementation(), parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeIntroductionPerClass(Object targetInstance, int methodIndex, Object[] parameters) {
        Class<?> targetClass = targetInstance.getClass();
        Object result = null;
        try {
            if (!this.m_perClass.containsKey(targetClass)) {
                Map map = this.m_perClass;
                synchronized (map) {
                    Aspect relatedAspect = this.getRelatedAspect(targetClass);
                    Introduction perClassIntroduction = Introduction.newInstance(this.m_prototype, relatedAspect);
                    this.m_perClass.put(targetClass, perClassIntroduction);
                }
            }
            result = this.m_methodRepository[methodIndex].invoke(((Introduction)this.m_perClass.get(targetClass)).___AW_getImplementation(), parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeIntroductionPerInstance(Object targetInstance, int methodIndex, Object[] parameters) {
        Object result = null;
        try {
            if (!this.m_perInstance.containsKey(targetInstance)) {
                Map map = this.m_perInstance;
                synchronized (map) {
                    Aspect relatedAspect = this.getRelatedAspect(targetInstance);
                    Introduction perInstanceIntroduction = Introduction.newInstance(this.m_prototype, relatedAspect);
                    this.m_perInstance.put(targetInstance, perInstanceIntroduction);
                }
            }
            result = this.m_methodRepository[methodIndex].invoke(((Introduction)this.m_perInstance.get(targetInstance)).___AW_getImplementation(), parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeIntroductionPerThread(int methodIndex, Object[] parameters) {
        Object result;
        try {
            Thread currentThread = Thread.currentThread();
            if (!this.m_perThread.containsKey(currentThread)) {
                Map map = this.m_perThread;
                synchronized (map) {
                    Aspect perThread = this.getRelatedAspect(currentThread);
                    this.m_perThread.put(currentThread, Introduction.newInstance(this.m_prototype, perThread));
                }
            }
            result = this.m_methodRepository[methodIndex].invoke(((Introduction)this.m_perThread.get(currentThread)).___AW_getImplementation(), parameters);
        }
        catch (InvocationTargetException e) {
            throw new WrappedRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return result;
    }

    private Aspect getRelatedAspect(Object referent) {
        Aspect aspect = this.m_prototype.getAspect();
        switch (this.m_prototype.___AW_getDeploymentModel()) {
            case 0: {
                return aspect.___AW_getContainer().getPerJvmAspect();
            }
            case 1: {
                if (aspect.___AW_getDeploymentModel() == 1) {
                    return aspect.___AW_getContainer().getPerClassAspect((Class)referent);
                }
                return aspect.___AW_getContainer().getPerJvmAspect();
            }
            case 2: {
                if (aspect.___AW_getDeploymentModel() == 2) {
                    return aspect.___AW_getContainer().getPerInstanceAspect(referent);
                }
                if (aspect.___AW_getDeploymentModel() == 1) {
                    return aspect.___AW_getContainer().getPerClassAspect(referent.getClass());
                }
                return aspect.___AW_getContainer().getPerJvmAspect();
            }
            case 3: {
                return aspect.___AW_getContainer().getPerThreadAspect();
            }
        }
        throw new RuntimeException("should not get here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapImplementation(Class newImplementationClass) {
        if (newImplementationClass == null) {
            throw new IllegalArgumentException("new implementation class class can not be null");
        }
        IntroductionDefinition def = this.m_prototype.getIntroductionDefinition();
        Iterator intfs = def.getInterfaceClassNames().iterator();
        while (intfs.hasNext()) {
            if (DefaultIntroductionContainerStrategy.findInterfaceInHierarchy(newImplementationClass, (String)intfs.next())) continue;
            throw new DefinitionException("new implementation class is not compatible");
        }
        DefaultIntroductionContainerStrategy defaultIntroductionContainerStrategy = this;
        synchronized (defaultIntroductionContainerStrategy) {
            try {
                this.m_prototype.swapImplementation(newImplementationClass);
                this.createMethodRepository();
                this.m_perJvm = null;
                this.m_perClass = new HashMap(this.m_perClass.size());
                this.m_perInstance = new WeakHashMap(this.m_perClass.size());
                this.m_perThread = new WeakHashMap(this.m_perClass.size());
            }
            catch (Exception e) {
                new WrappedRuntimeException(e);
            }
        }
    }

    private static boolean findInterfaceInHierarchy(Class root, String requiredInterface) {
        if (root == null) {
            return false;
        }
        Class<?>[] interfaces = root.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> implemented = interfaces[i];
            if (!implemented.getName().equals(requiredInterface) && !DefaultIntroductionContainerStrategy.findInterfaceInHierarchy(implemented, requiredInterface)) continue;
            return true;
        }
        return DefaultIntroductionContainerStrategy.findInterfaceInHierarchy(root.getSuperclass(), requiredInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMethodRepository() {
        Method[] methodArray = this.m_methodRepository;
        synchronized (this.m_methodRepository) {
            List methodList = TransformationUtil.createSortedMethodList(this.m_prototype.___AW_getImplementation().getClass());
            this.m_methodRepository = new Method[methodList.size()];
            for (int i = 0; i < this.m_methodRepository.length; ++i) {
                Method method = (Method)methodList.get(i);
                method.setAccessible(true);
                this.m_methodRepository[i] = method;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Object getTargetInstance(Object mixinImpl) {
        Object targetInstance = null;
        if (this.m_prototype.___AW_getDeploymentModel() == 2) {
            Iterator i = this.m_perInstance.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object mixin = ((Introduction)entry.getValue()).___AW_getImplementation();
                if (!mixinImpl.equals(mixin)) continue;
                targetInstance = entry.getKey();
                break;
            }
        }
        return targetInstance;
    }

    public Class getTargetClass(Object mixinImpl) {
        Class targetClass;
        block3: {
            block2: {
                targetClass = null;
                if (this.m_prototype.___AW_getDeploymentModel() != 2) break block2;
                Object instance = this.getTargetInstance(mixinImpl);
                if (instance == null) break block3;
                targetClass = instance.getClass();
                break block3;
            }
            if (this.m_prototype.___AW_getDeploymentModel() == 1) {
                Iterator i = this.m_perClass.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object mixin = ((Introduction)entry.getValue()).___AW_getImplementation();
                    if (!mixinImpl.equals(mixin)) continue;
                    targetClass = (Class)entry.getKey();
                    break;
                }
            }
        }
        return targetClass;
    }
}

