/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.aspect;

import java.lang.reflect.Constructor;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.Mixin;
import org.codehaus.aspectwerkz.attribdef.aspect.Aspect;
import org.codehaus.aspectwerkz.attribdef.aspect.IntroductionContainer;
import org.codehaus.aspectwerkz.attribdef.definition.IntroductionDefinition;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class Introduction
implements Mixin {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private String m_name;
    private Class m_mixinImplClass;
    private Object m_mixinImpl;
    private IntroductionContainer m_container;
    private Aspect m_aspect;
    private IntroductionDefinition m_definition;
    protected int m_deploymentModel;

    public Introduction(String name, Class implClass, Aspect aspect, IntroductionDefinition definition) {
        this.m_name = name;
        this.m_aspect = aspect;
        this.m_definition = definition;
        this.m_mixinImplClass = implClass;
        if (definition.getDeploymentModel() == null) {
            this.m_deploymentModel = this.m_aspect.___AW_getDeploymentModel();
        } else {
            int model = DeploymentModel.getDeploymentModelAsInt(definition.getDeploymentModel());
            if (DeploymentModel.isMixinDeploymentModelCompatible(model, this.m_aspect.___AW_getDeploymentModel())) {
                this.m_deploymentModel = model;
            } else {
                throw new RuntimeException("could no create mixin from aspect: incompatible deployment models : mixin " + DeploymentModel.getDeploymentModelAsString(model) + " with aspect " + DeploymentModel.getDeploymentModelAsString(this.m_aspect.___AW_getDeploymentModel()));
            }
        }
        try {
            if (Introduction.isInnerClassOf(implClass, aspect.___AW_getAspectClass())) {
                Constructor<?> constructor = this.m_mixinImplClass.getConstructors()[0];
                constructor.setAccessible(true);
                this.m_mixinImpl = constructor.newInstance(aspect);
            } else {
                this.m_mixinImpl = this.m_mixinImplClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could no create mixin from aspect [be sure to have a public Mixin impl as inner class]: " + e.getMessage());
        }
    }

    public static Introduction newInstance(Introduction prototype, Aspect aspect) {
        return new Introduction(prototype.m_name, prototype.m_mixinImplClass, aspect, prototype.m_definition);
    }

    public void setContainer(IntroductionContainer container) {
        this.m_container = container;
    }

    public Aspect getAspect() {
        return this.m_aspect;
    }

    public IntroductionDefinition getIntroductionDefinition() {
        return this.m_definition;
    }

    public String ___AW_getName() {
        return this.m_name;
    }

    public int ___AW_getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public void ___AW_setDeploymentModel(int deploymentModel) {
        this.m_deploymentModel = deploymentModel;
    }

    public Object ___AW_invokeMixin(int methodIndex, Object callingObject) {
        return this.___AW_invokeMixin(methodIndex, EMPTY_OBJECT_ARRAY, callingObject);
    }

    public Object ___AW_invokeMixin(int methodIndex, Object[] parameters, Object callingObject) {
        try {
            Object result = null;
            switch (this.___AW_getDeploymentModel()) {
                case 0: {
                    result = this.m_container.invokeIntroductionPerJvm(methodIndex, parameters);
                    break;
                }
                case 1: {
                    result = this.m_container.invokeIntroductionPerClass(callingObject, methodIndex, parameters);
                    break;
                }
                case 2: {
                    result = this.m_container.invokeIntroductionPerInstance(callingObject, methodIndex, parameters);
                    break;
                }
                case 3: {
                    result = this.m_container.invokeIntroductionPerThread(methodIndex, parameters);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid deployment model: " + this.m_aspect.___AW_getDeploymentModel());
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public String ___AW_getImplementationClassName() {
        return this.m_mixinImpl.getClass().getName();
    }

    public Object ___AW_getImplementation() {
        return this.m_mixinImpl;
    }

    public void ___AW_swapImplementation(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        try {
            Class newImplClass = ContextClassLoader.loadClass(className);
            this.m_container.swapImplementation(newImplClass);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public void swapImplementation(Class newImplClass) {
        try {
            this.m_mixinImplClass = newImplClass;
            if (Introduction.isInnerClassOf(this.m_mixinImplClass, this.m_aspect.___AW_getAspectClass())) {
                Constructor<?> constructor = newImplClass.getConstructors()[0];
                constructor.setAccessible(true);
                this.m_mixinImpl = constructor.newInstance(this.m_aspect);
            } else {
                this.m_mixinImpl = this.m_mixinImplClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could no create mixin from aspect [be sure to have a public Mixin impl as inner class]: " + e.getMessage());
        }
    }

    private static boolean isInnerClassOf(Class klazz, Class containingClass) {
        return klazz.getName().startsWith(containingClass.getName() + "$");
    }
}

