/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition;

import java.lang.reflect.Method;
import org.codehaus.aspectwerkz.attribdef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;

public class AdviceDefinition {
    private String m_name;
    private final String m_aspectClassName;
    private final String m_aspectName;
    private Expression m_expression;
    private final Method m_method;
    private final int m_methodIndex;
    private String m_attribute = "";
    private AspectDefinition m_aspectDefinition;

    public AdviceDefinition(String name, String aspectName, String aspectClassName, Expression expression, Method method, int methodIndex, AspectDefinition aspectDef) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (aspectName == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (aspectClassName == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("expression can not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method can not be null");
        }
        if (methodIndex < 0) {
            throw new IllegalArgumentException("method index is not valid");
        }
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        this.m_name = name;
        this.m_aspectName = aspectName;
        this.m_aspectClassName = aspectClassName;
        this.m_expression = expression;
        this.m_method = method;
        this.m_methodIndex = methodIndex;
        this.m_aspectDefinition = aspectDef;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.trim();
    }

    public Expression getExpression() {
        return this.m_expression;
    }

    public String getAspectClassName() {
        return this.m_aspectClassName;
    }

    public String getAspectName() {
        return this.m_aspectName;
    }

    public Method getMethod() {
        return this.m_method;
    }

    public int getMethodIndex() {
        return this.m_methodIndex;
    }

    public String getDeploymentModel() {
        return this.m_aspectDefinition.getDeploymentModel();
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }
}

