/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AfterAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AroundAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AspectAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AttributeEnhancer;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.BeforeAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.CFlowAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.CallAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ClassAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.CustomAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ExecutionAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.GetAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ImplementsAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.IntroduceAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.SetAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ThrowsAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.bcel.BcelAttributeEnhancer;
import org.codehaus.aspectwerkz.metadata.QDoxParser;

public class AspectC {
    public static final String ATTR_GENERIC_PREFIX = "Attribute.";
    public static final String ATTR_ASPECT = "Aspect";
    public static final String ATTR_EXECUTION = "Execution";
    public static final String ATTR_CALL = "Call";
    public static final String ATTR_CLASS = "Class";
    public static final String ATTR_SET = "Set";
    public static final String ATTR_GET = "Get";
    public static final String ATTR_THROWS = "Throws";
    public static final String ATTR_CFLOW = "CFlow";
    public static final String ATTR_AROUND = "Around";
    public static final String ATTR_BEFORE = "Before";
    public static final String ATTR_AFTER = "After";
    public static final String ATTR_INTRODUCE = "Introduce";
    public static final String ATTR_IMPLEMENTS = "Implements";
    private boolean m_verbose = false;

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void compile(String sourcePath, String classPath) {
        this.compile(sourcePath, classPath, classPath);
    }

    public void compile(String sourcePath, String classPath, String destDir) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("source path can not be null");
        }
        if (classPath == null) {
            throw new IllegalArgumentException("class path can not be null");
        }
        QDoxParser qdoxParser = new QDoxParser(sourcePath);
        String[] classNames = qdoxParser.getAllClassNames();
        for (int i = 0; i < classNames.length; ++i) {
            BcelAttributeEnhancer enhancer = new BcelAttributeEnhancer();
            String className = classNames[i];
            if (!enhancer.initialize(className, classPath) || !qdoxParser.parse(className)) continue;
            JavaClass javaClass = this.parseClassAttributes(qdoxParser, enhancer);
            this.parseFieldAttributes(javaClass, enhancer);
            this.parseMethodAttributes(javaClass, enhancer);
            this.parseInnerClassAttributes(javaClass, enhancer);
            enhancer.write(destDir);
        }
    }

    private JavaClass parseClassAttributes(QDoxParser qdoxParser, AttributeEnhancer enhancer) {
        JavaClass javaClass = qdoxParser.getJavaClass();
        this.parseCustomAttributes(javaClass, enhancer);
        this.parseAspect(javaClass, enhancer);
        return javaClass;
    }

    private void parseFieldAttributes(JavaClass javaClass, AttributeEnhancer enhancer) {
        JavaField[] javaFields = javaClass.getFields();
        for (int j = 0; j < javaFields.length; ++j) {
            JavaField javaField = javaFields[j];
            this.parseCustomAttributes(javaField, enhancer);
            this.parseExecutionPointcut(javaField, enhancer);
            this.parseCallPointcut(javaField, enhancer);
            this.parseClassPointcut(javaField, enhancer);
            this.parseSetPointcut(javaField, enhancer);
            this.parseGetPointcut(javaField, enhancer);
            this.parseThrowsPointcut(javaField, enhancer);
            this.parseCFlowPointcut(javaField, enhancer);
            this.parseImplementsPointcut(javaField, enhancer);
        }
    }

    private void parseMethodAttributes(JavaClass javaClass, AttributeEnhancer enhancer) {
        JavaMethod[] javaMethods = javaClass.getMethods();
        for (int j = 0; j < javaMethods.length; ++j) {
            JavaMethod javaMethod = javaMethods[j];
            this.parseCustomAttributes(javaMethod, enhancer);
            this.parseAroundAdvice(javaMethod, enhancer);
            this.parseBeforeAdvice(javaMethod, enhancer);
            this.parseAfterAdvice(javaMethod, enhancer);
        }
    }

    private void parseInnerClassAttributes(JavaClass javaClass, AttributeEnhancer enhancer) {
        JavaClass[] innerClasses = javaClass.getInnerClasses();
        for (int k = 0; k < innerClasses.length; ++k) {
            this.parseIntroduction(innerClasses[k], enhancer);
        }
    }

    private void parseCustomAttributes(JavaClass javaClass, AttributeEnhancer enhancer) {
        DocletTag[] tags = javaClass.getTags();
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            if (!this.isCustomTag(tag)) continue;
            String name = tag.getName();
            String value = tag.getValue();
            enhancer.insertClassAttribute(new CustomAttribute(name, value, null));
            this.log("class [" + javaClass.getFullyQualifiedName() + "]");
            this.log("\tattribute [" + name + " " + value + "]");
        }
    }

    private void parseCustomAttributes(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag[] tags = javaField.getTags();
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            if (!this.isCustomTag(tag)) continue;
            String name = tag.getName();
            String value = tag.getValue();
            enhancer.insertFieldAttribute(javaField, new CustomAttribute(name, value, null));
            this.log("field [" + javaField.getParentClass().getFullyQualifiedName() + "." + javaField.getName() + "]");
            this.log("\tattribute [" + name + " " + value + "]");
        }
    }

    private void parseCustomAttributes(JavaMethod javaMethod, AttributeEnhancer enhancer) {
        DocletTag[] tags = javaMethod.getTags();
        for (int i = 0; i < tags.length; ++i) {
            DocletTag tag = tags[i];
            if (!this.isCustomTag(tag)) continue;
            String name = tag.getName();
            String value = tag.getValue();
            enhancer.insertMethodAttribute(javaMethod, new CustomAttribute(name, value, null));
            this.log("method [" + javaMethod.getParentClass().getFullyQualifiedName() + "." + javaMethod.getName() + "]");
            this.log("\tattribute [" + name + " " + value + "]");
        }
    }

    private void parseAspect(JavaClass javaClass, AttributeEnhancer enhancer) {
        DocletTag aspectTag = javaClass.getTagByName(ATTR_ASPECT);
        if (aspectTag != null) {
            String name = aspectTag.getNamedParameter("name");
            String deploymentModel = null;
            String[] parameters = aspectTag.getParameters();
            for (int j = 0; j < parameters.length; ++j) {
                if (parameters[j].startsWith("name=")) continue;
                deploymentModel = parameters[j];
            }
            enhancer.insertClassAttribute(new AspectAttribute(name, deploymentModel));
            this.log("aspect [" + javaClass.getFullyQualifiedName() + "]");
            this.log("\tdeployment model [" + deploymentModel + "]");
        }
    }

    private void parseExecutionPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_EXECUTION);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new ExecutionAttribute(expression));
        this.log("\texecution pointcut [" + javaField.getName() + "::" + expression + "]");
    }

    private void parseCallPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_CALL);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new CallAttribute(expression));
        this.log("\tcall pointcut [" + javaField.getName() + "::" + expression + "]");
    }

    private void parseClassPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_CLASS);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new ClassAttribute(expression));
        this.log("\tclass pointcut [" + javaField.getName() + "::" + expression + "]");
    }

    private void parseSetPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_SET);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new SetAttribute(expression));
        this.log("\tset pointcut [" + javaField.getName() + "::" + expression + "]");
    }

    private void parseGetPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_GET);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new GetAttribute(expression));
        this.log("\tget pointcut [" + javaField.getName() + "::" + expression + "]");
    }

    private void parseThrowsPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_THROWS);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new ThrowsAttribute(expression));
        this.log("\tthrows pointcut [" + javaField.getName() + "::" + expression + "]");
    }

    private void parseCFlowPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_CFLOW);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new CFlowAttribute(expression));
        this.log("\tcflow pointcut [" + javaField.getName() + "::" + expression + "]");
    }

    private void parseImplementsPointcut(JavaField javaField, AttributeEnhancer enhancer) {
        DocletTag pointcutTag = javaField.getTagByName(ATTR_IMPLEMENTS);
        if (pointcutTag == null) {
            return;
        }
        String expression = pointcutTag.getValue();
        enhancer.insertFieldAttribute(javaField, new ImplementsAttribute(expression));
        this.log("\tinterface introduction [" + javaField.getType().getValue() + "::" + expression + "]");
    }

    private void parseAroundAdvice(JavaMethod javaMethod, AttributeEnhancer enhancer) {
        DocletTag[] aroundAdviceTags = javaMethod.getTagsByName(ATTR_AROUND);
        for (int i = 0; i < aroundAdviceTags.length; ++i) {
            DocletTag aroundAdviceTag = aroundAdviceTags[i];
            String name = aroundAdviceTag.getNamedParameter("name");
            StringBuffer buf = new StringBuffer();
            String[] parameters = aroundAdviceTag.getParameters();
            for (int j = 0; j < parameters.length; ++j) {
                String parameter = parameters[j];
                if (parameter.startsWith("name=")) continue;
                buf.append(parameter);
                buf.append(' ');
            }
            String expression = buf.toString().trim();
            enhancer.insertMethodAttribute(javaMethod, new AroundAttribute(name, expression));
            this.log("\taround advice [" + javaMethod.getName() + "::" + expression + "]");
        }
    }

    private void parseBeforeAdvice(JavaMethod javaMethod, AttributeEnhancer enhancer) {
        DocletTag[] beforeAdviceTags = javaMethod.getTagsByName(ATTR_BEFORE);
        for (int i = 0; i < beforeAdviceTags.length; ++i) {
            DocletTag beforeAdviceTag = beforeAdviceTags[i];
            String name = beforeAdviceTag.getNamedParameter("name");
            StringBuffer buf = new StringBuffer();
            String[] parameters = beforeAdviceTag.getParameters();
            for (int j = 0; j < parameters.length; ++j) {
                String parameter = parameters[j];
                if (parameter.startsWith("name=")) continue;
                buf.append(parameter);
                buf.append(' ');
            }
            String expression = buf.toString().trim();
            enhancer.insertMethodAttribute(javaMethod, new BeforeAttribute(name, expression));
            this.log("\tbefore advice [" + javaMethod.getName() + "::" + expression + "]");
        }
    }

    private void parseAfterAdvice(JavaMethod javaMethod, AttributeEnhancer enhancer) {
        DocletTag[] afterAdviceTags = javaMethod.getTagsByName(ATTR_AFTER);
        for (int i = 0; i < afterAdviceTags.length; ++i) {
            DocletTag afterAdviceTag = afterAdviceTags[i];
            String name = afterAdviceTag.getNamedParameter("name");
            StringBuffer buf = new StringBuffer();
            String[] parameters = afterAdviceTag.getParameters();
            for (int j = 0; j < parameters.length; ++j) {
                String parameter = parameters[j];
                if (parameter.startsWith("name=")) continue;
                buf.append(parameter);
                buf.append(' ');
            }
            String expression = buf.toString().trim();
            enhancer.insertMethodAttribute(javaMethod, new AfterAttribute(name, expression));
            this.log("\tafter advice [" + javaMethod.getName() + "::" + expression + "]");
        }
    }

    private void parseIntroduction(JavaClass innerClass, AttributeEnhancer enhancer) {
        DocletTag[] introductionTags = innerClass.getTagsByName(ATTR_INTRODUCE);
        for (int i = 0; i < introductionTags.length; ++i) {
            int j;
            DocletTag introductionTag = introductionTags[i];
            String deploymentModel = introductionTag.getNamedParameter("deploymentModel");
            StringBuffer buf = new StringBuffer();
            String[] parameters = introductionTag.getParameters();
            for (int j2 = 0; j2 < parameters.length; ++j2) {
                String parameter = parameters[j2];
                if (parameter.startsWith("deploymentModel=")) continue;
                buf.append(parameter);
                buf.append(' ');
            }
            String expression = buf.toString().trim();
            JavaClass[] introducedInterfaceClasses = innerClass.getImplementedInterfaces();
            String[] introducedInterfaceNames = new String[introducedInterfaceClasses.length];
            for (j = 0; j < introducedInterfaceClasses.length; ++j) {
                introducedInterfaceNames[j] = introducedInterfaceClasses[j].getFullyQualifiedName();
                this.log("\tintroduction introduce [" + introducedInterfaceNames[j] + "]");
            }
            if (introducedInterfaceNames.length == 0) {
                introducedInterfaceNames = enhancer.getNearestInterfacesInHierarchy(innerClass.getFullyQualifiedName());
                if (introducedInterfaceNames.length == 0) {
                    throw new RuntimeException("no implicit interfaces found for " + innerClass.getFullyQualifiedName());
                }
                for (j = 0; j < introducedInterfaceNames.length; ++j) {
                    this.log("\tintroduction introduce implicit [" + introducedInterfaceNames[j] + "]");
                }
            }
            enhancer.insertClassAttribute(new IntroduceAttribute(expression, innerClass.getFullyQualifiedName(), introducedInterfaceNames, deploymentModel));
            this.log("\tintroduction impl [" + innerClass.getName() + "::" + expression + "] " + deploymentModel);
        }
    }

    private boolean isCustomTag(DocletTag tag) {
        return tag.getName().startsWith(ATTR_GENERIC_PREFIX);
    }

    private void log(String message) {
        if (this.m_verbose) {
            System.out.println("AspectC::INFO - " + message);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("AspectWerkz (c) 2002-2003 Jonas Bon\u00e9r, Alexandre Vasseur");
            System.out.println("usage: java [options...] org.codehaus.aspectwerkz.attribdef.definition.AspectC [-verbose] <path to src dir> <path to classes dir> [<path to destination dir>]");
            System.out.println("       <path to destination dir> is optional, if omitted the compiled classes will be written to the initial directory");
            System.out.println("       use -verbose to activate verbose logging");
            System.exit(0);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> options = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                options.add(args[i]);
                continue;
            }
            arguments.add(args[i]);
        }
        AspectC compiler = new AspectC();
        compiler.setVerbose(options.contains("-verbose"));
        compiler.log("compiling attributes...");
        if (arguments.size() == 2) {
            compiler.compile((String)arguments.get(0), (String)arguments.get(1));
            compiler.log("compiled classes written to " + (String)arguments.get(1));
        } else {
            compiler.compile((String)arguments.get(0), (String)arguments.get(1), (String)arguments.get(2));
            compiler.log("compiled classes written to " + (String)arguments.get(2));
        }
        compiler.log("compilation successful");
    }
}

