/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.MethodComparator;
import org.codehaus.aspectwerkz.attribdef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.ControllerDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.InterfaceIntroductionDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.IntroductionDefinition;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;

public class AspectDefinition {
    private String m_name;
    private final String m_className;
    private final String m_deploymentModel;
    private final List m_aroundAdvices = new ArrayList();
    private final List m_beforeAdvices = new ArrayList();
    private final List m_afterAdvices = new ArrayList();
    private final List m_interfaceIntroductions = new ArrayList();
    private final List m_introductions = new ArrayList();
    private final List m_pointcutDefs = new ArrayList();
    private Map m_parameters = new HashMap();
    private final Map m_controllerDefs = new HashMap();

    public AspectDefinition(String name, String className, String deploymentModel) {
        if (name == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("aspect class name can not be null");
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException("deployment model can not be null");
        }
        this.m_name = name;
        this.m_className = className;
        this.m_deploymentModel = deploymentModel;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name.trim();
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public void addAroundAdvice(AdviceDefinition adviceMetaData) {
        this.m_aroundAdvices.add(adviceMetaData);
    }

    public List getAroundAdvices() {
        return this.m_aroundAdvices;
    }

    public void addBeforeAdvice(AdviceDefinition adviceMetaData) {
        this.m_beforeAdvices.add(adviceMetaData);
    }

    public List getBeforeAdvices() {
        return this.m_beforeAdvices;
    }

    public void addAfterAdvice(AdviceDefinition adviceMetaData) {
        this.m_afterAdvices.add(adviceMetaData);
    }

    public List getAfterAdvices() {
        return this.m_afterAdvices;
    }

    public void addInterfaceIntroduction(InterfaceIntroductionDefinition interfaceIntroductionMetaData) {
        this.m_interfaceIntroductions.add(interfaceIntroductionMetaData);
    }

    public void addIntroduction(IntroductionDefinition introductionMetaData) {
        this.m_introductions.add(introductionMetaData);
    }

    public List getInterfaceIntroductions() {
        return this.m_interfaceIntroductions;
    }

    public List getIntroductions() {
        return this.m_introductions;
    }

    public void addPointcut(PointcutDefinition pointcutDef) {
        this.m_pointcutDefs.add(pointcutDef);
    }

    public Collection getPointcuts() {
        return this.m_pointcutDefs;
    }

    public PointcutDefinition getPointcutDef(String pointcutName) {
        Iterator it = this.m_pointcutDefs.iterator();
        while (it.hasNext()) {
            PointcutDefinition pointcutDef = (PointcutDefinition)it.next();
            if (!pointcutDef.getName().equals(pointcutName)) continue;
            return pointcutDef;
        }
        return null;
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public Map getParameters() {
        return this.m_parameters;
    }

    public Collection getControllers() {
        return this.m_controllerDefs.values();
    }

    public void addController(ControllerDefinition controllerDef) {
        this.m_controllerDefs.put(controllerDef.getExpression(), controllerDef);
    }

    public List getAllAdvices() {
        ArrayList allAdvices = new ArrayList();
        allAdvices.addAll(this.m_aroundAdvices);
        allAdvices.addAll(this.m_beforeAdvices);
        allAdvices.addAll(this.m_afterAdvices);
        return AspectDefinition.sortAdvices(allAdvices);
    }

    public static List sortAdvices(List advices) {
        Collections.sort(advices, new Comparator(){
            private Comparator m_comparator = MethodComparator.getInstance(0);

            public int compare(Object obj1, Object obj2) {
                AdviceDefinition advice1 = (AdviceDefinition)obj1;
                AdviceDefinition advice2 = (AdviceDefinition)obj2;
                return this.m_comparator.compare(advice1.getMethod(), advice2.getMethod());
            }
        });
        return advices;
    }
}

