/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.attribdef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.ControllerDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.InterfaceIntroductionDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.IntroductionDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AspectAttributeParser;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.DefaultAspectAttributeParser;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.util.SequencedHashMap;

public class AspectWerkzDefinitionImpl
implements AspectWerkzDefinition {
    private final TObjectIntHashMap m_aspectIndexes = new TObjectIntHashMap();
    private final TObjectIntHashMap m_introductionIndexes = new TObjectIntHashMap();
    private Set m_aspectsToUse = new HashSet();
    private final Map m_aspectMap = new SequencedHashMap();
    private final Map m_introductionMap = new HashMap();
    private final Map m_interfaceIntroductionMap = new HashMap();
    private String m_uuid = "default";
    private final Set m_includePackages = new HashSet();
    private final Set m_excludePackages = new HashSet();
    private final AspectAttributeParser m_attributeParser = new DefaultAspectAttributeParser();
    private boolean m_aspectsLoaded = false;
    private final Map m_parametersToAspects = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectWerkzDefinitionImpl() {
        AspectDefinition systemAspect = new AspectDefinition("org/codehaus/aspectwerkz/system", "org.codehaus.aspectwerkz.attribdef.aspect.CFlowSystemAspect", "perThread");
        Map map = this.m_aspectMap;
        synchronized (map) {
            this.m_aspectMap.put("org/codehaus/aspectwerkz/system", systemAspect);
        }
    }

    public void loadAspects(ClassLoader loader) {
        if (this.m_aspectsLoaded) {
            return;
        }
        this.m_aspectsLoaded = true;
        Iterator it = this.getAspectsToUse().iterator();
        while (it.hasNext()) {
            this.loadAspect((String)it.next(), loader);
        }
    }

    public boolean isAttribDef() {
        return true;
    }

    public boolean isXmlDef() {
        return false;
    }

    public void setUuid(String uuid) {
        this.m_uuid = uuid;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    public Set getIncludePackages() {
        return this.m_includePackages;
    }

    public Set getExcludePackages() {
        return this.m_excludePackages;
    }

    public Collection getAspectDefinitions() {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        ArrayList clone = new ArrayList(this.m_aspectMap.size());
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            clone.add(it.next());
        }
        return clone;
    }

    public Collection getIntroductionDefinitions() {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        ArrayList clone = new ArrayList(this.m_introductionMap.size());
        Iterator it = this.m_introductionMap.values().iterator();
        while (it.hasNext()) {
            clone.add(it.next());
        }
        return clone;
    }

    public Collection getAdviceDefinitions() {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        ArrayList adviceDefs = new ArrayList();
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            adviceDefs.addAll(aspectDef.getAroundAdvices());
            adviceDefs.addAll(aspectDef.getBeforeAdvices());
            adviceDefs.addAll(aspectDef.getAfterAdvices());
        }
        return adviceDefs;
    }

    public AspectDefinition getAspectDefinition(String name) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        return (AspectDefinition)this.m_aspectMap.get(name);
    }

    public AdviceDefinition getAdviceDefinition(String name) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        Collection adviceDefs = this.getAdviceDefinitions();
        Iterator it = adviceDefs.iterator();
        while (it.hasNext()) {
            AdviceDefinition adviceDef = (AdviceDefinition)it.next();
            if (!adviceDef.getName().equals(name)) continue;
            return adviceDef;
        }
        return null;
    }

    public String getIntroductionImplName(String introductionName) {
        throw new UnsupportedOperationException("not implemented");
    }

    public List getIntroductionDefinitions(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        ArrayList<IntroductionDefinition> introDefs = new ArrayList<IntroductionDefinition>();
        Iterator it = this.m_introductionMap.values().iterator();
        while (it.hasNext()) {
            IntroductionDefinition introDef = (IntroductionDefinition)it.next();
            if (!introDef.getExpression().match(classMetaData)) continue;
            introDefs.add(introDef);
        }
        return introDefs;
    }

    public int getAspectIndexByName(String aspectName) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (aspectName == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        int index = this.m_aspectIndexes.get((Object)aspectName);
        if (index < 1) {
            throw new RuntimeException("aspect [" + aspectName + "] does not exist, failed in retrieving aspect index");
        }
        return index;
    }

    public int getMixinIndexByName(String mixinName) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (mixinName == null) {
            throw new IllegalArgumentException("mixin name can not be null");
        }
        int index = this.m_introductionIndexes.get((Object)mixinName);
        if (index < 1) {
            throw new RuntimeException("mixin [" + mixinName + "] does not exist, failed in retrieving mixin index");
        }
        return index;
    }

    public String getJoinPointController(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Collection controllerDefs = aspectDef.getControllers();
            Iterator it2 = controllerDefs.iterator();
            while (it2.hasNext()) {
                ControllerDefinition controllerDef = (ControllerDefinition)it2.next();
                if (!controllerDef.getExpression().match(classMetaData, methodMetaData)) continue;
                return controllerDef.getClassName();
            }
        }
        return null;
    }

    public Set getAspectsToUse() {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        return this.m_aspectsToUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAspect(AspectDefinition aspectDef) {
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        if (this.m_aspectIndexes.containsKey((Object)aspectDef.getName())) {
            return;
        }
        Map map = this.m_aspectMap;
        synchronized (map) {
            TObjectIntHashMap tObjectIntHashMap = this.m_aspectIndexes;
            synchronized (tObjectIntHashMap) {
                int index = this.m_aspectMap.values().size() + 1;
                this.m_aspectIndexes.put((Object)aspectDef.getName(), index);
                this.m_aspectMap.put(aspectDef.getName(), aspectDef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntroductionDefinition(IntroductionDefinition introDef) {
        if (introDef == null) {
            throw new IllegalArgumentException("introduction definition can not be null");
        }
        if (this.m_introductionIndexes.containsKey((Object)introDef.getName())) {
            return;
        }
        Map map = this.m_introductionMap;
        synchronized (map) {
            TObjectIntHashMap tObjectIntHashMap = this.m_introductionIndexes;
            synchronized (tObjectIntHashMap) {
                int index = this.m_introductionMap.values().size() + 1;
                this.m_introductionIndexes.put((Object)introDef.getName(), index);
                this.m_introductionMap.put(introDef.getName(), introDef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterfaceIntroductionDefinition(InterfaceIntroductionDefinition introDef) {
        if (introDef == null) {
            throw new IllegalArgumentException("introduction definition can not be null");
        }
        Map map = this.m_interfaceIntroductionMap;
        synchronized (map) {
            this.m_interfaceIntroductionMap.put(introDef.getName(), introDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAspectToUse(String className) {
        Set set = this.m_aspectsToUse;
        synchronized (set) {
            this.m_aspectsToUse.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludePackage(String includePackage) {
        Set set = this.m_includePackages;
        synchronized (set) {
            this.m_includePackages.add(includePackage + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcludePackage(String excludePackage) {
        Set set = this.m_excludePackages;
        synchronized (set) {
            this.m_excludePackages.add(excludePackage + ".");
        }
    }

    public boolean hasAdvice(String name) {
        Collection adviceDefs = this.getAdviceDefinitions();
        Iterator it = adviceDefs.iterator();
        while (it.hasNext()) {
            AdviceDefinition adviceDef = (AdviceDefinition)it.next();
            if (!adviceDef.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIntroduction(String name) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        return this.m_introductionMap.containsKey(name);
    }

    public boolean inIncludePackage(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (this.m_includePackages.isEmpty()) {
            return true;
        }
        Iterator it = this.m_includePackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean inExcludePackage(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        Iterator it = this.m_excludePackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIntroductions(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_introductionMap.values().iterator();
        while (it.hasNext()) {
            IntroductionDefinition introDef = (IntroductionDefinition)it.next();
            Expression expression = introDef.getExpression();
            if (!expression.getType().equals(PointcutType.CLASS) || !expression.match(classMetaData)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExecutionPointcut(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.EXECUTION) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasExecutionPointcut(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.EXECUTION) || !expression.match(classMetaData, methodMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasGetPointcut(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.GET) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasGetPointcut(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.GET) || !expression.match(classMetaData, fieldMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSetPointcut(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.SET) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSetPointcut(ClassMetaData classMetaData, FieldMetaData fieldMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (fieldMetaData == null) {
            throw new IllegalArgumentException("field meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.SET) || !expression.match(classMetaData, fieldMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasThrowsPointcut(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.THROWS) || !expression.match(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasThrowsPointcut(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (!expression.getType().equals(PointcutType.THROWS) || !expression.match(classMetaData, methodMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCallPointcut(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (expression.getType().equals(PointcutType.CALL) && expression.match(classMetaData)) {
                    return true;
                }
                if (!expression.matchInOrNotIn(classMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPickedOutByCallPointcut(ClassMetaData classMetaData, MethodMetaData methodMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        if (methodMetaData == null) {
            throw new IllegalArgumentException("method meta-data can not be null");
        }
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                if (expression.getType().equals(PointcutType.CALL) && expression.match(classMetaData, methodMetaData)) {
                    return true;
                }
                if (!expression.matchInOrNotIn(classMetaData, methodMetaData)) continue;
                return true;
            }
        }
        return false;
    }

    public List getInterfaceIntroductions(ClassMetaData classMetaData) {
        if (!this.m_aspectsLoaded) {
            throw new IllegalStateException("aspects are not loaded");
        }
        if (classMetaData == null) {
            throw new IllegalArgumentException("class meta-data can not be null");
        }
        ArrayList<InterfaceIntroductionDefinition> interfaceIntroductionDefs = new ArrayList<InterfaceIntroductionDefinition>();
        Iterator it = this.m_interfaceIntroductionMap.values().iterator();
        while (it.hasNext()) {
            InterfaceIntroductionDefinition introDef = (InterfaceIntroductionDefinition)it.next();
            Expression expression = introDef.getExpression();
            if (!expression.getType().equals(PointcutType.CLASS) || !expression.match(classMetaData)) continue;
            interfaceIntroductionDefs.add(introDef);
        }
        interfaceIntroductionDefs.addAll(this.getIntroductionDefinitions(classMetaData));
        return interfaceIntroductionDefs;
    }

    public void buildMixinMetaDataRepository(Set repository, ClassLoader loader) {
        this.loadAspects(loader);
    }

    public void addParameter(String aspectClassName, String key, String value) {
        if (this.m_parametersToAspects.containsKey(aspectClassName)) {
            Map parameters = (Map)this.m_parametersToAspects.get(aspectClassName);
            parameters.put(key, value);
        } else {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(key, value);
            this.m_parametersToAspects.put(aspectClassName, parameters);
        }
    }

    public Map getParameters(String aspectClassName) {
        if (this.m_parametersToAspects.containsKey(aspectClassName)) {
            return (Map)this.m_parametersToAspects.get(aspectClassName);
        }
        return new HashMap();
    }

    private void loadAspect(String aspectClassName, ClassLoader loader) {
        try {
            Class<?> klass = loader.loadClass(aspectClassName);
            AspectDefinition aspectDef = this.m_attributeParser.parse(klass);
            this.addAspect(aspectDef);
            Iterator mixins = aspectDef.getInterfaceIntroductions().iterator();
            while (mixins.hasNext()) {
                this.addInterfaceIntroductionDefinition((InterfaceIntroductionDefinition)mixins.next());
            }
            mixins = aspectDef.getIntroductions().iterator();
            while (mixins.hasNext()) {
                this.addIntroductionDefinition((IntroductionDefinition)mixins.next());
            }
        }
        catch (ClassNotFoundException e) {
            throw new WrappedRuntimeException(e);
        }
    }
}

