/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition;

import java.util.Iterator;
import org.codehaus.aspectwerkz.attribdef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class DocumentParser {
    public static AspectWerkzDefinition parseSystemElement(Element systemElement, String basePackage) {
        AspectWerkzDefinitionImpl definition = new AspectWerkzDefinitionImpl();
        String uuid = systemElement.attributeValue("id");
        if (uuid == null || uuid.equals("")) {
            uuid = "default";
        }
        definition.setUuid(uuid);
        org.codehaus.aspectwerkz.definition.DocumentParser.parseIncludePackageElements(systemElement, definition, basePackage);
        org.codehaus.aspectwerkz.definition.DocumentParser.parseExcludePackageElements(systemElement, definition, basePackage);
        boolean hasDef = false;
        if (DocumentParser.parseUseAspectElements(systemElement, definition, basePackage)) {
            hasDef = true;
        }
        if (DocumentParser.parsePackageElements(systemElement, definition, basePackage)) {
            hasDef = true;
        }
        if (hasDef) {
            return definition;
        }
        return null;
    }

    private static boolean parsePackageElements(Element systemElement, AspectWerkzDefinition definition, String basePackage) {
        boolean hasDef = false;
        Iterator it1 = systemElement.elementIterator("package");
        while (it1.hasNext()) {
            String packageName;
            Element packageElement = (Element)it1.next();
            if (!DocumentParser.parseUseAspectElements(packageElement, definition, packageName = basePackage + DocumentParser.getPackage(packageElement))) continue;
            hasDef = true;
        }
        return hasDef;
    }

    private static boolean parseUseAspectElements(Element systemElement, AspectWerkzDefinition definition, String packageName) {
        boolean hasDef = false;
        Iterator it1 = systemElement.elementIterator("use-aspect");
        while (it1.hasNext()) {
            String className = null;
            Element aspect = (Element)it1.next();
            Iterator it2 = aspect.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (!name.equals("class")) continue;
                className = value;
                break;
            }
            String aspectClassName = packageName + className;
            AspectWerkzDefinitionImpl def = (AspectWerkzDefinitionImpl)definition;
            Iterator it22 = aspect.elementIterator();
            while (it22.hasNext()) {
                Element nestedAdviceElement = (Element)it22.next();
                if (!nestedAdviceElement.getName().trim().equals("param")) continue;
                def.addParameter(aspectClassName, nestedAdviceElement.attributeValue("name"), nestedAdviceElement.attributeValue("value"));
            }
            definition.addAspectToUse(aspectClassName);
            hasDef = true;
        }
        return hasDef;
    }

    private static String getPackage(Element packageElement) {
        String packageName = "";
        Iterator it2 = packageElement.attributeIterator();
        while (it2.hasNext()) {
            Attribute attribute = (Attribute)it2.next();
            if (!attribute.getName().trim().equals("name")) continue;
            packageName = attribute.getValue().trim();
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 1);
                break;
            }
            if (packageName.endsWith(".")) break;
            packageName = packageName + ".";
            break;
        }
        return packageName;
    }
}

