/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.AspectMetaData;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.attribdef.AttribDefSystem;
import org.codehaus.aspectwerkz.attribdef.aspect.Aspect;
import org.codehaus.aspectwerkz.attribdef.aspect.AspectContainer;
import org.codehaus.aspectwerkz.attribdef.aspect.CFlowSystemAspect;
import org.codehaus.aspectwerkz.attribdef.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.definition.expression.ExpressionExpression;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.pointcut.CallPointcut;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;
import org.codehaus.aspectwerkz.pointcut.GetPointcut;
import org.codehaus.aspectwerkz.pointcut.SetPointcut;
import org.codehaus.aspectwerkz.pointcut.ThrowsPointcut;

public class StartupManager {
    public static final String ASPECTWERKZ_HOME = System.getProperty("aspectwerkz.home", ".");
    public static final String DEFINITION_FILE = System.getProperty("aspectwerkz.definition.file", null);
    public static final String DEFINITION_CLASS_NAME = System.getProperty("aspectwerkz.definition.class", null);
    public static final String DEFAULT_DEFINITION_FILE = "aspectwerkz.xml";
    public static final String DEFAULT_ASPECT_CONTAINER = "org.codehaus.aspectwerkz.attribdef.aspect.DefaultAspectContainerStrategy";
    public static final String ASPECT_CONTAINER_IMPLEMENTATION_CLASS = System.getProperty("aspectwerkz.aspect.container.impl", "org.codehaus.aspectwerkz.attribdef.aspect.DefaultAspectContainerStrategy");
    private static boolean s_initialized = false;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$attribdef$aspect$CFlowSystemAspect;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$joinpoint$JoinPoint;

    public static void initializeSystem(String uuid, AspectWerkzDefinition definition) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("definition can not be null");
        }
        if (s_initialized) {
            return;
        }
        s_initialized = true;
        definition.loadAspects(ContextClassLoader.getLoader());
        AspectWerkzDefinitionImpl def = (AspectWerkzDefinitionImpl)definition;
        StartupManager.registerAspects(uuid, def);
        StartupManager.registerPointcuts(uuid, def);
    }

    public static AspectContainer createAspectContainer(Aspect aspect) {
        if (aspect == null) {
            throw new IllegalArgumentException("aspect can not be null");
        }
        try {
            Class klass = ContextClassLoader.loadClass(ASPECT_CONTAINER_IMPLEMENTATION_CLASS);
            Constructor constructor = klass.getConstructor(class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect == null ? (class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect = StartupManager.class$("org.codehaus.aspectwerkz.attribdef.aspect.Aspect")) : class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect);
            return (AspectContainer)constructor.newInstance(aspect);
        }
        catch (Exception e) {
            StringBuffer cause = new StringBuffer();
            cause.append("could not create aspect container using specified class [");
            cause.append(ASPECT_CONTAINER_IMPLEMENTATION_CLASS);
            cause.append("]: ");
            cause.append(e.getMessage());
            throw new RuntimeException(cause.toString());
        }
    }

    private static void registerAspects(String uuid, AspectWerkzDefinitionImpl definition) {
        try {
            Iterator it = definition.getAspectDefinitions().iterator();
            while (it.hasNext()) {
                AspectDefinition aspectDef = (AspectDefinition)it.next();
                StartupManager.registerAspect(uuid, aspectDef, definition.getParameters(aspectDef.getClassName()));
            }
        }
        catch (NullPointerException e) {
            throw new DefinitionException("aspects not properly defined");
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static void registerAspect(String uuid, AspectDefinition aspectDef, Map parameters) {
        try {
            Aspect aspect;
            Class aspectClass;
            String aspectClassName = aspectDef.getClassName();
            try {
                aspectClass = ContextClassLoader.loadClass(aspectClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(aspectClassName + " could not be found on classpath");
            }
            try {
                aspect = (Aspect)aspectClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("could not create a new instance of aspect [" + aspectClassName + "], does the class inherit the [org.codehaus.aspectwerkz.attribdef.aspect.Aspect] class?");
            }
            int deploymentModel = aspectDef.getDeploymentModel() == null || aspectDef.getDeploymentModel().equals("") ? 0 : DeploymentModel.getDeploymentModelAsInt(aspectDef.getDeploymentModel());
            Field field = (class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect == null ? (class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect = StartupManager.class$("org.codehaus.aspectwerkz.attribdef.aspect.Aspect")) : class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect).getDeclaredField("m_uuid");
            field.setAccessible(true);
            field.set(aspect, uuid);
            aspect.___AW_setName(aspectDef.getName());
            aspect.___AW_setAspectClass(aspectClass);
            aspect.___AW_setDeploymentModel(deploymentModel);
            aspect.___AW_setAspectDef(aspectDef);
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                aspect.___AW_setParameter((String)entry.getKey(), (String)entry.getValue());
            }
            AspectContainer container = StartupManager.createAspectContainer(aspect);
            if (container == null) {
                throw new DefinitionException("could not create aspect container for aspect [" + aspect.___AW_getName() + "]");
            }
            aspect.___AW_setContainer(container);
            AspectMetaData aspectMetaData = new AspectMetaData(uuid, aspectDef.getName(), deploymentModel);
            ((AttribDefSystem)SystemLoader.getSystem(uuid)).register(aspect, aspectMetaData);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static void registerPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        StartupManager.registerCFlowPointcuts(uuid, definition);
        StartupManager.registerExecutionPointcuts(uuid, definition);
        StartupManager.registerCallPointcuts(uuid, definition);
        StartupManager.registerSetPointcuts(uuid, definition);
        StartupManager.registerGetPointcuts(uuid, definition);
        StartupManager.registerThrowsPointcuts(uuid, definition);
    }

    private static void registerExecutionPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it = definition.getAspectDefinitions().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            AspectMetaData aspectMetaData = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDef.getName());
            List aroundAdvices = aspectDef.getAroundAdvices();
            Iterator it2 = aroundAdvices.iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                ExecutionPointcut pointcut = aspectMetaData.getExecutionPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new ExecutionPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addExecutionPointcut(pointcut);
                }
                pointcut.addAdvice(adviceDef.getName());
            }
        }
    }

    private static void registerSetPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it = definition.getAspectDefinitions().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            AspectMetaData aspectMetaData = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDef.getName());
            List beforeAdvices = aspectDef.getBeforeAdvices();
            Iterator it2 = beforeAdvices.iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                SetPointcut pointcut = aspectMetaData.getSetPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new SetPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addSetPointcut(pointcut);
                }
                pointcut.addBeforeAdvice(adviceDef.getName());
            }
            List afterAdvices = aspectDef.getAfterAdvices();
            Iterator it22 = afterAdvices.iterator();
            while (it22.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it22.next();
                SetPointcut pointcut = aspectMetaData.getSetPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new SetPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addSetPointcut(pointcut);
                }
                pointcut.addAfterAdvice(adviceDef.getName());
            }
        }
    }

    private static void registerGetPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it = definition.getAspectDefinitions().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            AspectMetaData aspectMetaData = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDef.getName());
            List beforeAdvices = aspectDef.getBeforeAdvices();
            Iterator it2 = beforeAdvices.iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                GetPointcut pointcut = aspectMetaData.getGetPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new GetPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addGetPointcut(pointcut);
                }
                pointcut.addBeforeAdvice(adviceDef.getName());
            }
            List afterAdvices = aspectDef.getAfterAdvices();
            Iterator it22 = afterAdvices.iterator();
            while (it22.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it22.next();
                GetPointcut pointcut = aspectMetaData.getGetPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new GetPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addGetPointcut(pointcut);
                }
                pointcut.addAfterAdvice(adviceDef.getName());
            }
        }
    }

    private static void registerCallPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it1.next();
            AspectMetaData aspectMetaData = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDef.getName());
            List beforeAdvices = aspectDef.getBeforeAdvices();
            Iterator it2 = beforeAdvices.iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                CallPointcut pointcut = aspectMetaData.getCallPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new CallPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addCallPointcut(pointcut);
                }
                pointcut.addBeforeAdvice(adviceDef.getName());
            }
            List afterAdvices = aspectDef.getAfterAdvices();
            Iterator it22 = afterAdvices.iterator();
            while (it22.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it22.next();
                CallPointcut pointcut = aspectMetaData.getCallPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new CallPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addCallPointcut(pointcut);
                }
                pointcut.addAfterAdvice(adviceDef.getName());
            }
        }
    }

    private static void registerCFlowPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it1 = definition.getAspectDefinitions().iterator();
        while (it1.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it1.next();
            AspectMetaData aspect = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDef.getName());
            Iterator it2 = aspectDef.getAllAdvices().iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                Expression expression = adviceDef.getExpression();
                Iterator it3 = expression.getCflowExpressions().entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry entry = it3.next();
                    Expression value = (Expression)entry.getValue();
                    if (value instanceof ExpressionExpression) {
                        new Exception("todo").printStackTrace();
                        continue;
                    }
                    PointcutDefinition cflowPointcutDef = aspectDef.getPointcutDef(value.getName());
                    CallPointcut pointcut = new CallPointcut(uuid, value);
                    if (!SystemLoader.getSystem(uuid).hasAspect("org$codehaus$aspectwerkz$attribdef$aspect$CFlowSystemAspect")) {
                        AspectDefinition cflowAspect = new AspectDefinition("org$codehaus$aspectwerkz$attribdef$aspect$CFlowSystemAspect", "org.codehaus.aspectwerkz.attribdef.aspect.CFlowSystemAspect", "perThread");
                        cflowAspect.addPointcut(cflowPointcutDef);
                        Class cflowAspectClass = class$org$codehaus$aspectwerkz$attribdef$aspect$CFlowSystemAspect == null ? StartupManager.class$("org.codehaus.aspectwerkz.attribdef.aspect.CFlowSystemAspect") : class$org$codehaus$aspectwerkz$attribdef$aspect$CFlowSystemAspect;
                        try {
                            cflowAspect.addBeforeAdvice(new AdviceDefinition("enterControlFlow", cflowAspect.getName(), cflowAspect.getClassName(), value, cflowAspectClass.getDeclaredMethod("enterControlFlow", class$org$codehaus$aspectwerkz$joinpoint$JoinPoint == null ? StartupManager.class$("org.codehaus.aspectwerkz.joinpoint.JoinPoint") : class$org$codehaus$aspectwerkz$joinpoint$JoinPoint), CFlowSystemAspect.PRE_ADVICE_INDEX, cflowAspect));
                            cflowAspect.addAfterAdvice(new AdviceDefinition("exitControlFlow", cflowAspect.getName(), cflowAspect.getClassName(), value, cflowAspectClass.getDeclaredMethod("exitControlFlow", class$org$codehaus$aspectwerkz$joinpoint$JoinPoint == null ? StartupManager.class$("org.codehaus.aspectwerkz.joinpoint.JoinPoint") : class$org$codehaus$aspectwerkz$joinpoint$JoinPoint), CFlowSystemAspect.POST_ADVICE_INDEX, cflowAspect));
                        }
                        catch (NoSuchMethodException e) {
                            // empty catch block
                        }
                        definition.addAspect(cflowAspect);
                        StartupManager.registerAspect(uuid, cflowAspect, new HashMap());
                    }
                    pointcut.addPointcutDef(cflowPointcutDef);
                    pointcut.addBeforeAdvice("enterControlFlow");
                    pointcut.addAfterAdvice("exitControlFlow");
                    aspect.addCallPointcut(pointcut);
                    aspect.addMethodToCflowExpressionMap(expression, value);
                }
            }
        }
    }

    private static void registerThrowsPointcuts(String uuid, AspectWerkzDefinitionImpl definition) {
        Iterator it = definition.getAspectDefinitions().iterator();
        while (it.hasNext()) {
            AspectDefinition aspectDef = (AspectDefinition)it.next();
            AspectMetaData aspectMetaData = SystemLoader.getSystem(uuid).getAspectMetaData(aspectDef.getName());
            List aroundAdvices = aspectDef.getAroundAdvices();
            Iterator it2 = aroundAdvices.iterator();
            while (it2.hasNext()) {
                AdviceDefinition adviceDef = (AdviceDefinition)it2.next();
                if (!adviceDef.getExpression().getType().equals(PointcutType.THROWS)) continue;
                ThrowsPointcut pointcut = aspectMetaData.getThrowsPointcut(adviceDef.getExpression().getExpression());
                if (pointcut == null) {
                    pointcut = new ThrowsPointcut(uuid, adviceDef.getExpression());
                    aspectMetaData.addThrowsPointcut(pointcut);
                }
                pointcut.addAdvice(adviceDef.getName());
            }
        }
    }

    private StartupManager() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

