/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition.attribute;

import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.Attribute;

public class AspectAttribute
implements Attribute {
    private static final long serialVersionUID = 5565371328658309916L;
    private final String m_name;
    private final String m_deploymentModel;

    public AspectAttribute(String name, String deploymentModel) {
        this.m_name = name;
        this.m_deploymentModel = deploymentModel == null || deploymentModel.equals("") ? "perJVM" : deploymentModel;
        this.verify();
    }

    public AspectAttribute(String name, int deploymentModel) {
        this.m_name = name;
        this.m_deploymentModel = DeploymentModel.getDeploymentModelAsString(deploymentModel);
        this.verify();
    }

    public String getName() {
        return this.m_name;
    }

    public String getDeploymentModel() {
        return this.m_deploymentModel;
    }

    private void verify() {
        if (!(this.m_deploymentModel.equalsIgnoreCase("perJVM") || this.m_deploymentModel.equalsIgnoreCase("perClass") || this.m_deploymentModel.equalsIgnoreCase("perInstance") || this.m_deploymentModel.equalsIgnoreCase("perThread"))) {
            throw new IllegalArgumentException("deployment model is not valid for aspect");
        }
    }
}

