/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition.attribute;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AttributeExtractor;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.bcel.BcelAttributeExtractor;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class Attributes {
    private static Map m_extractorCache = new HashMap();

    public static Object[] getAttributes(Class klass) {
        return Attributes.getAttrExtractor(klass).getClassAttributes();
    }

    public static Object[] getAttributes(Method method) {
        Class<?> superClass;
        Class<?> klass = method.getDeclaringClass();
        ArrayList<Object> attribList = new ArrayList<Object>();
        while (true) {
            Object[] returnAttribs;
            if ((returnAttribs = Attributes.searchForMethodAttribs(klass, method)).length > 0) {
                attribList.addAll(Arrays.asList(returnAttribs));
            }
            if ((superClass = klass.getSuperclass()) == null || superClass.getName().startsWith("java.")) break;
            klass = superClass;
        }
        while (true) {
            Class<?>[] interfaceClasses = klass.getInterfaces();
            for (int i = 0; i < interfaceClasses.length; ++i) {
                Object[] intAttribs = Attributes.searchForMethodAttribs(interfaceClasses[i], method);
                if (intAttribs.length <= 0) continue;
                attribList.addAll(Arrays.asList(intAttribs));
            }
            superClass = klass.getSuperclass();
            if (superClass == null || superClass.getName().startsWith("java.")) break;
            klass = superClass;
        }
        return attribList.toArray(new Object[attribList.size()]);
    }

    public static Object[] getAttributes(Field field) {
        return Attributes.getAttrExtractor(field.getDeclaringClass()).getFieldAttributes(field.getName());
    }

    private static Object[] searchForMethodAttribs(Class klass, Method method) {
        AttributeExtractor extractor = Attributes.getAttrExtractor(klass);
        if (extractor != null) {
            String[] paramTypes = new String[method.getParameterTypes().length];
            for (int i = 0; i < paramTypes.length; ++i) {
                String paramType = method.getParameterTypes()[i].getName();
                if (paramType.startsWith("[L")) {
                    paramType = paramType.substring(2, paramType.length() - 1) + "[]";
                }
                paramTypes[i] = paramType;
            }
            return extractor.getMethodAttributes(method.getName(), paramTypes);
        }
        return new Object[0];
    }

    private static synchronized AttributeExtractor getAttrExtractor(Class klass) {
        AttributeExtractor extractor = null;
        extractor = (AttributeExtractor)m_extractorCache.get(klass);
        if (extractor == null) {
            String className = klass.getName();
            try {
                ClassLoader loader = klass.getClassLoader();
                if (loader != null) {
                    extractor = new BcelAttributeExtractor();
                    extractor.initialize(className, klass.getClassLoader());
                    m_extractorCache.put(klass, extractor);
                } else {
                    extractor = new BcelAttributeExtractor();
                    extractor.initialize(className, ClassLoader.getSystemClassLoader());
                    m_extractorCache.put(klass, extractor);
                }
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return extractor;
    }
}

