/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition.attribute;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.attribdef.definition.AspectDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AfterAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AroundAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AspectAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AspectAttributeParser;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.Attribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.Attributes;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.BeforeAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.CFlowAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.CallAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ClassAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ExecutionAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.GetAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ImplementsAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.IntroduceAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.SetAttribute;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.ThrowsAttribute;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class DefaultAspectAttributeParser
extends AspectAttributeParser {
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect;

    public AspectDefinition parse(Class klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class to parse can not be null");
        }
        AspectAttribute aspectAttr = this.getAspectAttribute(klass);
        String className = klass.getName();
        String aspectName = aspectAttr.getName();
        if (aspectName == null) {
            aspectName = className;
        }
        AspectDefinition aspectDef = new AspectDefinition(aspectName, className, aspectAttr.getDeploymentModel());
        this.parseFieldAttributes(klass, aspectDef);
        this.parseMethodAttributes(klass, className, aspectName, aspectDef);
        this.parseClassAttributes(klass, aspectDef);
        return aspectDef;
    }

    private void parseFieldAttributes(Class klass, AspectDefinition aspectDef) {
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        if (klass == null) {
            return;
        }
        if (klass.getName().equals((class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect == null ? (class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect = DefaultAspectAttributeParser.class$("org.codehaus.aspectwerkz.attribdef.aspect.Aspect")) : class$org$codehaus$aspectwerkz$attribdef$aspect$Aspect).getName())) {
            return;
        }
        Field[] fieldList = klass.getDeclaredFields();
        block0: for (int i = 0; i < fieldList.length; ++i) {
            Field field = fieldList[i];
            Object[] fieldAttributes = Attributes.getAttributes(field);
            for (int j = 0; j < fieldAttributes.length; ++j) {
                Attribute attribute;
                Object fieldAttr = fieldAttributes[j];
                if (fieldAttr instanceof ExecutionAttribute) {
                    attribute = (ExecutionAttribute)fieldAttr;
                    this.createAndAddPointcutDefToAspectDef(field.getName(), PointcutType.EXECUTION, ((ExecutionAttribute)attribute).getExpression(), aspectDef);
                    continue block0;
                }
                if (fieldAttr instanceof CallAttribute) {
                    attribute = (CallAttribute)fieldAttr;
                    this.createAndAddPointcutDefToAspectDef(field.getName(), PointcutType.CALL, ((CallAttribute)attribute).getExpression(), aspectDef);
                    continue block0;
                }
                if (fieldAttr instanceof ClassAttribute) {
                    attribute = (ClassAttribute)fieldAttr;
                    this.createAndAddPointcutDefToAspectDef(field.getName(), PointcutType.CLASS, ((ClassAttribute)attribute).getExpression(), aspectDef);
                    continue block0;
                }
                if (fieldAttr instanceof SetAttribute) {
                    attribute = (SetAttribute)fieldAttr;
                    this.createAndAddPointcutDefToAspectDef(field.getName(), PointcutType.SET, ((SetAttribute)attribute).getExpression(), aspectDef);
                    continue block0;
                }
                if (fieldAttr instanceof GetAttribute) {
                    attribute = (GetAttribute)fieldAttr;
                    this.createAndAddPointcutDefToAspectDef(field.getName(), PointcutType.GET, ((GetAttribute)attribute).getExpression(), aspectDef);
                    continue block0;
                }
                if (fieldAttr instanceof ThrowsAttribute) {
                    attribute = (ThrowsAttribute)fieldAttr;
                    this.createAndAddPointcutDefToAspectDef(field.getName(), PointcutType.THROWS, ((ThrowsAttribute)attribute).getExpression(), aspectDef);
                    continue block0;
                }
                if (fieldAttr instanceof CFlowAttribute) {
                    attribute = (CFlowAttribute)fieldAttr;
                    this.createAndAddPointcutDefToAspectDef(field.getName(), PointcutType.CFLOW, ((CFlowAttribute)attribute).getExpression(), aspectDef);
                    this.createAndAddPointcutDefToAspectDef(field.getName() + "-System", PointcutType.CALL, ((CFlowAttribute)attribute).getExpression(), aspectDef);
                    continue block0;
                }
                if (!(fieldAttr instanceof ImplementsAttribute)) continue;
                attribute = (ImplementsAttribute)fieldAttr;
                this.createAndAddInterfaceIntroductionDefToAspectDef(((ImplementsAttribute)attribute).getExpression(), field.getName(), field.getType().getName(), aspectDef);
                continue block0;
            }
        }
        this.parseFieldAttributes(klass.getSuperclass(), aspectDef);
    }

    private void parseMethodAttributes(Class klass, String aspectClassName, String aspectName, AspectDefinition aspectDef) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (aspectClassName == null) {
            throw new IllegalArgumentException("aspect class name can not be null");
        }
        if (aspectName == null) {
            throw new IllegalArgumentException("aspect name can not be null");
        }
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        List methodList = TransformationUtil.createSortedMethodList(klass);
        int methodIndex = 0;
        Iterator it = methodList.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            String adviceName = aspectClassName + '.' + method.getName();
            Object[] methodAttributes = Attributes.getAttributes(method);
            for (int j = 0; j < methodAttributes.length; ++j) {
                String expression;
                String name;
                Object methodAttr = methodAttributes[j];
                if (methodAttr instanceof AroundAttribute) {
                    AroundAttribute aroundAttr = (AroundAttribute)methodAttr;
                    name = aroundAttr.getName();
                    if (name != null) {
                        adviceName = name;
                    }
                    expression = aroundAttr.getExpression();
                    this.createAndAddAroundAdviceDefToAspectDef(expression, adviceName, aspectName, aspectClassName, method, methodIndex, aspectDef);
                    continue;
                }
                if (methodAttr instanceof BeforeAttribute) {
                    BeforeAttribute beforeAttr = (BeforeAttribute)methodAttr;
                    name = beforeAttr.getName();
                    if (name != null) {
                        adviceName = name;
                    }
                    expression = beforeAttr.getExpression();
                    this.createAndAddBeforeAdviceDefToAspectDef(expression, adviceName, aspectName, aspectClassName, method, methodIndex, aspectDef);
                    continue;
                }
                if (!(methodAttr instanceof AfterAttribute)) continue;
                AfterAttribute afterAttr = (AfterAttribute)methodAttr;
                name = afterAttr.getName();
                expression = afterAttr.getExpression();
                if (name != null) {
                    adviceName = name;
                }
                this.createAndAddAfterAdviceDefToAspectDef(expression, adviceName, aspectName, aspectClassName, method, methodIndex, aspectDef);
            }
            ++methodIndex;
        }
    }

    private AspectAttribute getAspectAttribute(Class klass) {
        AspectAttribute aspectAttr = null;
        Object[] classAttributes = Attributes.getAttributes(klass);
        for (int i = 0; i < classAttributes.length; ++i) {
            Object classAttr = classAttributes[i];
            if (!(classAttr instanceof AspectAttribute)) continue;
            aspectAttr = (AspectAttribute)classAttr;
            break;
        }
        if (aspectAttr == null) {
            aspectAttr = new AspectAttribute(klass.getName(), 0);
        }
        return aspectAttr;
    }

    private void parseClassAttributes(Class klass, AspectDefinition aspectDef) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        Object[] classAttributes = Attributes.getAttributes(klass);
        for (int i = 0; i < classAttributes.length; ++i) {
            IntroduceAttribute introduceAttr = null;
            if (!(classAttributes[i] instanceof IntroduceAttribute)) continue;
            introduceAttr = (IntroduceAttribute)classAttributes[i];
            Class<?> mixin = null;
            try {
                mixin = klass.getClassLoader().loadClass(introduceAttr.getInnerClassName());
            }
            catch (ClassNotFoundException e) {
                throw new WrappedRuntimeException(e);
            }
            Method[] methods = TransformationUtil.createSortedMethodList(mixin).toArray(new Method[0]);
            this.createAndAddIntroductionDefToAspectDef(introduceAttr.getExpression(), introduceAttr.getInnerClassName(), introduceAttr.getIntroducedInterfaceNames(), methods, introduceAttr.getDeploymentModel(), aspectDef);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

