/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition.attribute;

import org.codehaus.aspectwerkz.attribdef.definition.attribute.Attribute;

public class IntroduceAttribute
implements Attribute {
    private static final long serialVersionUID = -146743510655018866L;
    private final String m_expression;
    private final String m_innerClassName;
    private final String[] m_introducedInterfaceNames;
    private final String m_deploymentModel;

    public IntroduceAttribute(String expression, String innerClassName, String[] interfaceNames, String deploymentModel) {
        if (expression == null) {
            throw new IllegalArgumentException("expression is not valid for introduction");
        }
        this.m_expression = expression;
        this.m_innerClassName = innerClassName;
        this.m_introducedInterfaceNames = interfaceNames;
        this.m_deploymentModel = deploymentModel == null || deploymentModel.equals("") ? null : deploymentModel;
        this.verify();
    }

    public String getExpression() {
        return this.m_expression;
    }

    public String getInnerClassName() {
        return this.m_innerClassName;
    }

    public String[] getIntroducedInterfaceNames() {
        return this.m_introducedInterfaceNames;
    }

    public String getDeploymentModel() {
        return this.m_deploymentModel;
    }

    private void verify() {
        if (!(this.m_deploymentModel == null || this.m_deploymentModel.equalsIgnoreCase("perJVM") || this.m_deploymentModel.equalsIgnoreCase("perClass") || this.m_deploymentModel.equalsIgnoreCase("perInstance") || this.m_deploymentModel.equalsIgnoreCase("perThread"))) {
            throw new IllegalArgumentException("deployment model is not valid for mixin");
        }
    }
}

