/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition.attribute.bcel;

import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.MethodGen;
import org.codehaus.aspectwerkz.attribdef.definition.DescriptorUtil;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AttributeEnhancer;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.metadata.TypeConverter;

public class BcelAttributeEnhancer
implements AttributeEnhancer {
    private JavaClass m_javaClass = null;
    private ClassGen m_classGen = null;
    private ConstantPoolGen m_constantPoolGen = null;
    private URLClassLoader m_loader = null;

    public boolean initialize(String className, String classPath) {
        try {
            URL[] urls = new URL[]{new File(classPath).toURL()};
            this.m_loader = new URLClassLoader(urls);
            String classFileName = className.replace('.', '/') + ".class";
            InputStream classAsStream = this.m_loader.getResourceAsStream(classFileName);
            if (classAsStream == null) {
                return false;
            }
            ClassParser classParser = new ClassParser(classAsStream, className);
            this.m_javaClass = classParser.parse();
            this.m_constantPoolGen = new ConstantPoolGen(this.m_javaClass.getConstantPool());
            this.m_classGen = new ClassGen(this.m_javaClass);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return true;
    }

    public void insertClassAttribute(Object attribute) {
        if (this.m_classGen == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        byte[] serializedAttribute = BcelAttributeEnhancer.serialize(attribute);
        Unknown attr = new Unknown(this.m_constantPoolGen.addUtf8("Custom"), serializedAttribute.length, serializedAttribute, this.m_constantPoolGen.getConstantPool());
        this.m_classGen.addAttribute((Attribute)attr);
    }

    public void insertFieldAttribute(JavaField field, Object attribute) {
        if (this.m_classGen == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        byte[] serializedAttribute = BcelAttributeEnhancer.serialize(attribute);
        Field[] classfileField = this.m_classGen.getFields();
        for (int i = 0; i < classfileField.length; ++i) {
            if (!classfileField[i].getName().equals(field.getName())) continue;
            FieldGen fieldGen = new FieldGen(classfileField[i], this.m_constantPoolGen);
            Unknown attr = new Unknown(this.m_constantPoolGen.addUtf8("Custom"), serializedAttribute.length, serializedAttribute, this.m_constantPoolGen.getConstantPool());
            fieldGen.addAttribute((Attribute)attr);
            Field newField = fieldGen.getField();
            this.m_classGen.replaceField(classfileField[i], newField);
        }
    }

    public void insertMethodAttribute(JavaMethod method, Object attribute) {
        if (this.m_classGen == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        byte[] serializedAttribute = BcelAttributeEnhancer.serialize(attribute);
        Object[] methodParamTypes = new String[method.getParameters().length];
        for (int i = 0; i < methodParamTypes.length; ++i) {
            methodParamTypes[i] = TypeConverter.convertTypeToJava(method.getParameters()[i].getType());
        }
        Method[] classfileMethod = this.m_classGen.getMethods();
        for (int i = 0; i < classfileMethod.length; ++i) {
            if (!classfileMethod[i].getName().equals(method.getName()) || !Arrays.equals(methodParamTypes, DescriptorUtil.convertToJavaFormat(classfileMethod[i].getSignature()))) continue;
            MethodGen methodGen = new MethodGen(classfileMethod[i], this.m_javaClass.getClassName(), this.m_constantPoolGen);
            Unknown attr = new Unknown(this.m_constantPoolGen.addUtf8("Custom"), serializedAttribute.length, serializedAttribute, this.m_constantPoolGen.getConstantPool());
            methodGen.addAttribute((Attribute)attr);
            Method newMethod = methodGen.getMethod();
            this.m_classGen.replaceMethod(classfileMethod[i], newMethod);
        }
    }

    public void write(String destDir) {
        try {
            boolean success;
            this.m_classGen.setConstantPool(this.m_constantPoolGen);
            JavaClass klass = this.m_classGen.getJavaClass();
            String path = destDir + "/" + klass.getClassName().replace('.', '/') + ".class";
            File file = new File(path);
            File parentFile = file.getParentFile();
            boolean exists = parentFile.exists();
            if (!exists && !(success = parentFile.mkdirs())) {
                throw new RuntimeException("could not create dir structure needed to write file " + path + " to disk");
            }
            FileOutputStream fout = new FileOutputStream(path);
            DataOutputStream out = new DataOutputStream(fout);
            klass.dump(out);
            fout.close();
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static byte[] serialize(Object attribute) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(attribute);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public String[] getNearestInterfacesInHierarchy(String innerClassName) {
        if (this.m_loader == null) {
            throw new IllegalStateException("attribute enhancer is not initialized");
        }
        try {
            Class<?> innerClass = Class.forName(innerClassName, false, this.m_loader);
            return this.getNearestInterfacesInHierarchy(innerClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load mixin for mixin implicit interface: ClassNotFoundException : " + e.getMessage());
        }
        catch (NoClassDefFoundError er) {
            throw new RuntimeException("could not find dependency for mixin implicit interface: " + innerClassName + " ClassNotFoundException for " + er.getMessage());
        }
    }

    private String[] getNearestInterfacesInHierarchy(Class root) {
        if (root == null) {
            return new String[0];
        }
        Class<?>[] implementedClasses = root.getInterfaces();
        String[] interfaces = null;
        if (implementedClasses.length == 0) {
            interfaces = this.getNearestInterfacesInHierarchy(root.getSuperclass());
        } else {
            interfaces = new String[implementedClasses.length];
            for (int i = 0; i < implementedClasses.length; ++i) {
                interfaces[i] = implementedClasses[i].getName();
            }
        }
        return interfaces;
    }
}

