/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.definition.attribute.bcel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Unknown;
import org.codehaus.aspectwerkz.attribdef.definition.DescriptorUtil;
import org.codehaus.aspectwerkz.attribdef.definition.attribute.AttributeExtractor;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class BcelAttributeExtractor
implements AttributeExtractor {
    private JavaClass m_javaClass;

    public void initialize(String className, ClassLoader loader) {
        String classFileName = className.replace('.', '/') + ".class";
        try {
            InputStream classStream = loader.getResourceAsStream(classFileName);
            ClassParser classParser = new ClassParser(classStream, classFileName);
            this.m_javaClass = classParser.parse();
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public Object[] getClassAttributes() {
        ArrayList<Object> attributes = new ArrayList<Object>();
        Attribute[] classAttributes = this.m_javaClass.getAttributes();
        for (int i = 0; i < classAttributes.length; ++i) {
            if (!(classAttributes[i] instanceof Unknown)) continue;
            Unknown unknownAttrib = (Unknown)classAttributes[i];
            byte[] serializedAttribute = unknownAttrib.getBytes();
            try {
                Object attribute = new ObjectInputStream(new ByteArrayInputStream(serializedAttribute)).readObject();
                attributes.add(attribute);
                continue;
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        return attributes.toArray(new Object[attributes.size()]);
    }

    public Object[] getMethodAttributes(String methodName, String[] methodParamTypes) {
        ArrayList<Object> attributes = new ArrayList<Object>();
        Method[] methods = this.m_javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || !Arrays.equals(methodParamTypes, DescriptorUtil.convertToJavaFormat(methods[i].getSignature()))) continue;
            Attribute[] methodAttributes = methods[i].getAttributes();
            for (int j = 0; j < methodAttributes.length; ++j) {
                if (!(methodAttributes[j] instanceof Unknown)) continue;
                Unknown unknownAttrib = (Unknown)methodAttributes[j];
                byte[] serializedAttribute = unknownAttrib.getBytes();
                try {
                    Object attribute = new ObjectInputStream(new ByteArrayInputStream(serializedAttribute)).readObject();
                    attributes.add(attribute);
                    continue;
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return attributes.toArray(new Object[attributes.size()]);
    }

    public Object[] getFieldAttributes(String fieldName) {
        ArrayList<Object> al = new ArrayList<Object>();
        Field[] fields = this.m_javaClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(fieldName)) continue;
            Attribute[] fieldAttributes = fields[i].getAttributes();
            for (int j = 0; j < fieldAttributes.length; ++j) {
                if (!(fieldAttributes[j] instanceof Unknown)) continue;
                Unknown unknownAttrib = (Unknown)fieldAttributes[j];
                byte[] serializedAttribute = unknownAttrib.getBytes();
                try {
                    Object attribute = new ObjectInputStream(new ByteArrayInputStream(serializedAttribute)).readObject();
                    al.add(attribute);
                    continue;
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
            }
        }
        return al.toArray(new Object[al.size()]);
    }
}

