/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.attribdef.transform;

import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.codehaus.aspectwerkz.attribdef.definition.AspectWerkzDefinitionImpl;
import org.codehaus.aspectwerkz.attribdef.definition.InterfaceIntroductionDefinition;
import org.codehaus.aspectwerkz.attribdef.definition.IntroductionDefinition;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.transform.AddImplementationTransformer;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationUtil;

public class IntroductionTransformer {
    public static void addInterfaceIntroductions(AspectWerkzDefinition definition, ClassGen cg, ConstantPoolGen cpg, Context context, ClassMetaData classMetaData) {
        AspectWerkzDefinitionImpl def = (AspectWerkzDefinitionImpl)definition;
        int[] interfaces = cg.getInterfaces();
        boolean isClassAdvised = false;
        List introDefs = def.getInterfaceIntroductions(classMetaData);
        Iterator it = introDefs.iterator();
        while (it.hasNext()) {
            InterfaceIntroductionDefinition introductionDef = (InterfaceIntroductionDefinition)it.next();
            Iterator iit = introductionDef.getInterfaceClassNames().iterator();
            while (iit.hasNext()) {
                String className = (String)iit.next();
                boolean addInterface = true;
                for (int l = 0; l < interfaces.length; ++l) {
                    ConstantClass cc = (ConstantClass)cpg.getConstant(interfaces[l]);
                    ConstantUtf8 cu = (ConstantUtf8)cpg.getConstant(cc.getNameIndex());
                    if (!IntroductionTransformer.implementsInterface(cu, className)) continue;
                    addInterface = false;
                    break;
                }
                if (!addInterface || className == null) continue;
                TransformationUtil.addInterfaceToClass(cg, className);
                isClassAdvised = true;
            }
        }
        if (isClassAdvised) {
            context.markAsAdvised();
        }
    }

    public static void addMethodIntroductions(AspectWerkzDefinition definition, Context context, ClassMetaData classMetaData, ClassGen cg, ConstantPoolGen cpg, InstructionFactory factory, AddImplementationTransformer transformer) {
        AspectWerkzDefinitionImpl def = (AspectWerkzDefinitionImpl)definition;
        List introductionDefs = def.getIntroductionDefinitions(classMetaData);
        boolean isClassAdvised = false;
        Iterator it = introductionDefs.iterator();
        while (it.hasNext()) {
            IntroductionDefinition introDef = (IntroductionDefinition)it.next();
            int methodIndex = 0;
            Iterator mit = introDef.getMethodIntroductions().iterator();
            while (mit.hasNext()) {
                int mixinIndex = def.getMixinIndexByName(introDef.getName());
                isClassAdvised = true;
                transformer.createProxyMethod(cg, cpg, factory, (MethodMetaData)mit.next(), mixinIndex, methodIndex, def.getUuid());
                ++methodIndex;
            }
        }
        if (isClassAdvised) {
            context.markAsAdvised();
        }
    }

    private static boolean implementsInterface(ConstantUtf8 cu, String interfaceName) {
        return cu.getBytes().equals(interfaceName.replace('.', '/'));
    }
}

