/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.codehaus.aspectwerkz.compiler.CompileException;
import org.codehaus.aspectwerkz.compiler.Utility;
import org.codehaus.aspectwerkz.compiler.VerifierClassLoader;
import org.codehaus.aspectwerkz.hook.ClassPreProcessor;

public class AspectWerkzC {
    private static String PRE_PROCESSOR_CLASSNAME_PROPERTY = "aspectwerkz.classloader.preprocessor";
    private static String PRE_PROCESSOR_CLASSNAME_DEFAULT = "org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor";
    private static final String MF_CUSTOM_DATE = "X-AspectWerkzC-created";
    private static final String MF_CUSTOM_PP = "X-AspectWerkzC-preprocessor";
    private static final String MF_CUSTOM_COMMENT = "X-AspectWerkzC-comment";
    private static final String MF_CUSTOM_COMMENT_VALUE = "AspectWerkzC - AspectWerkz compiler, aspectwerkz.codehaus.org";
    private static final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String BACKUP_DIR = "_aspectwerkzc";
    private boolean verbose = false;
    private boolean verify = false;
    private boolean haltOnError = false;
    private URLClassLoader compilationLoader = null;
    private ClassPreProcessor preprocessor = null;
    private int sourceIndex = 0;
    private Map backupMap = new HashMap();
    private Map successMap = new HashMap();
    private long timer;
    private Utility utility = new Utility();

    public AspectWerkzC() {
        this.timer = System.currentTimeMillis();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.utility.setVerbose();
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public Utility getUtility() {
        return this.utility;
    }

    public void setPreprocessor(String preprocessor) throws CompileException {
        try {
            Class<?> pp = Class.forName(preprocessor);
            this.preprocessor = (ClassPreProcessor)pp.newInstance();
            this.preprocessor.initialize(new Hashtable());
        }
        catch (Exception e) {
            throw new CompileException("failed to instantiate preprocessor " + preprocessor, e);
        }
    }

    public void backup(File source, int index) {
        File dest = new File(BACKUP_DIR + File.separator + index + File.separator + source.getName());
        this.utility.backupFile(source, dest);
        this.backupMap.put(source, dest);
    }

    public void restoreBackup() {
        Iterator i = this.backupMap.keySet().iterator();
        while (i.hasNext()) {
            File source = (File)i.next();
            if (this.successMap.containsKey(source)) continue;
            File dest = (File)this.backupMap.get(source);
            this.utility.backupFile(dest, source);
        }
    }

    public void postCompile(String message) {
        this.restoreBackup();
        this.utility.log("   [backup] removing backup");
        this.utility.deleteDir(new File(BACKUP_DIR));
        long ms = Math.max(System.currentTimeMillis() - this.timer, 1000L);
        System.out.println("( " + (int)(ms / 1000L) + " s ) " + message);
        if (!this.haltOnError) {
            Iterator i = this.backupMap.keySet().iterator();
            while (i.hasNext()) {
                File source = (File)i.next();
                if (this.successMap.containsKey(source)) {
                    System.out.println("SUCCESS: " + source);
                    continue;
                }
                System.out.println("FAILED : " + source);
            }
        }
    }

    public void doCompile(File sourceFile, String prefixPackage) throws CompileException {
        if (sourceFile.isDirectory()) {
            File[] classes = sourceFile.listFiles();
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i].isDirectory() && !BACKUP_DIR.equals(classes[i].getName())) {
                    String packaging = prefixPackage != null ? prefixPackage + "." + classes[i].getName() : classes[i].getName();
                    this.doCompile(classes[i], packaging);
                    continue;
                }
                if (classes[i].getName().toLowerCase().endsWith(".class")) {
                    this.compileClass(classes[i], prefixPackage);
                    continue;
                }
                if (!AspectWerkzC.isJarFile(classes[i])) continue;
                this.compileJar(classes[i]);
            }
        } else if (sourceFile.getName().toLowerCase().endsWith(".class")) {
            this.compileClass(sourceFile, null);
        } else if (AspectWerkzC.isJarFile(sourceFile)) {
            this.compileJar(sourceFile);
        }
    }

    public void compileClass(File file, String packaging) throws CompileException {
        block19: {
            InputStream in = null;
            FileOutputStream fos = null;
            try {
                int length;
                this.utility.log("   [compile] " + file.getCanonicalPath());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                in = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    bos.write(buffer, 0, length);
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                if (packaging != null) {
                    className = packaging + "." + className;
                }
                byte[] transformed = null;
                try {
                    transformed = this.preprocessor.preProcess(className, bos.toByteArray(), (ClassLoader)this.compilationLoader);
                }
                catch (Throwable t) {
                    throw new CompileException("weaver failed for class: " + className, t);
                }
                fos = new FileOutputStream(file);
                fos.write(transformed);
                fos.close();
                if (!this.verify) break block19;
                VerifierClassLoader verifier = new VerifierClassLoader(this.compilationLoader.getURLs(), ClassLoader.getSystemClassLoader());
                try {
                    this.utility.log("   [verify] " + className);
                    Class.forName(className, false, verifier);
                }
                catch (Throwable t) {
                    this.utility.log("   [verify] corrupted class: " + className);
                    throw new CompileException("corrupted class: " + className, t);
                }
            }
            catch (IOException e) {
                throw new CompileException("compile " + file.getAbsolutePath() + " failed", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable e) {}
                try {
                    fos.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public void compileJar(File file) throws CompileException {
        this.utility.log("   [compilejar] " + file.getAbsolutePath());
        File workingFile = new File(file.getAbsolutePath() + ".aspectwerkzc");
        if (workingFile.exists()) {
            workingFile.delete();
        }
        ZipFile zip = null;
        ZipOutputStream zos = null;
        try {
            zip = new ZipFile(file);
            zos = new ZipOutputStream(new FileOutputStream(workingFile));
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                int length;
                ZipEntry ze = e.nextElement();
                InputStream in = zip.getInputStream(ze);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    bos.write(buffer, 0, length);
                }
                in.close();
                byte[] transformed = null;
                if (ze.getName().toLowerCase().endsWith(".class")) {
                    this.utility.log("   [compilejar] compile " + file.getName() + ":" + ze.getName());
                    String className = ze.getName().substring(0, ze.getName().length() - 6);
                    try {
                        transformed = this.preprocessor.preProcess(className, bos.toByteArray(), (ClassLoader)this.compilationLoader);
                    }
                    catch (Throwable t) {
                        throw new CompileException("weaver failed for class: " + className, t);
                    }
                } else {
                    transformed = bos.toByteArray();
                }
                if (ze.getName().toLowerCase().equals("meta-inf/manifest.mf")) {
                    try {
                        Manifest mf = new Manifest(new ByteArrayInputStream(transformed));
                        Attributes at = mf.getMainAttributes();
                        at.putValue(MF_CUSTOM_DATE, DF.format(new Date()));
                        at.putValue(MF_CUSTOM_PP, this.preprocessor.getClass().getName());
                        at.putValue(MF_CUSTOM_COMMENT, MF_CUSTOM_COMMENT_VALUE);
                        bos.reset();
                        mf.write(bos);
                        transformed = bos.toByteArray();
                    }
                    catch (Exception emf) {
                        emf.printStackTrace();
                    }
                }
                ZipEntry transformedZe = new ZipEntry(ze.getName());
                transformedZe.setSize(transformed.length);
                CRC32 crc = new CRC32();
                crc.update(transformed);
                transformedZe.setCrc(crc.getValue());
                transformedZe.setMethod(ze.getMethod());
                zos.putNextEntry(transformedZe);
                zos.write(transformed, 0, transformed.length);
            }
            zip.close();
            zos.close();
            File swap = new File(file.getAbsolutePath() + ".swap.aspectwerkzc");
            this.utility.backupFile(file, swap);
            try {
                this.utility.backupFile(workingFile, new File(file.getAbsolutePath()));
                workingFile.delete();
                swap.delete();
            }
            catch (Exception e2) {
                this.utility.backupFile(swap, new File(file.getAbsolutePath()));
                workingFile.delete();
                throw new CompileException("compile " + file.getAbsolutePath() + " failed", e2);
            }
        }
        catch (IOException e) {
            throw new CompileException("compile " + file.getAbsolutePath() + " failed", e);
        }
        finally {
            try {
                zos.close();
            }
            catch (Throwable e) {}
            try {
                zip.close();
            }
            catch (Throwable e) {}
        }
    }

    public boolean compile(File source) {
        ++this.sourceIndex;
        this.backup(source, this.sourceIndex);
        try {
            this.doCompile(source, null);
        }
        catch (CompileException e) {
            this.utility.log("   [aspectwerkzc] compilation encountered an error");
            e.printStackTrace();
            return !this.haltOnError;
        }
        this.successMap.put(source, Boolean.TRUE);
        return true;
    }

    public void setCompilationPath(File[] targets) {
        URL[] urls = new URL[targets.length];
        int j = 0;
        for (int i = 0; i < targets.length; ++i) {
            try {
                urls[j] = targets[i].getCanonicalFile().toURL();
                ++j;
                continue;
            }
            catch (IOException e) {
                System.err.println("bad target " + targets[i]);
            }
        }
        this.compilationLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    public static boolean isJarFile(File source) {
        return source.isFile() && (source.getName().toLowerCase().endsWith(".jar") || source.getName().toLowerCase().endsWith(".zip"));
    }

    public static void doHelp() {
        System.out.println("--- AspectWerkzC compiler ---");
        System.out.println("Usage:");
        System.out.println("java -cp ... org.codehaus.aspectwerkz.compiler.AspectWerkzC [-verbose] [-haltOnError] [-verify] <ClassPreProcessorImpl> <target 1> .. <target n>");
        System.out.println("  <ClassPreProcessorImpl> : full qualified name of the ClassPreProcessor implementation (must be in classpath)");
        System.out.println("  <target i> : exploded dir, jar, zip files to compile");
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            AspectWerkzC.doHelp();
        }
        AspectWerkzC compiler = new AspectWerkzC();
        try {
            File temp = new File(BACKUP_DIR);
            if (temp.exists()) {
                compiler.getUtility().deleteDir(temp);
            }
            temp.mkdir();
            new File(temp, "" + System.currentTimeMillis() + ".timestamp").createNewFile();
        }
        catch (Exception e) {
            System.err.println("failed to prepare backup dir: _aspectwerkzc");
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            compiler.setPreprocessor(System.getProperty(PRE_PROCESSOR_CLASSNAME_PROPERTY, PRE_PROCESSOR_CLASSNAME_DEFAULT));
        }
        catch (CompileException e) {
            System.err.println("Cannot instantiate ClassPreProcessor: " + System.getProperty(PRE_PROCESSOR_CLASSNAME_PROPERTY, PRE_PROCESSOR_CLASSNAME_DEFAULT));
            e.printStackTrace();
            System.exit(-1);
        }
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> paths = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if ("-verbose".equals(args[i])) {
                compiler.setVerbose(true);
                continue;
            }
            if ("-haltOnError".equals(args[i])) {
                compiler.setHaltOnError(true);
                continue;
            }
            if ("-verify".equals(args[i])) {
                compiler.setVerify(true);
                continue;
            }
            if ("-cp".equals(args[i])) {
                if (i == args.length - 1) {
                    // empty if block
                }
                StringTokenizer pathSeparator = new StringTokenizer(args[++i], System.getProperty("os.name", "").toLowerCase().indexOf("windows") >= 0 ? ";" : ":");
                while (pathSeparator.hasMoreTokens()) {
                    File path = new File(pathSeparator.nextToken());
                    paths.add(path);
                }
                continue;
            }
            if (args[i].startsWith("-")) continue;
            File file = new File(args[i]);
            if (file.exists()) {
                files.add(file);
                continue;
            }
            System.err.println("Ignoring inexistant target: " + args[i]);
        }
        paths.addAll(files);
        compiler.setCompilationPath(paths.toArray(new File[0]));
        Iterator i = files.iterator();
        while (i.hasNext()) {
            if (compiler.compile((File)i.next())) continue;
            compiler.postCompile("*** An error occured ***");
            System.exit(-1);
        }
        compiler.postCompile("");
        System.exit(0);
    }
}

