/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.connectivity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.util.UuidGenerator;

public class RemoteProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static transient Map s_instances = new WeakHashMap();
    private final String m_address;
    private final int m_port;
    private String m_handle = null;
    private Class[] m_targetInterfaces = null;
    private String[] m_targetInterfaceNames = null;
    private String m_targetImplName = null;
    private transient Socket m_socket;
    private transient ObjectInputStream m_in;
    private transient ObjectOutputStream m_out;
    private transient ClassLoader m_loader;
    private transient Object m_context = null;
    private transient Object m_proxy = null;

    public static RemoteProxy createClientProxy(String[] interfaces, String impl, String address, int port) {
        return RemoteProxy.createClientProxy(interfaces, impl, address, port, Thread.currentThread().getContextClassLoader());
    }

    public static RemoteProxy createClientProxy(String[] interfaces, String impl, String address, int port, Object context) {
        return RemoteProxy.createClientProxy(interfaces, impl, address, port, context, Thread.currentThread().getContextClassLoader());
    }

    public static RemoteProxy createClientProxy(String[] interfaces, String impl, String address, int port, ClassLoader loader) {
        return RemoteProxy.createClientProxy(interfaces, impl, address, port, null, loader);
    }

    public static RemoteProxy createClientProxy(String[] interfaces, String impl, String address, int port, Object context, ClassLoader loader) {
        return new RemoteProxy(interfaces, impl, address, port, context, loader);
    }

    public static RemoteProxy createServerProxy(Object targetlInstance, String address, int port) {
        return new RemoteProxy(targetlInstance, address, port);
    }

    public Object getInstance(ClassLoader loader) {
        this.m_loader = loader;
        return this.getInstance();
    }

    public Object getInstance() {
        if (this.m_proxy != null) {
            return this.m_proxy;
        }
        if (this.m_loader == null) {
            this.m_loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            this.m_socket = new Socket(InetAddress.getByName(this.m_address), this.m_port);
            this.m_socket.setTcpNoDelay(true);
            this.m_out = new ObjectOutputStream(this.m_socket.getOutputStream());
            this.m_in = new ObjectInputStream(this.m_socket.getInputStream());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        if (this.m_handle == null) {
            if (this.m_targetInterfaceNames == null) {
                throw new IllegalStateException("interface class name can not be null");
            }
            if (this.m_targetImplName == null) {
                throw new IllegalStateException("implementation class name can not be null");
            }
            try {
                this.m_out.write(0);
                this.m_out.writeObject(this.m_targetImplName);
                this.m_out.flush();
                this.m_handle = (String)this.m_in.readObject();
                this.m_targetInterfaces = new Class[this.m_targetInterfaceNames.length];
                for (int i = 0; i < this.m_targetInterfaceNames.length; ++i) {
                    try {
                        this.m_targetInterfaces[i] = this.m_loader.loadClass(this.m_targetInterfaceNames[i]);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new WrappedRuntimeException(e);
                    }
                }
            }
            catch (Exception e) {
                throw new WrappedRuntimeException(e);
            }
        }
        this.m_proxy = Proxy.newProxyInstance(this.m_loader, this.m_targetInterfaces, (InvocationHandler)this);
        return this.m_proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        try {
            this.m_out.write(1);
            this.m_out.writeObject(this.m_context);
            this.m_out.writeObject(this.m_handle);
            this.m_out.writeObject(method.getName());
            this.m_out.writeObject(method.getParameterTypes());
            this.m_out.writeObject(args);
            this.m_out.flush();
            Object response = this.m_in.readObject();
            if (response instanceof Exception) {
                throw (Exception)response;
            }
            return response;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public void close() {
        try {
            this.m_out.write(2);
            this.m_out.flush();
            this.m_out.close();
            this.m_in.close();
            this.m_socket.close();
        }
        catch (IOException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static Object getWrappedInstance(String handle) {
        return s_instances.get(handle);
    }

    public static String wrapInstance(Object instance) {
        String handle = UuidGenerator.generate(instance);
        s_instances.put(handle, instance);
        return handle;
    }

    private RemoteProxy(String[] interfaces, String impl, String address, int port, Object context, ClassLoader loader) {
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException("at least one interface must be specified");
        }
        if (impl == null) {
            throw new IllegalArgumentException("implementation class name can not be null");
        }
        if (address == null) {
            throw new IllegalArgumentException("address can not be null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("port not valid");
        }
        this.m_targetInterfaceNames = interfaces;
        this.m_targetImplName = impl;
        this.m_address = address;
        this.m_port = port;
        this.m_context = context;
        this.m_loader = loader;
    }

    private RemoteProxy(Object targetInstance, String address, int port) {
        if (targetInstance == null) {
            throw new IllegalArgumentException("target instance can not be null");
        }
        if (address == null) {
            throw new IllegalArgumentException("address can not be null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("port not valid");
        }
        this.m_targetInterfaces = targetInstance.getClass().getInterfaces();
        this.m_address = address;
        this.m_port = port;
        this.m_handle = RemoteProxy.wrapInstance(targetInstance);
    }
}

