/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.ContextClassLoader;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.codehaus.aspectwerkz.definition.XmlParser;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.dom4j.Document;

public class DefinitionLoader {
    public static final String DEFAULT_SYSTEM = "default";
    public static final String DEFINITION_FILE = System.getProperty("aspectwerkz.definition.file", null);
    public static final String DEFAULT_DEFINITION_FILE_NAME = "aspectwerkz.xml";
    private static Map s_definitions = new HashMap();

    public static List createDefinition(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("definition document can not be null");
        }
        List definitions = DefinitionLoader.loadDefinitionsFromDocument(document);
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            s_definitions.put(definition.getUuid(), definition);
        }
        return definitions;
    }

    public static List getDefinitionsForTransformation() {
        List definitions = DEFINITION_FILE == null ? DefinitionLoader.loadDefinitionsAsResource() : DefinitionLoader.loadDefinitionsFromFile(false);
        return definitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AspectWerkzDefinition getDefinition(String uuid) {
        if (s_definitions.containsKey(uuid)) {
            return (AspectWerkzDefinition)s_definitions.get(uuid);
        }
        boolean isDirty = false;
        List definitions = DEFINITION_FILE == null ? DefinitionLoader.loadDefinitionsAsResource() : DefinitionLoader.loadDefinitionsFromFile(false);
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            AspectWerkzDefinition definition = (AspectWerkzDefinition)it.next();
            if (s_definitions.containsKey(uuid)) continue;
            Map map = s_definitions;
            synchronized (map) {
                s_definitions.put(uuid, definition);
            }
        }
        AspectWerkzDefinition defToReturn = (AspectWerkzDefinition)s_definitions.get(uuid);
        if (defToReturn == null) {
            throw new RuntimeException("could not find definition with id [" + uuid + "]");
        }
        return defToReturn;
    }

    private static List loadDefinitionsFromFile(boolean useCache) {
        return DefinitionLoader.loadDefaultDefinitionsFromFile(useCache);
    }

    public static List loadDefinitionsAsResource() {
        InputStream stream = DefinitionLoader.getDefinitionInputStream();
        if (stream == null) {
            throw new RuntimeException("either you have to specify an XML definition file using the -Daspectwerkz.definition.file=... option or you have to have the XML definition file <aspectwerkz.xml> somewhere on the classpath");
        }
        return DefinitionLoader.loadDefinitionsFromStream(stream);
    }

    public static List loadDefaultDefinitionsFromFile(boolean isDirty) {
        String definitionFileName;
        if (DEFINITION_FILE == null) {
            URL definition = ContextClassLoader.loadResource(DEFAULT_DEFINITION_FILE_NAME);
            if (definition == null) {
                throw new DefinitionException("definition file could not be found on classpath (either specify the file by using the -Daspectwerkz.definition.file=.. option or by having a definition file called aspectwerkz.xml somewhere on the classpath)");
            }
            definitionFileName = definition.getFile();
        } else {
            definitionFileName = DEFINITION_FILE;
        }
        return DefinitionLoader.loadDefinitionsFromFile(definitionFileName, isDirty);
    }

    public static List loadDefinitionsFromFile(String definitionFile) {
        return DefinitionLoader.loadDefinitionsFromFile(definitionFile, false);
    }

    public static InputStream getDefinitionInputStream() {
        return ContextClassLoader.getResourceAsStream(DEFAULT_DEFINITION_FILE_NAME);
    }

    public static List loadDefinitionsFromFile(String definitionFile, boolean isDirty) {
        return XmlParser.parse(new File(definitionFile), isDirty);
    }

    public static List loadDefinitionsFromStream(InputStream stream) {
        return XmlParser.parse(stream);
    }

    public static List loadDefinitionsFromDocument(Document document) {
        return XmlParser.parse(document);
    }

    public static AspectWerkzDefinition loadAndMergeDefinitions(ClassLoader loader) {
        AspectWerkzDefinition definition = null;
        return definition;
    }
}

