/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.definition.AspectWerkzDefinition;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class DocumentParser {
    public static List parse(Document document) {
        Element root = document.getRootElement();
        return DocumentParser.parseSystemElements(root);
    }

    public static void parseIncludePackageElements(Element root, AspectWerkzDefinition definition, String packageName) {
        Iterator it1 = root.elementIterator("include");
        while (it1.hasNext()) {
            String includePackage = "";
            Element includeElement = (Element)it1.next();
            Iterator it2 = includeElement.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                if (!attribute.getName().trim().equals("package")) continue;
                if (packageName.endsWith(".*")) {
                    includePackage = packageName.substring(0, packageName.length() - 2);
                } else if (packageName.endsWith(".")) {
                    includePackage = packageName.substring(0, packageName.length() - 1);
                }
                includePackage = packageName + attribute.getValue().trim();
                if (includePackage.endsWith(".*")) {
                    includePackage = includePackage.substring(0, includePackage.length() - 2);
                    break;
                }
                if (!includePackage.endsWith(".")) break;
                includePackage = includePackage.substring(0, includePackage.length() - 1);
                break;
            }
            if (includePackage.length() == 0) continue;
            definition.addIncludePackage(includePackage);
        }
    }

    public static void parseExcludePackageElements(Element root, AspectWerkzDefinition definition, String packageName) {
        Iterator it1 = root.elementIterator("exclude");
        while (it1.hasNext()) {
            String excludePackage = "";
            Element excludeElement = (Element)it1.next();
            Iterator it2 = excludeElement.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                if (!attribute.getName().trim().equals("package")) continue;
                if (packageName.endsWith(".*")) {
                    excludePackage = packageName.substring(0, packageName.length() - 2);
                } else if (packageName.endsWith(".")) {
                    excludePackage = packageName.substring(0, packageName.length() - 1);
                }
                excludePackage = packageName + attribute.getValue().trim();
                if (excludePackage.endsWith(".*")) {
                    excludePackage = excludePackage.substring(0, excludePackage.length() - 2);
                    break;
                }
                if (!excludePackage.endsWith(".")) break;
                excludePackage = excludePackage.substring(0, excludePackage.length() - 1);
                break;
            }
            if (excludePackage.length() == 0) continue;
            definition.addExcludePackage(excludePackage);
        }
    }

    private static List parseSystemElements(Element root) {
        AspectWerkzDefinition definition;
        Element system;
        ArrayList<AspectWerkzDefinition> systemDefs = new ArrayList<AspectWerkzDefinition>();
        Iterator it1 = root.elementIterator("system");
        while (it1.hasNext()) {
            system = (Element)it1.next();
            definition = org.codehaus.aspectwerkz.xmldef.definition.DocumentParser.parseSystemElement(system, DocumentParser.getBasePackage(system));
            if (definition == null) continue;
            systemDefs.add(definition);
        }
        it1 = root.elementIterator("system");
        while (it1.hasNext()) {
            system = (Element)it1.next();
            definition = org.codehaus.aspectwerkz.attribdef.definition.DocumentParser.parseSystemElement(system, DocumentParser.getBasePackage(system));
            if (definition == null) continue;
            systemDefs.add(definition);
        }
        if (systemDefs.size() == 0) {
            System.err.println("[AspectWerkz:WARN] using old XML style - please update");
            String uuid = root.attributeValue("id");
            AspectWerkzDefinition definition2 = org.codehaus.aspectwerkz.xmldef.definition.DocumentParser.parseElements(root, DocumentParser.getBasePackage(root), uuid);
            if (definition2 != null) {
                systemDefs.add(definition2);
            }
        }
        return systemDefs;
    }

    private static String getBasePackage(Element system) {
        String basePackage = "";
        Iterator it2 = system.attributeIterator();
        while (it2.hasNext()) {
            Attribute attribute = (Attribute)it2.next();
            if (!attribute.getName().trim().equals("base-package")) continue;
            basePackage = attribute.getValue().trim();
            if (basePackage.endsWith(".*")) {
                basePackage = basePackage.substring(0, basePackage.length() - 1);
                break;
            }
            if (basePackage.endsWith(".")) break;
            basePackage = basePackage + ".";
            break;
        }
        return basePackage;
    }
}

