/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.regexp.PatternTuple;

public class PatternFactory {
    public static PatternTuple createClassPatternTuple(String pattern) {
        return PatternFactory.createClassPatternTuple(pattern, "");
    }

    public static PatternTuple createClassPatternTuple(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        boolean isHierarchical = false;
        try {
            String classPattern = packageName.equals("") ? pattern : packageName + "." + pattern;
            if (classPattern.endsWith("+")) {
                classPattern = classPattern.substring(0, classPattern.length() - 1);
                isHierarchical = true;
            }
            return new PatternTuple(null, classPattern, classPattern, isHierarchical);
        }
        catch (Exception e) {
            throw new DefinitionException("class pattern is not well formed [" + pattern + "]");
        }
    }

    public static String createClassPattern(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        boolean isHierarchical = false;
        try {
            String classPattern = packageName.equals("") ? pattern : packageName + "." + pattern;
            return classPattern;
        }
        catch (Exception e) {
            throw new DefinitionException("class pattern is not well formed [" + pattern + "]");
        }
    }

    public static PatternTuple createMethodPatternTuple(String pattern) {
        return PatternFactory.createMethodPatternTuple(pattern, "");
    }

    public static PatternTuple createMethodPatternTuple(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        boolean isHierarchical = false;
        try {
            int indexFirstSpace = pattern.indexOf(32);
            String returnType = pattern.substring(0, indexFirstSpace + 1);
            String classNameWithMethodName = pattern.substring(indexFirstSpace, pattern.indexOf(40)).trim();
            String parameterTypes = pattern.substring(pattern.indexOf(40), pattern.length()).trim();
            int indexLastDot = classNameWithMethodName.lastIndexOf(46);
            String methodPattern = classNameWithMethodName.substring(indexLastDot + 1, classNameWithMethodName.length()).trim();
            String classPattern = packageName + classNameWithMethodName.substring(0, indexLastDot);
            if (classPattern.endsWith("+")) {
                classPattern = classPattern.substring(0, classPattern.length() - 1);
                isHierarchical = true;
            }
            StringBuffer memberPattern = new StringBuffer();
            memberPattern.append(returnType);
            memberPattern.append(methodPattern);
            memberPattern.append(parameterTypes);
            return new PatternTuple(null, classPattern, memberPattern.toString(), isHierarchical);
        }
        catch (Exception e) {
            throw new DefinitionException("method pattern is not well formed [" + pattern + "]");
        }
    }

    public static String createMethodPattern(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        try {
            int indexFirstSpace = pattern.indexOf(32);
            String returnType = pattern.substring(0, indexFirstSpace + 1);
            String classNameWithMethodName = pattern.substring(indexFirstSpace, pattern.length()).trim();
            StringBuffer fullPattern = new StringBuffer();
            fullPattern.append(returnType);
            if (!packageName.equals("")) {
                fullPattern.append(packageName);
                fullPattern.append('.');
            }
            fullPattern.append(classNameWithMethodName);
            return fullPattern.toString();
        }
        catch (Exception e) {
            throw new DefinitionException("method pattern is not well formed [" + pattern + "]");
        }
    }

    public static PatternTuple createFieldPatternTuple(String pattern) {
        return PatternFactory.createFieldPatternTuple(pattern, "");
    }

    public static PatternTuple createFieldPatternTuple(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        boolean isHierarchical = false;
        try {
            int indexFirstSpace = pattern.indexOf(32);
            String fieldType = pattern.substring(0, indexFirstSpace + 1);
            String classNameWithFieldName = pattern.substring(indexFirstSpace, pattern.length()).trim();
            int indexLastDot = classNameWithFieldName.lastIndexOf(46);
            String fieldPattern = classNameWithFieldName.substring(indexLastDot + 1, classNameWithFieldName.length()).trim();
            String classPattern = packageName + classNameWithFieldName.substring(0, indexLastDot).trim();
            if (classPattern.endsWith("+")) {
                classPattern = classPattern.substring(0, classPattern.length() - 1);
                isHierarchical = true;
            }
            StringBuffer memberPattern = new StringBuffer();
            memberPattern.append(fieldType);
            memberPattern.append(fieldPattern);
            return new PatternTuple(null, classPattern, memberPattern.toString(), isHierarchical);
        }
        catch (Exception e) {
            throw new DefinitionException("field pattern is not well formed [" + pattern + "]");
        }
    }

    public static String createFieldPattern(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        boolean isHierarchical = false;
        try {
            int indexFirstSpace = pattern.indexOf(32);
            String fieldType = pattern.substring(0, indexFirstSpace + 1);
            String classNameWithFieldName = pattern.substring(indexFirstSpace, pattern.length()).trim();
            StringBuffer fullPattern = new StringBuffer();
            fullPattern.append(fieldType);
            if (!packageName.equals("")) {
                fullPattern.append(packageName);
                fullPattern.append('.');
            }
            fullPattern.append(classNameWithFieldName);
            return fullPattern.toString();
        }
        catch (Exception e) {
            throw new DefinitionException("field pattern is not well formed [" + pattern + "]");
        }
    }

    public static PatternTuple createThrowsPatternTuple(String pattern) {
        return PatternFactory.createThrowsPatternTuple(pattern, "");
    }

    public static PatternTuple createThrowsPatternTuple(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        boolean isHierarchical = false;
        try {
            String classAndMethodName = pattern.substring(0, pattern.indexOf(35)).trim();
            String exceptionName = pattern.substring(pattern.indexOf(35) + 1).trim();
            int indexFirstSpace = classAndMethodName.indexOf(32);
            String returnType = classAndMethodName.substring(0, indexFirstSpace + 1);
            String classNameWithMethodName = classAndMethodName.substring(indexFirstSpace, classAndMethodName.indexOf(40)).trim();
            String parameterTypes = classAndMethodName.substring(classAndMethodName.indexOf(40), classAndMethodName.length()).trim();
            int indexLastDot = classNameWithMethodName.lastIndexOf(46);
            String methodPattern = classNameWithMethodName.substring(indexLastDot + 1, classNameWithMethodName.length()).trim();
            String classPattern = packageName + classNameWithMethodName.substring(0, indexLastDot);
            if (classPattern.endsWith("+")) {
                classPattern = classPattern.substring(0, classPattern.length() - 1);
                isHierarchical = true;
            }
            StringBuffer memberPattern = new StringBuffer();
            memberPattern.append(returnType);
            memberPattern.append(methodPattern);
            memberPattern.append(parameterTypes);
            memberPattern.append('#');
            memberPattern.append(exceptionName);
            return new PatternTuple(null, classPattern, memberPattern.toString(), isHierarchical);
        }
        catch (Exception e) {
            throw new DefinitionException("throws pattern is not well formed [" + pattern + "]");
        }
    }

    public static String createThrowsPattern(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        try {
            String classAndMethodName = pattern.substring(0, pattern.indexOf(35)).trim();
            String exceptionName = pattern.substring(pattern.indexOf(35) + 1).trim();
            int indexFirstSpace = classAndMethodName.indexOf(32);
            String returnType = classAndMethodName.substring(0, indexFirstSpace + 1);
            String classNameWithMethodName = classAndMethodName.substring(indexFirstSpace, classAndMethodName.length()).trim();
            StringBuffer fullPattern = new StringBuffer();
            fullPattern.append(returnType);
            if (!packageName.equals("")) {
                fullPattern.append(packageName);
                fullPattern.append('.');
            }
            fullPattern.append(classNameWithMethodName);
            fullPattern.append('#');
            fullPattern.append(exceptionName);
            return fullPattern.toString();
        }
        catch (Exception e) {
            throw new DefinitionException("throws pattern is not well formed [" + pattern + "]");
        }
    }

    public static PatternTuple createCallPatternTuple(String pattern) {
        return PatternFactory.createCallPatternTuple(pattern, "");
    }

    public static PatternTuple createCallPatternTuple(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        boolean isHierarchical = false;
        try {
            String callerClassPattern;
            if (pattern.indexOf(62) == -1) {
                pattern = "*->" + pattern;
            }
            if ((callerClassPattern = packageName + pattern.substring(0, pattern.indexOf(45)).trim()).endsWith("+")) {
                callerClassPattern = callerClassPattern.substring(0, callerClassPattern.length() - 1);
                isHierarchical = true;
            }
            String calleePattern = pattern.substring(pattern.indexOf(62) + 1).trim();
            int indexFirstSpace = calleePattern.indexOf(32);
            String returnType = calleePattern.substring(0, indexFirstSpace + 1);
            String classNameWithMethodName = calleePattern.substring(indexFirstSpace, calleePattern.indexOf(40)).trim();
            String parameterTypes = calleePattern.substring(calleePattern.indexOf(40), calleePattern.length()).trim();
            int indexLastDot = classNameWithMethodName.lastIndexOf(46);
            String calleeMethodPattern = classNameWithMethodName.substring(indexLastDot + 1, classNameWithMethodName.length()).trim();
            String calleeClassPattern = packageName + classNameWithMethodName.substring(0, indexLastDot);
            if (calleeClassPattern.endsWith("+")) {
                calleeClassPattern = calleeClassPattern.substring(0, calleeClassPattern.length() - 1);
                isHierarchical = true;
            }
            calleeMethodPattern = returnType + calleeMethodPattern + parameterTypes;
            StringBuffer buf = new StringBuffer();
            buf.append(calleeClassPattern);
            buf.append("->");
            buf.append(calleeMethodPattern);
            return new PatternTuple(callerClassPattern, calleeClassPattern, buf.toString(), isHierarchical);
        }
        catch (Exception e) {
            throw new DefinitionException("caller side pattern is not well formed [" + pattern + "]");
        }
    }

    public static String createCallPattern(String pattern, String packageName) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern can not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("package name can not be null");
        }
        try {
            String callerClassPattern;
            if (pattern.indexOf(62) == -1) {
                pattern = "*->" + pattern;
            }
            if ((callerClassPattern = packageName + pattern.substring(0, pattern.indexOf(45)).trim()).endsWith("+")) {
                callerClassPattern = callerClassPattern.substring(0, callerClassPattern.length() - 1);
            }
            String calleePattern = pattern.substring(pattern.indexOf(62) + 1).trim();
            int indexFirstSpace = calleePattern.indexOf(32);
            String returnType = calleePattern.substring(0, indexFirstSpace + 1);
            String classNameWithMethodName = calleePattern.substring(indexFirstSpace, calleePattern.indexOf(40)).trim();
            String parameterTypes = calleePattern.substring(calleePattern.indexOf(40), calleePattern.length()).trim();
            int indexLastDot = classNameWithMethodName.lastIndexOf(46);
            String calleeMethodPattern = classNameWithMethodName.substring(indexLastDot + 1, classNameWithMethodName.length()).trim();
            String calleeClassPattern = packageName + classNameWithMethodName.substring(0, indexLastDot);
            StringBuffer fullPattern = new StringBuffer();
            fullPattern.append(callerClassPattern);
            fullPattern.append("->");
            fullPattern.append(returnType);
            if (!packageName.equals("")) {
                fullPattern.append(packageName);
                fullPattern.append('.');
            }
            fullPattern.append(calleeClassPattern);
            fullPattern.append('.');
            fullPattern.append(calleeMethodPattern);
            fullPattern.append(parameterTypes);
            return fullPattern.toString();
        }
        catch (Exception e) {
            throw new DefinitionException("caller side pattern is not well formed [" + pattern + "]");
        }
    }
}

