/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.definition.DocumentParser;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XmlParser {
    public static final String MODEL_TYPE_ATTRIB = "attrib";
    public static final String MODEL_TYPE_XML = "xml";
    private static final String DTD_PUBLIC_ID = "-//AspectWerkz//DTD 0.9//EN";
    private static final String DTD_PUBLIC_ID_ALIAS = "-//AspectWerkz//DTD//EN";
    private static File s_timestamp = new File(".timestamp");
    private static List s_definitions = null;

    public static List parse(File definitionFile) {
        return XmlParser.parse(definitionFile, false);
    }

    public static List parse(File definitionFile, boolean isDirty) {
        if (definitionFile == null) {
            throw new IllegalArgumentException("definition file can not be null");
        }
        if (!definitionFile.exists()) {
            throw new DefinitionException("definition file " + definitionFile.toString() + " does not exist");
        }
        if (XmlParser.isNotUpdated(definitionFile)) {
            isDirty = false;
            return s_definitions;
        }
        try {
            Document document = XmlParser.createDocument(definitionFile.toURL());
            s_definitions = XmlParser.parse(document);
            XmlParser.setParsingTimestamp();
            isDirty = true;
            return s_definitions;
        }
        catch (MalformedURLException e) {
            throw new DefinitionException(definitionFile + " does not exist");
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new DefinitionException("XML definition file <" + definitionFile + "> has errors: " + e.getMessage());
        }
    }

    public static List parse(InputStream stream) {
        try {
            Document document = XmlParser.createDocument(stream);
            s_definitions = XmlParser.parse(document);
            return s_definitions;
        }
        catch (DocumentException e) {
            throw new DefinitionException("XML definition file on classpath has errors: " + e.getMessage());
        }
    }

    public static List parseNoCache(URL url) {
        try {
            Document document = XmlParser.createDocument(url);
            s_definitions = XmlParser.parse(document);
            return s_definitions;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static List parse(Document document) {
        return DocumentParser.parse(document);
    }

    public static Document mergeDocuments(Document document1, Document document2) {
        if (document2 == null && document1 != null) {
            return document1;
        }
        if (document1 == null && document2 != null) {
            return document2;
        }
        if (document1 == null && document2 == null) {
            return null;
        }
        try {
            Element root1 = document1.getRootElement();
            Element root2 = document2.getRootElement();
            Iterator it1 = root2.elementIterator();
            while (it1.hasNext()) {
                Element element = (Element)it1.next();
                element.setParent(null);
                root1.add(element);
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return document1;
    }

    public static Document createDocument(URL url) throws DocumentException {
        SAXReader reader = new SAXReader();
        XmlParser.setEntityResolver(reader);
        return reader.read(url);
    }

    public static Document createDocument(InputStream stream) throws DocumentException {
        SAXReader reader = new SAXReader();
        XmlParser.setEntityResolver(reader);
        return reader.read(stream);
    }

    private static void setEntityResolver(SAXReader reader) {
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId.equals(XmlParser.DTD_PUBLIC_ID) || publicId.equals(XmlParser.DTD_PUBLIC_ID_ALIAS)) {
                    InputStream in = this.getClass().getResourceAsStream("/aspectwerkz.dtd");
                    return new InputSource(in);
                }
                System.err.println("AspectWerkz - WARN - deprecated DTD " + publicId + " - consider upgrading to " + XmlParser.DTD_PUBLIC_ID);
                return new InputSource();
            }
        };
        reader.setEntityResolver(resolver);
    }

    private static boolean isNotUpdated(File definitionFile) {
        return definitionFile.lastModified() < XmlParser.getParsingTimestamp() && s_definitions != null;
    }

    private static void setParsingTimestamp() {
        long newModifiedTime = System.currentTimeMillis();
        s_timestamp.setLastModified(newModifiedTime);
    }

    private static long getParsingTimestamp() {
        long modifiedTime = s_timestamp.lastModified();
        if (modifiedTime == 0L) {
            try {
                s_timestamp.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("could not create timestamp file: " + s_timestamp.getAbsolutePath());
            }
        }
        return modifiedTime;
    }
}

