/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition.expression;

import java.io.Serializable;
import java.util.Map;
import org.codehaus.aspectwerkz.definition.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MemberMetaData;

public abstract class Expression
implements Serializable {
    protected String m_name;
    protected ExpressionNamespace m_namespace;
    protected String m_expression;
    protected PointcutType m_type;
    protected String m_package = "";

    Expression(ExpressionNamespace namespace, String expression, String name, PointcutType type) {
        this(namespace, expression, "", name, type);
    }

    Expression(ExpressionNamespace namespace, String expression, String packageNamespace, String name, PointcutType type) {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace can not be null");
        }
        if (expression == null) {
            throw new IllegalArgumentException("expression can not be null");
        }
        this.m_namespace = namespace;
        this.m_expression = expression;
        this.m_name = name;
        this.m_type = type;
        this.m_package = packageNamespace == null ? packageNamespace : "";
    }

    public String getName() {
        return this.m_name;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public ExpressionNamespace getNamespace() {
        return this.m_namespace;
    }

    public PointcutType getType() {
        return this.m_type;
    }

    public abstract boolean match(ClassMetaData var1);

    public abstract boolean matchInOrNotIn(ClassMetaData var1);

    public abstract boolean match(ClassMetaData var1, MemberMetaData var2);

    public abstract boolean matchInOrNotIn(ClassMetaData var1, MemberMetaData var2);

    public abstract boolean match(ClassMetaData var1, MemberMetaData var2, String var3);

    public abstract Map getCflowExpressions();

    public String toString() {
        return "[" + super.toString() + ": " + this.m_name + "," + this.m_namespace + "," + this.m_package + "," + this.m_expression + "]";
    }
}

