/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition.expression;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.definition.expression.ExpressionContext;
import org.codehaus.aspectwerkz.definition.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.definition.expression.ast.ExpressionParser;
import org.codehaus.aspectwerkz.definition.expression.ast.ExpressionParserVisitor;
import org.codehaus.aspectwerkz.definition.expression.ast.ParseException;
import org.codehaus.aspectwerkz.definition.expression.ast.SimpleNode;
import org.codehaus.aspectwerkz.definition.expression.visitor.CflowIdentifierLookupVisitor;
import org.codehaus.aspectwerkz.definition.expression.visitor.EvaluateVisitor;
import org.codehaus.aspectwerkz.definition.expression.visitor.IdentifierLookupVisitor;
import org.codehaus.aspectwerkz.definition.expression.visitor.TypeVisitor;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MemberMetaData;

public class ExpressionExpression
extends Expression {
    protected final Map m_expressionRefs = new HashMap();
    protected final Map m_cflowExpressionRefs = new HashMap();
    private static ExpressionParserVisitor TYPE_VISITOR = new TypeVisitor();
    private static ExpressionParserVisitor IDENTIFIER_VISITOR = new IdentifierLookupVisitor();
    private static ExpressionParserVisitor CFLOWIDENTIFIER_VISITOR = new CflowIdentifierLookupVisitor();
    private static ExpressionParserVisitor EVALUATE_VISITOR = new EvaluateVisitor();
    private SimpleNode root;

    public ExpressionExpression(ExpressionNamespace namespace, String expression) {
        this(namespace, expression, "");
    }

    public ExpressionExpression(ExpressionNamespace namespace, String expression, String name) {
        super(namespace, expression, "", name, null);
        try {
            ExpressionParser parser = new ExpressionParser(new StringReader(expression));
            this.root = parser.ExpressionScript();
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        this.m_type = this.determineTypeFromAST();
        if (this.m_type == null) {
            throw new RuntimeException("unable to determine type from " + expression);
        }
        this.initializeLeafExpressionMapFromAST();
        this.initializeCflowExpressionMapFromAST();
    }

    private PointcutType determineTypeFromAST() {
        return (PointcutType)this.root.jjtAccept(TYPE_VISITOR, this.m_namespace);
    }

    private void initializeLeafExpressionMapFromAST() {
        ArrayList leafNames = new ArrayList();
        this.root.jjtAccept(IDENTIFIER_VISITOR, leafNames);
        String leafName = null;
        Iterator i = leafNames.iterator();
        while (i.hasNext()) {
            leafName = (String)i.next();
            this.m_expressionRefs.put(leafName, this.m_namespace.getExpression(leafName));
        }
    }

    private void initializeCflowExpressionMapFromAST() {
        ArrayList cflowNames = new ArrayList();
        this.root.jjtAccept(CFLOWIDENTIFIER_VISITOR, cflowNames);
        String cflowName = null;
        Iterator i = cflowNames.iterator();
        while (i.hasNext()) {
            cflowName = (String)i.next();
            this.m_cflowExpressionRefs.put(cflowName, this.m_namespace.getExpression(cflowName));
        }
        if (this.m_cflowExpressionRefs.size() > 1) {
            throw new RuntimeException("complex cflow expression not supported yet");
        }
    }

    public boolean match(ClassMetaData classMetaData) {
        Iterator it = this.m_expressionRefs.values().iterator();
        while (it.hasNext()) {
            Expression expression = (Expression)it.next();
            if (!expression.match(classMetaData)) continue;
            return true;
        }
        return false;
    }

    public boolean matchInOrNotIn(ClassMetaData classMetaData) {
        Iterator it = this.m_cflowExpressionRefs.values().iterator();
        while (it.hasNext()) {
            Expression expression = (Expression)it.next();
            if (!expression.match(classMetaData)) continue;
            return true;
        }
        return false;
    }

    public boolean matchInOrNotIn(ClassMetaData classMetaData, MemberMetaData memberMetaData) {
        Iterator it = this.m_cflowExpressionRefs.values().iterator();
        while (it.hasNext()) {
            Expression expression = (Expression)it.next();
            if (!expression.match(classMetaData, memberMetaData)) continue;
            return true;
        }
        return false;
    }

    public boolean match(ClassMetaData classMetaData, MemberMetaData memberMetaData, String exceptionType) {
        if (exceptionType != null && !this.m_type.equals(PointcutType.THROWS)) {
            throw new RuntimeException("expression of type " + this.m_type.toString() + "cannot evaluate exception type");
        }
        ExpressionContext ctx = new ExpressionContext(this.m_type, this.m_namespace, classMetaData, memberMetaData, exceptionType);
        return (Boolean)this.root.jjtAccept(EVALUATE_VISITOR, ctx);
    }

    public boolean match(ClassMetaData classMetaData, MemberMetaData memberMetaData) {
        return this.match(classMetaData, memberMetaData, null);
    }

    public Map getCflowExpressions() {
        return this.m_cflowExpressionRefs;
    }
}

