/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.definition.expression.CallExpression;
import org.codehaus.aspectwerkz.definition.expression.CflowExpression;
import org.codehaus.aspectwerkz.definition.expression.ClassExpression;
import org.codehaus.aspectwerkz.definition.expression.ExecutionExpression;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.definition.expression.ExpressionExpression;
import org.codehaus.aspectwerkz.definition.expression.GetExpression;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.definition.expression.SetExpression;
import org.codehaus.aspectwerkz.definition.expression.ThrowsExpression;
import org.codehaus.aspectwerkz.exception.ExpressionException;

public class ExpressionNamespace {
    private static final String DEFAULT_NAMESPACE = "DEFAULT_NAMESPACE";
    private static Map s_namespaces = new WeakHashMap();
    private String m_namespace;
    private Map m_expressions = new HashMap();

    public static synchronized ExpressionNamespace getExpressionNamespace(Object namespace) {
        if (!s_namespaces.containsKey(namespace)) {
            s_namespaces.put(namespace, new ExpressionNamespace(namespace.toString()));
        }
        return (ExpressionNamespace)s_namespaces.get(namespace);
    }

    public static ExpressionNamespace getExpressionNamespace() {
        return ExpressionNamespace.getExpressionNamespace(DEFAULT_NAMESPACE);
    }

    public Expression createExpression(String expression, PointcutType type) {
        return this.createExpression(expression, "", "", type);
    }

    public Expression createExpression(String expression) {
        return new ExpressionExpression(this, expression);
    }

    public Expression createExpression(String expression, String name) {
        return new ExpressionExpression(this, expression, name);
    }

    public Expression createExpression(String expression, String name, PointcutType type) {
        return this.createExpression(expression, "", name, type);
    }

    public Expression createExpression(String expression, String packageNamespace, String name, PointcutType type) {
        Expression expr = null;
        if (!ExpressionNamespace.looksLikeLeaf(expression)) {
            expr = new ExpressionExpression(this, expression, name);
        } else if (type.equals(PointcutType.EXECUTION)) {
            expr = this.createExecutionExpression(expression, packageNamespace, name);
        } else if (type.equals(PointcutType.CALL)) {
            expr = this.createCallExpression(expression, packageNamespace, name);
        } else if (type.equals(PointcutType.SET)) {
            expr = this.createSetExpression(expression, packageNamespace, name);
        } else if (type.equals(PointcutType.GET)) {
            expr = this.createGetExpression(expression, packageNamespace, name);
        } else if (type.equals(PointcutType.THROWS)) {
            expr = this.createThrowsExpression(expression, packageNamespace, name);
        } else if (type.equals(PointcutType.CFLOW)) {
            expr = this.createCflowExpression(expression, packageNamespace, name);
        } else if (type.equals(PointcutType.CLASS)) {
            expr = this.createClassExpression(expression, packageNamespace, name);
        } else {
            throw new ExpressionException("poincut type is not supported: " + type);
        }
        return expr;
    }

    public ExecutionExpression createExecutionExpression(String expression, String packageNamespace, String name) {
        return new ExecutionExpression(this, expression, packageNamespace, name);
    }

    public CallExpression createCallExpression(String expression, String packageNamespace, String name) {
        return new CallExpression(this, expression, packageNamespace, name);
    }

    public SetExpression createSetExpression(String expression, String packageNamespace, String name) {
        return new SetExpression(this, expression, packageNamespace, name);
    }

    public GetExpression createGetExpression(String expression, String packageNamespace, String name) {
        return new GetExpression(this, expression, packageNamespace, name);
    }

    public ThrowsExpression createThrowsExpression(String expression, String packageNamespace, String name) {
        return new ThrowsExpression(this, expression, packageNamespace, name);
    }

    public CflowExpression createCflowExpression(String expression, String packageNamespace, String name) {
        return new CflowExpression(this, expression, packageNamespace, name);
    }

    public ClassExpression createClassExpression(String expression, String packageNamespace, String name) {
        return new ClassExpression(this, expression, packageNamespace, name);
    }

    public Expression registerExpression(Expression expression) {
        this.m_expressions.put(expression.getName(), expression);
        expression.m_namespace = this;
        return expression;
    }

    public Expression registerExpression(String expression, String packageNamespace, String name, PointcutType type) {
        Expression expr = this.createExpression(expression, packageNamespace, name, type);
        return this.registerExpression(expr);
    }

    public Expression getExpression(String expressionName) {
        return (Expression)this.m_expressions.get(expressionName);
    }

    private ExpressionNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    private static boolean looksLikeLeaf(String expression) {
        return expression.indexOf(".") > 0 || expression.indexOf("->") > 0 || expression.indexOf("#") > 0;
    }
}

