/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition.expression;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.definition.PatternFactory;
import org.codehaus.aspectwerkz.definition.expression.Expression;
import org.codehaus.aspectwerkz.definition.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.definition.expression.PointcutType;
import org.codehaus.aspectwerkz.exception.ExpressionException;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.InterfaceMetaData;
import org.codehaus.aspectwerkz.metadata.MemberMetaData;
import org.codehaus.aspectwerkz.regexp.ClassPattern;
import org.codehaus.aspectwerkz.regexp.Pattern;
import org.codehaus.aspectwerkz.regexp.PatternTuple;

public abstract class LeafExpression
extends Expression {
    protected boolean m_isHierarchical = false;
    protected ClassPattern m_classPattern;
    protected Pattern m_memberPattern;

    protected LeafExpression(ExpressionNamespace namespace, String expression, String packageNamespace, String pointcutName, PointcutType type) {
        super(namespace, expression, packageNamespace, pointcutName, type);
        this.compilePattern();
    }

    public boolean isHierarchical() {
        return this.m_isHierarchical;
    }

    protected void compilePattern() {
        PatternTuple tuple = null;
        if (this.m_type == null) {
            throw new ExpressionException("pointcut type in context can not be null");
        }
        if (this.m_type.equals(PointcutType.EXECUTION)) {
            tuple = PatternFactory.createMethodPatternTuple(this.m_expression, this.m_package);
            this.m_memberPattern = Pattern.compileMethodPattern(tuple.getMemberPattern());
            this.m_isHierarchical = tuple.isHierarchical();
            this.m_classPattern = Pattern.compileClassPattern(tuple.getCalleeClassPattern());
        } else if (this.m_type.equals(PointcutType.CALL)) {
            tuple = PatternFactory.createCallPatternTuple(this.m_expression, this.m_package);
            this.m_memberPattern = Pattern.compileCallerSidePattern(tuple.getMemberPattern());
            this.m_isHierarchical = tuple.isHierarchical();
            this.m_classPattern = Pattern.compileClassPattern(tuple.getCallerClassPattern());
        } else if (this.m_type.equals(PointcutType.SET) || this.m_type.equals(PointcutType.GET)) {
            tuple = PatternFactory.createFieldPatternTuple(this.m_expression, this.m_package);
            this.m_memberPattern = Pattern.compileFieldPattern(tuple.getMemberPattern());
            this.m_isHierarchical = tuple.isHierarchical();
            this.m_classPattern = Pattern.compileClassPattern(tuple.getCalleeClassPattern());
        } else if (this.m_type.equals(PointcutType.THROWS)) {
            tuple = PatternFactory.createThrowsPatternTuple(this.m_expression, this.m_package);
            this.m_memberPattern = Pattern.compileThrowsPattern(tuple.getMemberPattern());
            this.m_isHierarchical = tuple.isHierarchical();
            this.m_classPattern = Pattern.compileClassPattern(tuple.getCalleeClassPattern());
        } else if (this.m_type.equals(PointcutType.CFLOW)) {
            tuple = PatternFactory.createCallPatternTuple(this.m_expression, this.m_package);
            this.m_memberPattern = Pattern.compileCallerSidePattern(tuple.getMemberPattern());
            this.m_isHierarchical = tuple.isHierarchical();
            this.m_classPattern = Pattern.compileClassPattern(tuple.getCalleeClassPattern());
        } else if (this.m_type.equals(PointcutType.CLASS)) {
            tuple = PatternFactory.createClassPatternTuple(this.m_expression, this.m_package);
            this.m_isHierarchical = tuple.isHierarchical();
            this.m_classPattern = Pattern.compileClassPattern(tuple.getCalleeClassPattern());
        }
    }

    public boolean match(ClassMetaData classMetaData) {
        boolean matchesClassPattern = false;
        if (this.m_isHierarchical) {
            if (this.matchSuperClasses(classMetaData)) {
                matchesClassPattern = true;
            }
        } else {
            matchesClassPattern = this.m_classPattern.matches(classMetaData.getName());
        }
        return matchesClassPattern;
    }

    public boolean matchInOrNotIn(ClassMetaData classMetaData) {
        if (!this.m_type.equals(PointcutType.CFLOW)) {
            throw new RuntimeException("matchIn called on non CflowExpression " + this.m_type.toString());
        }
        return this.match(classMetaData);
    }

    public boolean matchInOrNotIn(ClassMetaData classMetaData, MemberMetaData memberMetaData) {
        if (!this.m_type.equals(PointcutType.CFLOW)) {
            throw new RuntimeException("matchIn called on non CflowExpression " + this.m_type.toString());
        }
        return this.match(classMetaData, memberMetaData);
    }

    protected boolean matchSuperClasses(ClassMetaData classMetaData) {
        if (classMetaData == null) {
            return false;
        }
        if (this.m_classPattern.matches(classMetaData.getName())) {
            return true;
        }
        if (this.matchInterfaces(classMetaData.getInterfaces(), classMetaData)) {
            return true;
        }
        return this.matchSuperClasses(classMetaData.getSuperClass());
    }

    protected boolean matchInterfaces(List interfaces, ClassMetaData classMetaData) {
        if (interfaces.isEmpty()) {
            return false;
        }
        Iterator it = interfaces.iterator();
        while (it.hasNext()) {
            InterfaceMetaData interfaceMD = (InterfaceMetaData)it.next();
            if (this.m_classPattern.matches(interfaceMD.getName())) {
                return true;
            }
            if (!this.matchInterfaces(interfaceMD.getInterfaces(), classMetaData)) continue;
            return true;
        }
        return false;
    }

    public boolean match(ClassMetaData classMetaData, MemberMetaData memberMetaData, String exceptionType) {
        return this.match(classMetaData, memberMetaData);
    }

    public Map getCflowExpressions() {
        return new HashMap();
    }
}

