/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint;

import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.bcel.generic.Type;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.attribdef.AttribDefSystem;
import org.codehaus.aspectwerkz.joinpoint.AbstractJoinPoint;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.metadata.ReflectionMetaDataMaker;
import org.codehaus.aspectwerkz.pointcut.CallPointcut;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.xmldef.XmlDefSystem;

public class CallerSideJoinPoint
extends AbstractJoinPoint {
    private transient System m_system;
    private static final long serialVersionUID = -8831127199517513612L;
    protected Class m_targetClass;
    protected Method m_callerMethod;
    protected String m_calleeMethodName;
    protected String m_calleeClassName;
    protected String m_calleeMethodSignature;
    protected Class[] m_calleeMethodParameterTypes = null;
    protected String[] m_calleeMethodParameterTypeNames = null;
    protected Class m_calleeMethodReturnType = null;
    protected String m_calleeMethodReturnTypeName = null;
    protected String m_callerMethodName;
    protected String m_callerMethodSignature;
    protected Class[] m_callerMethodParameterTypes = null;
    protected String[] m_callerMethodParameterTypeNames = null;
    protected Class m_callerMethodReturnType = null;
    protected String m_callerMethodReturnTypeName = null;
    protected IndexTuple[] m_preAdvices = new IndexTuple[0];
    protected IndexTuple[] m_postAdvices = new IndexTuple[0];
    protected boolean m_initialized = false;
    protected ClassMetaData m_classMetaData;
    protected MethodMetaData m_methodMetaData;
    protected String m_uuid;

    public CallerSideJoinPoint(String uuid, Class callerClass, String callerMethodName, String callerMethodSignature, String calleeMethodName, String calleeMethodSignature) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (callerClass == null) {
            throw new IllegalArgumentException("original class can not be null");
        }
        if (callerMethodName == null) {
            throw new IllegalArgumentException("caller method name can not be null");
        }
        if (callerMethodSignature == null) {
            throw new IllegalArgumentException("caller signature can not be null");
        }
        if (calleeMethodName == null) {
            throw new IllegalArgumentException("callee method name can not be null");
        }
        if (calleeMethodSignature == null) {
            throw new IllegalArgumentException("callee signature can not be null");
        }
        this.m_system = SystemLoader.getSystem(uuid);
        this.m_system.initialize();
        this.m_uuid = uuid;
        this.m_targetClass = callerClass;
        this.m_callerMethodName = callerMethodName;
        this.m_callerMethodSignature = callerMethodSignature;
        StringTokenizer tokenizer = new StringTokenizer(calleeMethodName, "#");
        this.m_calleeClassName = tokenizer.nextToken();
        this.m_calleeMethodName = tokenizer.nextToken();
        this.m_calleeMethodSignature = calleeMethodSignature;
        this.createMetaData();
    }

    public Object proceedInNewThread() throws Throwable {
        return null;
    }

    public Object proceed() throws Throwable {
        return null;
    }

    public void pre() throws Throwable {
        if (!this.m_initialized) {
            this.loadAdvices();
        }
        if (this.m_system.isAttribDef()) {
            AttribDefSystem system = (AttribDefSystem)this.m_system;
            int j = this.m_preAdvices.length;
            for (int i = 0; i < j; ++i) {
                try {
                    IndexTuple index = this.m_preAdvices[i];
                    int aspectIndex = index.getAspectIndex();
                    int methodIndex = index.getMethodIndex();
                    system.getAspect(aspectIndex).___AW_invokeAdvice(methodIndex, this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        } else {
            XmlDefSystem system = (XmlDefSystem)this.m_system;
            int j = this.m_preAdvices.length;
            for (int i = 0; i < j; ++i) {
                try {
                    system.getAdvice(this.m_preAdvices[i]).doExecute(this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        }
    }

    public void post() throws Throwable {
        if (!this.m_initialized) {
            this.loadAdvices();
        }
        if (this.m_system.isAttribDef()) {
            AttribDefSystem system = (AttribDefSystem)this.m_system;
            for (int i = this.m_postAdvices.length - 1; i >= 0; --i) {
                try {
                    IndexTuple index = this.m_postAdvices[i];
                    int aspectIndex = index.getAspectIndex();
                    int methodIndex = index.getMethodIndex();
                    system.getAspect(aspectIndex).___AW_invokeAdvice(methodIndex, this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        } else {
            XmlDefSystem system = (XmlDefSystem)this.m_system;
            for (int i = this.m_postAdvices.length - 1; i >= 0; --i) {
                try {
                    system.getAdvice(this.m_postAdvices[i]).doExecute(this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        }
    }

    public Object getTargetInstance() {
        return null;
    }

    public Class getTargetClass() {
        return this.m_targetClass;
    }

    public String getCalleeMethodName() {
        return this.m_calleeMethodName;
    }

    public String getCalleeClassName() {
        return this.m_calleeClassName;
    }

    public Class[] getCalleeMethodParameterTypes() {
        if (this.m_calleeMethodParameterTypes == null) {
            Type[] parameterTypes = Type.getArgumentTypes((String)this.m_calleeMethodSignature);
            this.m_calleeMethodParameterTypes = new Class[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.m_calleeMethodParameterTypes[i] = TransformationUtil.convertBcelTypeToClass(parameterTypes[i]);
            }
        }
        return this.m_calleeMethodParameterTypes;
    }

    public String[] getCalleeMethodParameterTypeNames() {
        if (this.m_calleeMethodParameterTypeNames == null) {
            Type[] parameterTypes = Type.getArgumentTypes((String)this.m_calleeMethodSignature);
            this.m_calleeMethodParameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.m_calleeMethodParameterTypeNames[i] = parameterTypes[i].toString();
            }
        }
        return this.m_calleeMethodParameterTypeNames;
    }

    public Class getCalleeMethodReturnType() {
        if (this.m_calleeMethodReturnType == null) {
            Type returnType = Type.getReturnType((String)this.m_calleeMethodSignature);
            this.m_calleeMethodReturnType = TransformationUtil.convertBcelTypeToClass(returnType);
        }
        return this.m_calleeMethodReturnType;
    }

    public String getCalleeMethodReturnTypeName() {
        if (this.m_calleeMethodReturnTypeName == null) {
            this.m_calleeMethodReturnTypeName = Type.getReturnType((String)this.m_calleeMethodSignature).toString();
        }
        return this.m_calleeMethodReturnTypeName;
    }

    public String getCalleeMethodSignature() {
        return this.m_calleeMethodSignature;
    }

    public String getCallerMethodName() {
        return this.m_callerMethodName;
    }

    public String getCallerClassName() {
        return this.m_targetClass.getName();
    }

    public Class getCallerClass() {
        return this.m_targetClass;
    }

    public Class[] getCallerMethodParameterTypes() {
        if (this.m_callerMethodParameterTypes == null) {
            Type[] parameterTypes = Type.getArgumentTypes((String)this.m_callerMethodSignature);
            this.m_callerMethodParameterTypes = new Class[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.m_callerMethodParameterTypes[i] = TransformationUtil.convertBcelTypeToClass(parameterTypes[i]);
            }
        }
        return this.m_callerMethodParameterTypes;
    }

    public String[] getCallerMethodParameterTypeNames() {
        if (this.m_callerMethodParameterTypeNames == null) {
            Type[] parameterTypes = Type.getArgumentTypes((String)this.m_callerMethodSignature);
            this.m_callerMethodParameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.m_callerMethodParameterTypeNames[i] = parameterTypes[i].toString();
            }
        }
        return this.m_callerMethodParameterTypeNames;
    }

    public Class getCallerMethodReturnType() {
        if (this.m_callerMethodReturnType == null) {
            Type returnType = Type.getReturnType((String)this.m_callerMethodSignature);
            this.m_callerMethodReturnType = TransformationUtil.convertBcelTypeToClass(returnType);
        }
        return this.m_callerMethodReturnType;
    }

    public String getCallerMethodReturnTypeName() {
        if (this.m_callerMethodReturnTypeName == null) {
            this.m_callerMethodReturnTypeName = Type.getReturnType((String)this.m_callerMethodSignature).toString();
        }
        return this.m_callerMethodReturnTypeName;
    }

    public String getCallerMethodSignature() {
        return this.m_callerMethodSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAdvices() {
        IndexTuple[] indexTupleArray = this.m_preAdvices;
        synchronized (this.m_preAdvices) {
            IndexTuple[] indexTupleArray2 = this.m_postAdvices;
            synchronized (this.m_postAdvices) {
                ArrayList<IndexTuple> preAdvices = new ArrayList<IndexTuple>();
                ArrayList<IndexTuple> postAdvices = new ArrayList<IndexTuple>();
                ClassMetaData classMetaData = new ClassMetaData();
                classMetaData.setName(this.getCalleeClassName());
                List pointcuts = this.m_system.getCallPointcuts(classMetaData, this.m_methodMetaData);
                Iterator it = pointcuts.iterator();
                while (it.hasNext()) {
                    CallPointcut callerSidePointcut = (CallPointcut)it.next();
                    IndexTuple[] preAdviceIndexes = callerSidePointcut.getPreAdviceIndexes();
                    for (int j = 0; j < preAdviceIndexes.length; ++j) {
                        preAdvices.add(preAdviceIndexes[j]);
                    }
                    IndexTuple[] postAdviceIndexes = callerSidePointcut.getPostAdviceIndexes();
                    for (int j = 0; j < postAdviceIndexes.length; ++j) {
                        postAdvices.add(postAdviceIndexes[j]);
                    }
                }
                this.m_preAdvices = new IndexTuple[preAdvices.size()];
                int i = 0;
                Iterator it2 = preAdvices.iterator();
                while (it2.hasNext()) {
                    this.m_preAdvices[i] = (IndexTuple)it2.next();
                    ++i;
                }
                this.m_postAdvices = new IndexTuple[postAdvices.size()];
                i = 0;
                it2 = postAdvices.iterator();
                while (it2.hasNext()) {
                    this.m_postAdvices[i] = (IndexTuple)it2.next();
                    ++i;
                }
                this.m_initialized = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    protected void createMetaData() {
        this.m_classMetaData = ReflectionMetaDataMaker.createClassMetaData(this.getTargetClass());
        this.m_methodMetaData = ReflectionMetaDataMaker.createMethodMetaData(this.getCalleeMethodName(), this.getCalleeMethodParameterTypes(), this.getCalleeMethodReturnType());
    }

    protected String createAdvicesNotCorrectlyMappedMessage() {
        StringBuffer cause = new StringBuffer();
        cause.append("advices for ");
        cause.append(this.getCalleeClassName());
        cause.append("#");
        cause.append(this.getCalleeMethodName());
        cause.append(" are not correctly mapped");
        return cause.toString();
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_targetClass = (Class)fields.get("m_targetClass", null);
        this.m_callerMethod = (Method)fields.get("m_callerMethod", null);
        this.m_callerMethodName = (String)fields.get("m_callerMethodName", null);
        this.m_callerMethodSignature = (String)fields.get("m_callerMethodSignature", null);
        this.m_callerMethodParameterTypes = (Class[])fields.get("m_callerMethodParameterTypes", null);
        this.m_callerMethodParameterTypeNames = (String[])fields.get("m_callerMethodParameterTypeNames", null);
        this.m_callerMethodReturnType = (Class)fields.get("m_callerMethodReturnType", null);
        this.m_callerMethodReturnTypeName = (String)fields.get("m_callerMethodReturnTypeName", null);
        this.m_calleeMethodName = (String)fields.get("m_calleeMethodName", null);
        this.m_calleeMethodSignature = (String)fields.get("m_calleeMethodSignature", null);
        this.m_calleeClassName = (String)fields.get("m_calleeClassName", null);
        this.m_calleeMethodParameterTypes = (Class[])fields.get("m_calleeMethodParameterTypes", null);
        this.m_calleeMethodParameterTypeNames = (String[])fields.get("m_calleeMethodParameterTypeNames", null);
        this.m_calleeMethodReturnType = (Class)fields.get("m_calleeMethodReturnType", null);
        this.m_calleeMethodReturnTypeName = (String)fields.get("m_calleeMethodReturnTypeName", null);
        this.m_preAdvices = (IndexTuple[])fields.get("m_preAdvices", null);
        this.m_postAdvices = (IndexTuple[])fields.get("m_postAdvices", null);
        this.m_classMetaData = (ClassMetaData)fields.get("m_classMetaData", null);
        this.m_methodMetaData = (MethodMetaData)fields.get("m_fieldMetaData", null);
        this.m_initialized = fields.get("m_initialized", false);
        this.m_system = SystemLoader.getSystem(this.m_uuid);
        this.m_system.initialize();
    }
}

