/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint;

import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.Type;
import org.codehaus.aspectwerkz.attribdef.AttribDefSystem;
import org.codehaus.aspectwerkz.joinpoint.AbstractJoinPoint;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.FieldMetaData;
import org.codehaus.aspectwerkz.metadata.ReflectionMetaDataMaker;
import org.codehaus.aspectwerkz.xmldef.XmlDefSystem;

public abstract class FieldJoinPoint
extends AbstractJoinPoint {
    protected transient System m_system;
    protected String m_signature;
    protected String m_fieldName;
    protected Type m_fieldType;
    protected String m_typeName;
    protected IndexTuple[] m_preAdvices = new IndexTuple[0];
    protected IndexTuple[] m_postAdvices = new IndexTuple[0];
    protected boolean m_initialized = false;
    protected ClassMetaData m_classMetaData;
    protected FieldMetaData m_fieldMetaData;
    protected String m_uuid;

    public FieldJoinPoint(String uuid, String signature) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("signature can not be null");
        }
        this.m_system = SystemLoader.getSystem(uuid);
        this.m_system.initialize();
        this.m_uuid = uuid;
        this.m_signature = signature;
        StringTokenizer tokenizer = new StringTokenizer(signature, " ");
        this.m_typeName = tokenizer.nextToken();
        this.m_fieldName = tokenizer.nextToken();
        this.setFieldType();
    }

    public Object proceedInNewThread() throws Throwable {
        return null;
    }

    public Object proceed() throws Throwable {
        return null;
    }

    protected abstract void loadAdvices();

    public void pre() throws Throwable {
        if (!this.m_initialized) {
            this.loadAdvices();
        }
        if (this.m_system.isAttribDef()) {
            AttribDefSystem system = (AttribDefSystem)this.m_system;
            int j = this.m_preAdvices.length;
            for (int i = 0; i < j; ++i) {
                try {
                    IndexTuple index = this.m_preAdvices[i];
                    int aspectIndex = index.getAspectIndex();
                    int methodIndex = index.getMethodIndex();
                    system.getAspect(aspectIndex).___AW_invokeAdvice(methodIndex, this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        } else {
            XmlDefSystem system = (XmlDefSystem)this.m_system;
            int j = this.m_preAdvices.length;
            for (int i = 0; i < j; ++i) {
                try {
                    system.getAdvice(this.m_preAdvices[i]).doExecute(this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        }
    }

    public void post() throws Throwable {
        if (!this.m_initialized) {
            this.loadAdvices();
        }
        if (this.m_system.isAttribDef()) {
            AttribDefSystem system = (AttribDefSystem)this.m_system;
            for (int i = this.m_postAdvices.length - 1; i >= 0; --i) {
                try {
                    IndexTuple index = this.m_postAdvices[i];
                    int aspectIndex = index.getAspectIndex();
                    int methodIndex = index.getMethodIndex();
                    system.getAspect(aspectIndex).___AW_invokeAdvice(methodIndex, this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        } else {
            XmlDefSystem system = (XmlDefSystem)this.m_system;
            for (int i = this.m_postAdvices.length - 1; i >= 0; --i) {
                try {
                    system.getAdvice(this.m_postAdvices[i]).doExecute(this);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new RuntimeException(this.createAdvicesNotCorrectlyMappedMessage());
                }
            }
        }
    }

    public abstract Object getTargetInstance();

    public abstract Class getTargetClass();

    public Type getFieldType() {
        return this.m_fieldType;
    }

    public String getFieldTypeName() {
        return this.m_typeName;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public void createMetaData() {
        this.m_classMetaData = ReflectionMetaDataMaker.createClassMetaData(this.getTargetClass());
        this.m_fieldMetaData = ReflectionMetaDataMaker.createFieldMetaData(this.m_fieldName, this.m_typeName);
    }

    protected String createAdvicesNotCorrectlyMappedMessage() {
        StringBuffer cause = new StringBuffer();
        cause.append("advices for ");
        cause.append(this.getTargetClass().getName());
        cause.append("#");
        cause.append(this.getFieldName());
        cause.append(" are not correctly mapped");
        return cause.toString();
    }

    protected void setFieldType() {
        this.m_fieldType = this.m_signature.startsWith("long") ? Type.LONG : (this.m_signature.startsWith("int") ? Type.INT : (this.m_signature.startsWith("short") ? Type.SHORT : (this.m_signature.startsWith("double") ? Type.DOUBLE : (this.m_signature.startsWith("float") ? Type.FLOAT : (this.m_signature.startsWith("byte") ? Type.BYTE : (this.m_signature.startsWith("boolean") ? Type.BOOLEAN : (this.m_signature.startsWith("char") ? Type.CHAR : Type.OBJECT)))))));
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_signature = (String)fields.get("m_signature", null);
        this.m_typeName = (String)fields.get("m_typeName", null);
        this.m_fieldName = (String)fields.get("m_fieldName", null);
        this.m_fieldType = (Type)fields.get("m_fieldType", null);
        this.m_preAdvices = (IndexTuple[])fields.get("m_preAdvices", null);
        this.m_postAdvices = (IndexTuple[])fields.get("m_postAdvices", null);
        this.m_classMetaData = (ClassMetaData)fields.get("m_classMetaData", null);
        this.m_fieldMetaData = (FieldMetaData)fields.get("m_fieldMetaData", null);
        this.m_initialized = fields.get("m_initialized", false);
        this.m_system = SystemLoader.getSystem(this.m_uuid);
        this.m_system.initialize();
    }
}

