/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.joinpoint.FieldJoinPoint;
import org.codehaus.aspectwerkz.pointcut.GetPointcut;

public class MemberFieldGetJoinPoint
extends FieldJoinPoint {
    protected WeakReference m_targetObjectReference;
    private static final long serialVersionUID = 446929646654050997L;

    public MemberFieldGetJoinPoint(String uuid, Object targetObject, String signature) {
        super(uuid, signature);
        if (targetObject == null) {
            throw new IllegalArgumentException("target object can not be null");
        }
        this.m_targetObjectReference = new WeakReference<Object>(targetObject);
        this.createMetaData();
    }

    public Object getTargetInstance() {
        return this.m_targetObjectReference.get();
    }

    public Class getTargetClass() {
        return this.m_targetObjectReference.get().getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAdvices() {
        IndexTuple[] indexTupleArray = this.m_preAdvices;
        synchronized (this.m_preAdvices) {
            IndexTuple[] indexTupleArray2 = this.m_postAdvices;
            synchronized (this.m_postAdvices) {
                ArrayList<IndexTuple> preAdvices = new ArrayList<IndexTuple>();
                ArrayList<IndexTuple> postAdvices = new ArrayList<IndexTuple>();
                List pointcuts = this.m_system.getGetPointcuts(this.m_classMetaData, this.m_fieldMetaData);
                Iterator it = pointcuts.iterator();
                while (it.hasNext()) {
                    GetPointcut fieldPointcut = (GetPointcut)it.next();
                    IndexTuple[] preAdviceIndexes = fieldPointcut.getPreAdviceIndexes();
                    for (int j = 0; j < preAdviceIndexes.length; ++j) {
                        preAdvices.add(preAdviceIndexes[j]);
                    }
                    IndexTuple[] postAdviceIndexes = fieldPointcut.getPostAdviceIndexes();
                    for (int j = 0; j < postAdviceIndexes.length; ++j) {
                        postAdvices.add(postAdviceIndexes[j]);
                    }
                }
                this.m_preAdvices = new IndexTuple[preAdvices.size()];
                int i = 0;
                Iterator it2 = preAdvices.iterator();
                while (it2.hasNext()) {
                    this.m_preAdvices[i] = (IndexTuple)it2.next();
                    ++i;
                }
                this.m_postAdvices = new IndexTuple[postAdvices.size()];
                i = 0;
                it2 = postAdvices.iterator();
                while (it2.hasNext()) {
                    this.m_postAdvices[i] = (IndexTuple)it2.next();
                    ++i;
                }
                this.m_initialized = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws Exception {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("m_targetObjectReference", this.m_targetObjectReference.get());
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_targetObjectReference = new WeakReference<Object>(fields.get("m_targetObjectReference", null));
    }
}

