/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.joinpoint.MethodJoinPoint;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;

public class MemberMethodJoinPoint
extends MethodJoinPoint {
    private static final long serialVersionUID = -1514240227634639181L;
    protected WeakReference m_targetInstanceReference;

    public MemberMethodJoinPoint(String uuid, Object targetInstance, String targetClassName, int methodId, String controllerClass) {
        super(uuid, methodId, controllerClass);
        if (targetInstance == null) {
            throw new IllegalArgumentException("target instance can not be null");
        }
        this.m_targetInstanceReference = new WeakReference<Object>(targetInstance);
        try {
            this.m_targetClass = targetInstance.getClass().getClassLoader().loadClass(targetClassName);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedRuntimeException(e);
        }
        this.m_originalMethod = this.m_system.getMethod(this.m_targetClass, this.m_methodId);
        this.m_originalMethod.setAccessible(true);
        try {
            this.m_proxyMethod = this.m_targetClass.getDeclaredMethod(this.getMethodName(), this.m_originalMethod.getParameterTypes());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        this.createMetaData();
        List pointcuts = this.m_system.getExecutionPointcuts(this.m_classMetaData, this.m_methodMetaData);
        this.m_pointcuts = new ExecutionPointcut[pointcuts.size()];
        int i = 0;
        Iterator it = pointcuts.iterator();
        while (it.hasNext()) {
            this.m_pointcuts[i] = (ExecutionPointcut)it.next();
            ++i;
        }
        if (this.m_pointcuts.length == 0) {
            this.handleThrowsPointcut();
        }
        this.m_cflowExpressions = this.m_system.getCFlowExpressions(this.m_classMetaData, this.m_methodMetaData);
        for (int j = 0; j < this.m_pointcuts.length; ++j) {
            if (!this.m_pointcuts[j].isNonReentrant()) continue;
            this.m_isNonReentrant = true;
            break;
        }
    }

    public Object getTargetInstance() {
        return this.m_targetInstanceReference.get();
    }

    protected MethodJoinPoint deepCopy() {
        MemberMethodJoinPoint clone = new MemberMethodJoinPoint(this.m_uuid, this.m_targetInstanceReference.get(), this.m_targetClass.getName(), this.m_methodId, this.m_controller.getClass().getName());
        clone.m_targetClass = this.m_targetClass;
        clone.m_originalMethod = this.m_originalMethod;
        clone.m_pointcuts = this.m_pointcuts;
        clone.m_parameters = this.m_parameters;
        clone.m_result = this.m_result;
        clone.m_methodMetaData = this.m_methodMetaData;
        clone.m_controller = this.m_controller.deepCopy();
        return clone;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberMethodJoinPoint)) {
            return false;
        }
        MemberMethodJoinPoint obj = (MemberMethodJoinPoint)o;
        return MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_originalMethod, this.m_originalMethod) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_parameters, this.m_parameters) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_targetInstanceReference, this.m_targetInstanceReference) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_targetClass, this.m_targetClass) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_pointcuts, this.m_pointcuts) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_result, this.m_result) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_classMetaData, this.m_classMetaData) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_methodMetaData, this.m_methodMetaData) && MemberMethodJoinPoint.areEqualsOrBothNull(obj.m_controller, this.m_controller) && obj.m_methodId == this.m_methodId;
    }

    private void writeObject(ObjectOutputStream stream) throws Exception {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("m_targetInstanceReference", this.m_targetInstanceReference.get());
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_targetInstanceReference = new WeakReference<Object>(fields.get("m_targetInstanceReference", null));
    }
}

