/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint;

import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.AspectMetaData;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.joinpoint.AbstractJoinPoint;
import org.codehaus.aspectwerkz.joinpoint.ThrowsJoinPoint;
import org.codehaus.aspectwerkz.joinpoint.control.ControllerFactory;
import org.codehaus.aspectwerkz.joinpoint.control.JoinPointController;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.metadata.ReflectionMetaDataMaker;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;
import org.codehaus.aspectwerkz.util.Strings;
import org.codehaus.aspectwerkz.util.Util;

public abstract class MethodJoinPoint
extends AbstractJoinPoint {
    protected transient System m_system;
    protected ExecutionPointcut[] m_pointcuts;
    protected ClassMetaData m_classMetaData;
    protected MethodMetaData m_methodMetaData;
    protected int m_methodId;
    protected Class m_targetClass;
    protected Method m_originalMethod;
    protected Method m_proxyMethod;
    protected Object m_result = null;
    protected Object[] m_parameters = new Object[0];
    protected String m_uuid;
    protected Map m_throwsJoinPointCache = new WeakHashMap();
    protected List m_cflowExpressions;
    protected JoinPointController m_controller = null;
    protected boolean m_reentrancyCheck = false;
    protected boolean m_isNonReentrant = false;

    public MethodJoinPoint(String uuid, int methodId, String controllerClass) {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid can not be null");
        }
        if (methodId < 0) {
            throw new IllegalArgumentException("method id can not be less that zero");
        }
        this.m_system = SystemLoader.getSystem(uuid);
        this.m_system.initialize();
        this.m_uuid = uuid;
        this.m_methodId = methodId;
        this.m_controller = ControllerFactory.createController(controllerClass);
    }

    public System getSystem() {
        return this.m_system;
    }

    public void setPointcuts(ExecutionPointcut[] pointcuts) {
        this.m_pointcuts = pointcuts;
    }

    public ExecutionPointcut[] getPointcuts() {
        return this.m_pointcuts;
    }

    public List getCFlowExpressions() {
        return this.m_cflowExpressions;
    }

    public void setCFlowExpressions(List expressions) {
        this.m_cflowExpressions = expressions;
    }

    public MethodMetaData getMethodMetaData() {
        return this.m_methodMetaData;
    }

    public int getMethodId() {
        return this.m_methodId;
    }

    public Method getOriginalMethod() {
        return this.m_originalMethod;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    public abstract Object getTargetInstance();

    public Class getTargetClass() {
        return this.m_targetClass;
    }

    public Method getMethod() {
        return this.m_originalMethod;
    }

    public Method getProxyMethod() {
        return this.m_proxyMethod;
    }

    public String getMethodName() {
        String[] tokens = Strings.splitString(this.m_originalMethod.getName(), "$_AW_$");
        return tokens[1];
    }

    public Object[] getParameters() {
        return this.m_parameters;
    }

    public Class[] getParameterTypes() {
        return this.m_originalMethod.getParameterTypes();
    }

    public Class getReturnType() {
        return this.m_originalMethod.getReturnType();
    }

    public Object getResult() {
        return this.m_result;
    }

    public void setResult(Object result) {
        this.m_result = result;
    }

    public void setParameters(Object[] parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameter list can not be null");
        }
        this.m_parameters = parameters;
    }

    public Object proceed() throws Throwable {
        return this.m_controller.proceed(this);
    }

    public Object proceedInNewThread() throws Throwable {
        return this.deepCopy().proceed();
    }

    protected abstract MethodJoinPoint deepCopy();

    public Object invokeOriginalMethod() throws Throwable {
        if (this.m_isNonReentrant) {
            if (this.m_reentrancyCheck) {
                return this.m_result;
            }
            this.m_reentrancyCheck = true;
        }
        try {
            this.m_result = this.m_originalMethod.invoke(this.getTargetInstance(), this.m_parameters);
        }
        catch (InvocationTargetException e) {
            this.m_result = this.handleException(e);
        }
        return this.m_result;
    }

    protected void createMetaData() {
        this.m_classMetaData = ReflectionMetaDataMaker.createClassMetaData(this.getTargetClass());
        this.m_methodMetaData = ReflectionMetaDataMaker.createMethodMetaData(this.getMethodName(), this.getParameterTypes(), this.getReturnType());
    }

    protected void handleThrowsPointcut() {
        List pointcuts = this.m_system.getExecutionPointcuts(this.m_classMetaData, this.m_methodMetaData);
        this.m_pointcuts = new ExecutionPointcut[pointcuts.size()];
        int i = 0;
        Iterator it = pointcuts.iterator();
        while (it.hasNext()) {
            this.m_pointcuts[i] = (ExecutionPointcut)it.next();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleException(InvocationTargetException e) throws Throwable {
        Throwable cause = e.getTargetException();
        Integer hash = this.calculateHash(this.m_targetClass.getName(), this.m_methodMetaData, cause.getClass().getName());
        ThrowsJoinPoint joinPoint = (ThrowsJoinPoint)this.m_throwsJoinPointCache.get(hash);
        if (joinPoint != null) {
            joinPoint.proceed();
        }
        boolean hasThrowsPointcut = false;
        Collection aspects = this.m_system.getAspectsMetaData();
        Iterator it = aspects.iterator();
        while (it.hasNext()) {
            AspectMetaData aspect = (AspectMetaData)it.next();
            if (!aspect.hasThrowsPointcut(this.m_classMetaData, this.m_methodMetaData, cause.getClass().getName())) continue;
            hasThrowsPointcut = true;
            break;
        }
        Object result = null;
        if (hasThrowsPointcut) {
            Map map = this.m_throwsJoinPointCache;
            synchronized (map) {
                joinPoint = new ThrowsJoinPoint(this.m_uuid, this, cause);
                this.m_throwsJoinPointCache.put(hash, joinPoint);
            }
        } else {
            Util.fakeStackTrace(cause, this.getTargetClass().getName());
            throw cause;
        }
        result = joinPoint.proceed();
        return result;
    }

    protected String createMethodPattern() {
        StringBuffer pattern = new StringBuffer();
        pattern.append(this.getReturnType().getName());
        pattern.append(' ');
        pattern.append(this.getMethodName());
        pattern.append('(');
        Class[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class parameterType = parameterTypes[i];
            pattern.append(parameterType.getName());
            if (i == parameterTypes.length - 1) continue;
            pattern.append(',');
        }
        pattern.append(')');
        return pattern.toString();
    }

    public String createAdviceNotCorrectlyMappedMessage() {
        StringBuffer cause = new StringBuffer();
        cause.append("around advices for ");
        cause.append(this.getTargetClass().getName());
        cause.append("#");
        cause.append(this.getMethodName());
        cause.append(" are not correctly mapped");
        return cause.toString();
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_methodId = fields.get("m_methodId", -1);
        this.m_targetClass = (Class)fields.get("m_targetClass", null);
        this.m_originalMethod = (Method)fields.get("m_originalMethod", null);
        this.m_result = fields.get("m_result", null);
        this.m_parameters = (Object[])fields.get("m_parameters", null);
        this.m_pointcuts = (ExecutionPointcut[])fields.get("m_pointcuts", null);
        this.m_controller = (JoinPointController)fields.get("m_controller", null);
        this.m_classMetaData = (ClassMetaData)fields.get("m_classMetaData", null);
        this.m_methodMetaData = (MethodMetaData)fields.get("m_fieldMetaData", null);
        this.m_reentrancyCheck = fields.get("m_reentrancyCheck", false);
        this.m_system = SystemLoader.getSystem(this.m_uuid);
        this.m_system.initialize();
    }

    protected Integer calculateHash(String className, MetaData metaData, String exceptionClassName) {
        int hash = 17;
        hash = 37 * hash + className.hashCode();
        hash = 37 * hash + metaData.hashCode();
        hash = 37 * hash + exceptionClassName.hashCode();
        Integer hashKey = new Integer(hash);
        return hashKey;
    }

    protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }

    public String toString() {
        return "[" + super.toString() + ": " + this.m_methodId + "," + this.m_targetClass + "," + this.m_originalMethod + "," + this.m_parameters + "," + this.m_result + "," + this.m_classMetaData + "," + this.m_methodMetaData + "," + this.m_pointcuts + "," + this.m_controller + "]";
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_targetClass);
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_originalMethod);
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_parameters);
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_result);
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_classMetaData);
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_methodMetaData);
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_pointcuts);
        result = 37 * result + MethodJoinPoint.hashCodeOrZeroIfNull(this.m_controller);
        result = 37 * result + this.m_methodId;
        return result;
    }

    protected static int hashCodeOrZeroIfNull(Object o) {
        if (null == o) {
            return 19;
        }
        return o.hashCode();
    }
}

