/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint;

import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.joinpoint.MethodJoinPoint;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;

public class StaticMethodJoinPoint
extends MethodJoinPoint {
    private static final long serialVersionUID = 1361833094714874172L;

    public StaticMethodJoinPoint(String uuid, Class targetClass, int methodId, String controllerClass) {
        super(uuid, methodId, controllerClass);
        if (targetClass == null) {
            throw new IllegalArgumentException("target class can not be null");
        }
        this.m_targetClass = targetClass;
        this.m_originalMethod = this.m_system.getMethod(this.m_targetClass, methodId);
        this.m_originalMethod.setAccessible(true);
        try {
            this.m_proxyMethod = this.m_targetClass.getDeclaredMethod(this.getMethodName(), this.m_originalMethod.getParameterTypes());
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        this.createMetaData();
        List pointcuts = this.m_system.getExecutionPointcuts(this.m_classMetaData, this.m_methodMetaData);
        this.m_pointcuts = new ExecutionPointcut[pointcuts.size()];
        int i = 0;
        Iterator it = pointcuts.iterator();
        while (it.hasNext()) {
            this.m_pointcuts[i] = (ExecutionPointcut)it.next();
            ++i;
        }
        if (this.m_pointcuts.length == 0) {
            this.handleThrowsPointcut();
        }
        this.m_cflowExpressions = this.m_system.getCFlowExpressions(this.m_classMetaData, this.m_methodMetaData);
        for (int j = 0; j < this.m_pointcuts.length; ++j) {
            if (!this.m_pointcuts[j].isNonReentrant()) continue;
            this.m_isNonReentrant = true;
            break;
        }
    }

    public Object getTargetInstance() {
        return null;
    }

    protected MethodJoinPoint deepCopy() {
        StaticMethodJoinPoint clone = new StaticMethodJoinPoint(this.m_uuid, this.m_targetClass, this.m_methodId, this.m_controller.getClass().getName());
        clone.m_originalMethod = this.m_originalMethod;
        clone.m_pointcuts = this.m_pointcuts;
        clone.m_parameters = this.m_parameters;
        clone.m_result = this.m_result;
        clone.m_classMetaData = this.m_classMetaData;
        clone.m_methodMetaData = this.m_methodMetaData;
        clone.m_controller = this.m_controller.deepCopy();
        return clone;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticMethodJoinPoint)) {
            return false;
        }
        StaticMethodJoinPoint obj = (StaticMethodJoinPoint)o;
        return StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_originalMethod, this.m_originalMethod) && StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_parameters, this.m_parameters) && StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_targetClass, this.m_targetClass) && StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_pointcuts, this.m_pointcuts) && StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_result, this.m_result) && StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_classMetaData, this.m_classMetaData) && StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_methodMetaData, this.m_methodMetaData) && obj.m_methodId == this.m_methodId && StaticMethodJoinPoint.areEqualsOrBothNull(obj.m_controller, this.m_controller);
    }
}

