/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint;

import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.IndexTuple;
import org.codehaus.aspectwerkz.System;
import org.codehaus.aspectwerkz.SystemLoader;
import org.codehaus.aspectwerkz.attribdef.AttribDefSystem;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.joinpoint.AbstractJoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodJoinPoint;
import org.codehaus.aspectwerkz.metadata.ClassMetaData;
import org.codehaus.aspectwerkz.metadata.MethodMetaData;
import org.codehaus.aspectwerkz.metadata.ReflectionMetaDataMaker;
import org.codehaus.aspectwerkz.pointcut.ThrowsPointcut;
import org.codehaus.aspectwerkz.util.Util;
import org.codehaus.aspectwerkz.xmldef.XmlDefSystem;

public class ThrowsJoinPoint
extends AbstractJoinPoint {
    protected transient System m_system;
    private static final long serialVersionUID = 6363637170952486892L;
    protected MethodJoinPoint m_methodJoinPoint;
    protected Throwable m_exception;
    protected IndexTuple[] m_adviceIndexes = new IndexTuple[0];
    protected int m_currentAdviceIndex = -1;
    protected ClassMetaData m_classMetaData;
    protected MethodMetaData m_methodMetaData;
    protected String m_uuid;

    public ThrowsJoinPoint(String uuid, MethodJoinPoint methodJoinPoint, Throwable exception) {
        if (methodJoinPoint == null) {
            throw new IllegalArgumentException("method join point can not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("exception exception can not be null");
        }
        this.m_system = SystemLoader.getSystem(uuid);
        this.m_system.initialize();
        this.m_uuid = uuid;
        this.m_methodJoinPoint = methodJoinPoint;
        this.m_exception = exception;
        this.createMetaData();
        Util.fakeStackTrace(this.m_exception, this.getTargetClass().getName());
        this.loadAdvices();
    }

    public Object proceedInNewThread() throws Throwable {
        return this.deepCopy().proceed();
    }

    public Object proceed() throws Throwable {
        Object result = null;
        ++this.m_currentAdviceIndex;
        if (this.m_currentAdviceIndex != this.m_adviceIndexes.length) {
            try {
                if (this.m_system.isAttribDef()) {
                    AttribDefSystem system = (AttribDefSystem)this.m_system;
                    IndexTuple index = this.m_adviceIndexes[this.m_currentAdviceIndex];
                    int aspectIndex = index.getAspectIndex();
                    int methodIndex = index.getMethodIndex();
                    result = system.getAspect(aspectIndex).___AW_invokeAdvice(methodIndex, this);
                } else {
                    XmlDefSystem system = (XmlDefSystem)this.m_system;
                    result = system.getAdvice(this.m_adviceIndexes[this.m_currentAdviceIndex]).doExecute(this);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                StringBuffer cause = new StringBuffer();
                cause.append("advices for ");
                cause.append(this.getTargetClass().getName());
                cause.append("#");
                cause.append(this.getMethodName());
                cause.append("#");
                cause.append(this.getExceptionName());
                cause.append(" are not correctly mapped");
                throw new DefinitionException(cause.toString());
            }
        }
        return result;
    }

    public Throwable getException() {
        return this.m_exception;
    }

    public Class getExceptionClass() {
        return this.m_exception.getClass();
    }

    public String getExceptionName() {
        return this.m_exception.getClass().getName();
    }

    public String getMessage() {
        return this.m_exception.getMessage();
    }

    public String getLocalizedMessage() {
        return this.m_exception.getLocalizedMessage();
    }

    public Object getTargetInstance() {
        return this.m_methodJoinPoint.getTargetInstance();
    }

    public Class getTargetClass() {
        return this.m_methodJoinPoint.getTargetClass();
    }

    public Method getMethod() {
        return this.m_methodJoinPoint.getMethod();
    }

    public String getMethodName() {
        return this.m_methodJoinPoint.getMethodName();
    }

    public Object[] getMethodParameters() {
        return this.m_methodJoinPoint.getParameters();
    }

    public Class[] getMethodParameterTypes() {
        return this.m_methodJoinPoint.getParameterTypes();
    }

    public Class getMethodReturnType() {
        return this.m_methodJoinPoint.getReturnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAdvices() {
        IndexTuple[] indexTupleArray = this.m_adviceIndexes;
        synchronized (this.m_adviceIndexes) {
            ArrayList<IndexTuple> adviceIndexes = new ArrayList<IndexTuple>();
            List pointcuts = this.m_system.getThrowsPointcuts(this.m_classMetaData, this.m_methodMetaData);
            Iterator it = pointcuts.iterator();
            while (it.hasNext()) {
                ThrowsPointcut throwsPointcut = (ThrowsPointcut)it.next();
                IndexTuple[] indexes = throwsPointcut.getAdviceIndexes();
                for (int j = 0; j < indexes.length; ++j) {
                    adviceIndexes.add(indexes[j]);
                }
            }
            this.m_adviceIndexes = new IndexTuple[adviceIndexes.size()];
            int i = 0;
            Iterator it2 = adviceIndexes.iterator();
            while (it2.hasNext()) {
                this.m_adviceIndexes[i] = (IndexTuple)it2.next();
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void createMetaData() {
        this.m_classMetaData = ReflectionMetaDataMaker.createClassMetaData(this.getTargetClass());
        this.m_methodMetaData = ReflectionMetaDataMaker.createMethodMetaData(this.getMethodName(), this.getMethodParameterTypes(), this.getMethodReturnType());
    }

    protected ThrowsJoinPoint deepCopy() {
        ThrowsJoinPoint clone = new ThrowsJoinPoint(this.m_uuid, this.m_methodJoinPoint, this.m_exception);
        clone.m_currentAdviceIndex = this.m_currentAdviceIndex;
        clone.m_adviceIndexes = new IndexTuple[this.m_adviceIndexes.length];
        java.lang.System.arraycopy(this.m_adviceIndexes, 0, clone.m_adviceIndexes, 0, this.m_adviceIndexes.length);
        return clone;
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_uuid = (String)fields.get("m_uuid", null);
        this.m_currentAdviceIndex = fields.get("m_currentAdviceIndex", -1);
        this.m_classMetaData = (ClassMetaData)fields.get("m_classMetaData", null);
        this.m_methodMetaData = (MethodMetaData)fields.get("m_fieldMetaData", null);
        this.m_methodJoinPoint = (MethodJoinPoint)fields.get("m_methodJoinPoint", null);
        this.m_exception = (Throwable)fields.get("m_exception", null);
        this.m_adviceIndexes = (IndexTuple[])fields.get("m_adviceIndexes", null);
        this.m_system = SystemLoader.getSystem(this.m_uuid);
        this.m_system.initialize();
    }
}

