/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint.control;

import java.io.ObjectInputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.codehaus.aspectwerkz.attribdef.AttribDefSystem;
import org.codehaus.aspectwerkz.joinpoint.MethodJoinPoint;
import org.codehaus.aspectwerkz.joinpoint.control.JoinPointController;
import org.codehaus.aspectwerkz.pointcut.ExecutionPointcut;
import org.codehaus.aspectwerkz.xmldef.XmlDefSystem;
import org.codehaus.aspectwerkz.xmldef.advice.Advice;

public abstract class AbstractJoinPointController
implements JoinPointController {
    protected int m_currentAdviceIndex = -1;
    protected int m_currentPointcutIndex = 0;

    public void addAdvice(String adviceName, MethodJoinPoint jp, ExecutionPointcut pc) {
        if (adviceName == null) {
            throw new IllegalArgumentException("advice can not be null");
        }
        if (jp == null) {
            throw new IllegalArgumentException("joinpoint can not be null");
        }
        if (pc == null) {
            pc = jp.getPointcuts()[this.m_currentPointcutIndex];
        }
        pc.addAdvice(adviceName);
    }

    public void removeAdvice(String adviceName, MethodJoinPoint joinPoint, ExecutionPointcut pointcut) {
        if (adviceName == null) {
            throw new IllegalArgumentException("advice can not be null");
        }
        if (joinPoint == null) {
            throw new IllegalArgumentException("joinpoint can not be null");
        }
        if (pointcut == null) {
            pointcut = joinPoint.getPointcuts()[this.m_currentPointcutIndex];
        }
        pointcut.removeAdvice(adviceName);
    }

    public static Iterator getAllAdvices(MethodJoinPoint joinPoint, boolean asSet) {
        AbstractCollection cAdvices = asSet ? new HashSet() : new ArrayList();
        if (joinPoint.getSystem().isAttribDef()) {
            AttribDefSystem system = (AttribDefSystem)joinPoint.getSystem();
        } else {
            XmlDefSystem system = (XmlDefSystem)joinPoint.getSystem();
            for (int i = 0; i < joinPoint.getPointcuts().length; ++i) {
                for (int j = 0; j < joinPoint.getPointcuts()[i].getAdviceIndexes().length; ++j) {
                    cAdvices.add(system.getAdvice(joinPoint.getPointcuts()[i].getAdviceIndex(j)));
                }
            }
        }
        return cAdvices.iterator();
    }

    public static void purgePointcuts(MethodJoinPoint joinPoint) {
        int i;
        int num = 0;
        for (i = 0; i < joinPoint.getPointcuts().length; ++i) {
            if (joinPoint.getPointcuts()[i].getAdviceIndexes().length <= 0) continue;
            ++num;
        }
        ExecutionPointcut[] purgedPointcuts = new ExecutionPointcut[num];
        num = 0;
        for (i = 0; i < joinPoint.getPointcuts().length; ++i) {
            if (joinPoint.getPointcuts()[i].getAdviceIndexes().length <= 0) continue;
            purgedPointcuts[num] = joinPoint.getPointcuts()[i];
            ++num;
        }
        joinPoint.setPointcuts(purgedPointcuts);
    }

    public int clearRedundancy(MethodJoinPoint joinPoint, String adviceName, boolean purge) {
        int iFound = 0;
        if (joinPoint.getSystem().isAttribDef()) {
            AttribDefSystem system = (AttribDefSystem)joinPoint.getSystem();
        } else {
            XmlDefSystem system = (XmlDefSystem)joinPoint.getSystem();
            for (int i = 0; i < joinPoint.getPointcuts().length; ++i) {
                for (int j = 0; j < joinPoint.getPointcuts()[i].getAdviceIndexes().length; ++j) {
                    if (!system.getAdvice(joinPoint.getPointcuts()[i].getAdviceIndex(j)).getName().equals(adviceName) || ++iFound <= 1) continue;
                    this.removeAdvice(adviceName, joinPoint, joinPoint.getPointcuts()[i]);
                }
            }
        }
        if (purge) {
            AbstractJoinPointController.purgePointcuts(joinPoint);
        }
        return iFound - 1;
    }

    public int clearAllRedundancies(MethodJoinPoint jp) {
        Iterator it = AbstractJoinPointController.getAllAdvices(jp, true);
        int iRedundancies = 0;
        while (it.hasNext()) {
            Advice advice = (Advice)it.next();
            iRedundancies += this.clearRedundancy(jp, advice.getName(), false);
        }
        AbstractJoinPointController.purgePointcuts(jp);
        return iRedundancies;
    }

    public abstract Object proceed(MethodJoinPoint var1) throws Throwable;

    public abstract JoinPointController deepCopy();

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.m_currentAdviceIndex;
        result = 37 * result + this.m_currentPointcutIndex;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractJoinPointController)) {
            return false;
        }
        AbstractJoinPointController obj = (AbstractJoinPointController)o;
        return obj.m_currentPointcutIndex == this.m_currentPointcutIndex && obj.m_currentAdviceIndex == this.m_currentAdviceIndex;
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_currentAdviceIndex = fields.get("m_currentAdviceIndex", -1);
        this.m_currentPointcutIndex = fields.get("m_currentPointcutIndex", -1);
    }
}

